#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// prototypes
void slaCldj ( int iy, int im, int id, double *djm, int *j );
double slaGmst(double); // input UT in modified JD
void slaAltaz ( double ha, double dec, double phi,
                double *az, double *azd, double *azdd,
                double *el, double *eld, double *eldd,
                double *pa, double *pad, double *padd ); // all radians
double slaAirmas(double zd); // zenith distnace in radians


main()
{
  FILE *fh=stdin;
  char buf[512];
  char sdummy[256];
  char name[40], location[40];
  int i, lh,lm, ad, am, iy, im, id, ihou, imin;
  char c;
  float lat, lon, ls, as, fsec;
  double djm;  // Modified Julian Date (JD-2400000.5) 
  double dst;
  int  irah, iram, ided, idem;
  float fras, fdes;
  double dra, dde;
  double az, azd, azdd, el, eld, eldd, pa, pad, padd;
  double dam; //airmass
  double ddista, dvmag, dpha, delong, dmura, dmude;
  int ielevstatus=0;


  for (i=0; i<5; i++) if (NULL==fgets(buf,512,fh)) break;
  if (i<5) {printf("e> error skipping header\n"); exit -1;}
  // extract asteroid info
  strncpy(name, &buf[12], 40);
  printf("Asteroid: %s",name);
  
  for (i=0; i<4; i++) if (NULL==fgets(buf,512,fh)) break;
  if (i<4) {printf("e> error skipping header\n"); exit -1;}
  strncpy(location, &buf[27], 40);
  printf("Location: %s",location);


  fgets(buf,512,fh);
  sscanf(buf, "%c %d %c %d %c %f %c %c %c %d %c %d %c %f %c %c",
	 &c, &lh, &c, &lm, &c, &ls, &c,&i,&c, &ad, &c, &am, &c, &as, &c, &c);
//  4 h 41 m 37.034 s W , 24 d 37 ' 37.955 " S , 2637.14 m
  lon=1.0*lh+1.0*lm/60.+ls/3600.;
  if (i=='W') lon=-lon;
  lat=1.0*ad+1.0*am/60.+as/3600.;
  if (c=='S') lat=-lat;
  printf("coords: %f hours %f deg \n",lon,lat);
  for (i=0; i<4; i++) if (NULL==fgets(buf,512,fh)) break;
  if (i<4) {printf("e> error skipping header\n"); exit -1;}

  printf("-----------------------------------------------------------------------------------------------------\n");
  printf("date       UT          RA             DEC         muRAcosDE  muDE       AM   V     pha  elong  pa\n");
  printf("                                                  arcsec/s   arcsec/s              deg  deg    deg\n");
  printf("-----------------------------------------------------------------------------------------------------\n");
  //      2011-07-20T22:00:00.00 14:32:56.8593 -17:04:18.81 +0.010400 -0.002450   1.08 14.2  27.9 103.6 -126.50

  while (1)
    {
      if (NULL==fgets(buf,512,fh)) break;
      //      printf("%s",buf);
      sscanf(buf, "%4d-%02d-%02dT%02d:%02d:%5f %d %d %f %d %d %f %lf %lf %lf %lf %lf %lf", 
	     &iy, &im, &id,&ihou,&imin,&fsec, &irah, &iram, &fras, &ided, &idem, &fdes,
	     &ddista, &dvmag, &dpha, &delong, &dmura, &dmude);
      slaCldj(iy, im, id, &djm, &i);
      djm+=1.0*ihou/24+1.0*imin/24./60.+fsec/24/3600.;
      dst=slaGmst(djm)+lon/12*3.1415926535;  // greenweech + long (- is west) in radians
      dra=1.0*irah+1.0*iram/60.0+fras/3600;
      dra=dra/12*3.1415926535; //in radians
      dde=1.0*ided; 
      if (dde<0) dde=dde-1.0*idem/60.0-fdes/3600; else dde=dde+1.0*idem/60.0+fdes/3600;
      slaAltaz((dst-dra), dde/180*3.1415926535, lat/180*3.1415926535, 
	       &az, &azd, &azdd, &el, &eld, &eldd, &pa, &pad, &padd);
      if (el<=0) dam=99.9; else dam=slaAirmas(3.1415926535/2-el);
 /*      
	 printf("%4d-%02d-%02dT%02d:%02d:%05.2f--%lf ST:%lf V:%4.1lf pha:%5.1lf elong:%5.1lf az:%5.1lf, elev:%5.1lf am:%5.2lf pa:%6.2lf\n", 
	     iy, im, id,ihou,imin,fsec,djm,dst,
	     dvmag, dpha, delong,
	     az*180/3.1415926535,  el*180/3.1415926535,
	     dam, pa*180/3.1415926535);
 */
      if (el>=0) 
	{
	  printf("%4d-%02d-%02dT%02d:%02d:%05.2f ",iy, im, id,ihou,imin,fsec); //date and time
	  printf("%02d:%02d:%07.4f ",irah,iram,fras); //RA     
	  printf("%+03d:%02d:%05.2f ",ided,idem,fdes); //DEC
	  printf("%+9.6lf %+9.6lf ", dmura, dmude);
	  printf("%6.2lf %4.1lf %5.1lf %5.1lf %+6.2lf", dam, dvmag, dpha, delong, pa*180/3.1415926535);
	  printf("\n");
	  ielevstatus=1;
	} else 
	{
	  if (ielevstatus==1) 
	    {
	      printf("-----------------------------------------------------------------------------------------------------\n");
	      printf("              --- ELEVATION CUTOFF --- \n");
	      printf("-----------------------------------------------------------------------------------------------------\n");
	    }
	  ielevstatus=0;
	}
    }
}


//        Date UTC              R.A            Dec.          Distance     V.Mag   Phase   Elong.  muRAcosDE    muDE     Dist_dot
//             h  m  s       h  m  s         o  '  "            au.                  o        o      "/s        "/s        km/s
//  2011-07-23T15:30:00.02   14 35 58.00584 -17 14  5.5205    1.661019540   14.24   28.04   101.74  0.114E-01 -0.267E-02   19.2161
