#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#define  PI  	3.1415926535897932384626433832795
#define  RAD 	0.017453292519943295769236907684886 // PI/180
#define	BUFLEN	256

int		iverbose;
int		irad=0;		// if set to 1 uses input and output in RADIAN

main(int argc, char* argv[])
{
	int		j;
	char	buf[BUFLEN] ; 	//buffer used read data
	double	dsun, arsun;
	double  dast, arast;
	double  anum, aden, tetsc, tetnor;
	double	teta, tetar, p, pa, pcor, epcor, ep, epa;
	FILE    *fi=stdin;

	for (j=0; j<argc/2; j++)	// scan additional parameters
	{
/*		if (strncmp(argv[j*2+1], "-f", 2)==0)
		{
			strcpy(filename, argv[j*2+2]);
			filemode=1;
		}
*/		if (strncmp(argv[j*2+1], "-v", 2)==0)
			iverbose=atoi(argv[j*2+2]);
		if (strncmp(argv[j*2+1], "-r", 2)==0)
			irad=atoi(argv[j*2+2]);
	}


	while (NULL!=fgets(buf, BUFLEN, fi))
	{
		if ((sscanf(buf, "%lf %lf %lf %lf %lf %lf %lf %lf",
			    &arast, &dast, &arsun, &dsun, &p, &ep, &pa, &epa) < 8))
		    {
				printf("error while scanning line\n");
				printf("Input: RAast, DECast, RAsun, DECsun, P, sigma_p, Pos.Angle, sigma_pos.angle\n");
				return -1;
//		  		continue;	// if error continue scaning next line
			}
		if (iverbose)
		{
			printf("Asteroid and Sun coordinates\n");
			printf("%lf %lf %lf %lf %lf %lf\n",
			  		  arast, dast, arsun, dsun, p, pa);
		}

		if (!irad)	// convert to radians
		{
			arast*=RAD;
			dast*=RAD;
			arsun*=RAD;
			dsun*=RAD;
		} else
		{

		}

 	anum=cos(dsun)*sin(arast-arsun);
  	aden=cos(dsun)*sin(dast)*cos(arast-arsun)-sin(dsun)*cos(dast);
    	tetsc=atan2(anum,aden)*57.2958;
    	if (tetsc < 0.) tetsc+=180.;
    	tetnor=tetsc-90.;

    	if (tetnor < 0.0) tetnor+=180.0;
//  	    write(*,*)tetsc,tetnor
    	teta=fabs(pa-tetnor);
//        tetar=teta*.017453;
    	pcor=p*cos(2.*teta*RAD);
	epcor = sqrt( pow(cos(2.*teta*RAD)*ep,2) + 4*p*p*pow(sin(2.*teta*RAD)*epa*RAD,2) );

//    	printf("%lf %lf %lf %lf %lf\n", p, pa, tetnor, pcor, teta);
    	printf("%7.4lf %7.4lf %9.4lf %9.4lf\n", pcor, epcor, teta, tetnor);
  	}
}

/*
      ANUM=COS(DSUN)*SIN(ARAST-ARSUN)
      ADEN=COS(DSUN)*SIN(DAST)*COS(ARAST-ARSUN)-SIN(DSUN)*COS(DAST)
      TETSC=ATAN2(ANUM,ADEN)*57.2958
      IF(TETSC.LT.0.)TETSC=TETSC+180.
      TETNOR=TETSC-90.
      IF(TETNOR.LT.0.)TETNOR=TETNOR+180.
C      WRITE(*,*)TETSC,TETNOR
      TETA=ABS(PA-TETNOR)
      TETAR=TETA*.017453
      PCOR=P*COS(2.*TETAR)
*/
