#define CONSTANTS_H

// Constants

#define  PI  3.1415926535897932384626433832795
#define  RAD 0.017453292519943295769236907684886 // PI/180
#define  STEFBOLTZ 5.670373 // Stefan Boltzmann Constant
#define  SOLARCONSTANT 1.373 // Solar Constant outside atmosphere
#define  TWOPI 6.283185307179586476925286766559
#define  PI_2  1.5707963267948966192313216916398 // PI/2
#define  AU 149597910.   // AU in Km

#define	AUm		1.495985e11		// Astronomical unit in meters
#define SIGMA		5.67051e-8		// Stefan-Boltzmann constant J m^{-2} s^{-1} K^{-4}
#define SOLARC	        1373.0			// Solar constant at 1 AU W/m^2 at 1 AU
#define	CSPEED		2.9979853e8		// Speed of light meter
#define TSS1AU		394.468296077	// [SOLARC/SIGMA]^0.25

/* pi */
#define DPI		3.1415926535897932384626433832795028841971693993751
/* 2pi */
#define D2PI		6.2831853071795864769252867665590057683943387987502
/* 1/(2pi) */
#define D1B2PI		0.15915494309189533576888376337251436203445964574046
/* 4pi */
#define D4PI		12.566370614359172953850573533118011536788677597500
/* 1/(4pi) */
#define D1B4PI		0.079577471545947667884441881686257181017229822870228
/* pi^2 */
#define DPISQ		9.8696044010893586188344909998761511353136994072408
/* sqrt(pi) */
#define DSQRPI		1.7724538509055160272981674833411451827975494561224
/* pi/2:  90 degrees in radians */
#define DPIBY2		1.5707963267948966192313216916397514420985846996876
/* pow(100, 1/5) */
#define MAGBASE		2.5118864315095801110850320677993
/* 180/pi:  conversion radian to degrees */
#define RADEG		57.295779513082320876798154814114

	/*  NIST value (1999): 2 pi h c^2 = 3.741 7749(22) ? 10-16 W m2  */
#define NIST_C1		3.7417749e8		// e8 due to lambda in um and Area in km^2
	/*  NIST value (1999):  h c / k  = 0.014 387 69 m K */
#define NIST_C2 	14387.69	// e+6 due to lambda in um


#define SOLARBBTEMPERATURE 5778.0   // solar black body temperature
#define SOLARVMAG          -26.74   // solar V mag
#define SOLARFLUX36MANT    5.5464951// mantissa solar flux at 3.6 um 
#define SOLARFLUX36EXP     13.0     // exponent solar flux at 3.6 um 

#define SOLARFLUX335MANT   5.895    // mantissa solar flux at 3.35 um
#define SOLARFLUX335EXP    13         // exponent solar flux at 3.35 um 


#define	HG_A1  3.33
#define	HG_B1  0.63
#define	HG_A2  1.87
#define	HG_B2  1.22
