// this is front end interface to fittm and tmflux

#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "tm.h"
#define	MODE_VERBOSE 	1
#define MODE_FILE	2

#define HELP "Version 1.0"

int stringcompress(char* src, char* dest)
{
	int	N=strlen(src);
	int	i,j=0;

	for(i=0; i<N; i++)
	{
		if ((src[i]<33) || (src[i]>126))
			continue;
		dest[j]=src[i];
		if ((dest[j]==':') || (dest[j]=='.')  ||
		    (dest[j]=='<') || (dest[j]=='>')  ||
		    (dest[j]=='|') || (dest[j]=='\\') ||
		    (dest[j]=='/') || (dest[j]=='!')  ||
		    (dest[j]=='~') || (dest[j]=='-') )
		  dest[j]='_';
		j++;
	}
	dest[j]=0;
}

int stringcompressNoClean(char* src, char* dest)
{
	int	N=strlen(src);
	int	i,j=0;

	for(i=0; i<N; i++)
	{
		if ((src[i]<33) || (src[i]>126))
			continue;
		dest[j]=src[i];
		j++;
	}
	dest[j]=0;
}

int strfnd(char *src, char *pattern)
{
	int	N=strlen(src), M=strlen(pattern), NN=N-M;
	int	i;

	for(i=0; i<NN; i++)
	  if (strncmp(&src[i], pattern, M)==0)
	    return i;

 	return -1;
}

int runTMflux(char model, char*inidata, char* name, char* results, char*swrange)
{
	pid_t 	pid;
	int 	rv;
	FILE*	fh=NULL;
	char	sdummy[64], smodel[64], sH[64], sG[64],
			sepsilon[64], seta[64], sD[64], spV[64],
			sr[64], sDelta[64], salpha[64];
	char	fname[255];
	char    swini[64], swend[64], swstep[64];


	if (sscanf(swrange, "%s %s %s", &swini, &swend, &swstep)!=3)
	  {
	    strcpy(swini,"4"); 
	    strcpy(swend,"25"); 
	    strcpy(swstep,"1.0");// ground based thermal IR obs.
	  }

	smodel[0]=model;
	smodel[1]=0;
	sscanf(inidata, "%s %s %s %s %s %s %s %s", sH, sG , sepsilon, sdummy, sdummy, sr, sDelta, salpha);
//	printf("%s %s %s %s %s %s \n", sH, sG , sepsilon, sr, sDelta, salpha);
	sscanf(results, "%s %s %s %s %s %s %s %s", sdummy, sD, sdummy, spV, sdummy, seta, sdummy, sdummy);

	strcpy(fname, name);
	strcat(fname, "_");
	strcat(fname, smodel);


	/* Attempt to fork and check for errors */
	if( (pid=fork()) == -1){
		fprintf(stderr,"Fork error. Exiting.\n");  /* something went wrong */
		exit(1);
	}

	if(pid){
		wait(&rv);				/* Wait for child process to end */
	}
	else{
		/* Replace the child fork with a new process */
		if(execl("tmflux","tmflux",
			     "-o", fname, "-l", swini, swend, swstep,
				smodel,
				sD, spV, sG, sepsilon, seta, sr, sDelta, salpha,
				NULL) == -1){
//			fprintf(stderr,"execl Error tmflux!");
			
			if(execlp("tmflux","tmflux",
			     "-o", fname, "-l", swini, swend, swstep, 
				smodel,
				sD, spV, sG, sepsilon, seta, sr, sDelta, salpha,
				NULL) == -1){
			fprintf(stderr,"execlp also Error: cannot start tmflux!\n");
			fprintf(stderr,"no way, need to exit!\n");
			exit(1); 
		   	}
		}
	}

}


runTMfit(char model, char* inidata, char* datafilename, char* results)
{
		pid_t 	pid;
		int 	rv;
		int	pipea[2];		/// This holds the fd for the input & output of the pipe
		int	pipeb[2];
		FILE*	tmpfh=NULL;
		char	str[512];
		FILE*	buf;
		double	data[7];
		int	i, iNel, itofit;
		double	w, f, ef;

				
				pipe(pipea);	// write to child
				pipe(pipeb);	// read from child
				// Attempt to fork and check for errors
				if( (pid=fork()) == -1){
					fprintf(stderr,"Fork error. Exiting.\n");  // something went wrong
					exit(1);
				}

			  	if (pid)
			  	{
			     	  close(pipea[0]);		// Close unused side of pipe (in side)
			          str[0]=model;
			          str[1]=32; str[2]=0;
				  write(pipea[1], str, 2);
				  write(pipea[1], inidata, strlen(inidata));

				  if ( (tmpfh=fopen(datafilename,"rt"))==NULL)
				  {
				    fprintf(stderr, "Cannot open temporary file:%s\n", datafilename);
				    exit(1);
				  }

				  while (!feof(tmpfh))
				  {
  				    iNel=0;
				    memset(str,0,512);
				    fgets(str,255,tmpfh);
//				    printf("%s",str);
			 	    iNel=sscanf(str, "%lf%lf%lf%d", &w, &f, &ef, &itofit);
//				    printf("%lf %lf %lf %ld %d\n",  w, f, ef, itofit, iNel);
				    if ((iNel==3) || ((iNel==4) && (itofit==0)) ) {
				      memset(str,0,512);
                                      sprintf(str, "%lf %lf %lf\n", w, f, ef);
				      write(pipea[1], str, strlen(str));
//				      printf("sent\n");
				    }
				    if (iNel==EOF) write(pipea[1], "q\n", 2);
				  } 
			      	  fclose(tmpfh);
				  close(pipeb[1]);	// close the out side

				  wait(&rv);
				  memset(results, 0, 255);
			  	  read(pipeb[0], results, 255);	//read the pipe
			  	  switch (model)
			  	  {
					  case '0': printf("NEATM     "); break;
					  case '1': printf("NEATM-fix "); break;
					  case '2': printf("STM(refin)"); break;
					  case '3': printf("FRM       "); break;
					  case '4': printf("STM-fix   "); break;
				  }
				  sscanf(results, "%s %lf %lf %lf %lf %lf %lf %lf", str, &data[0], &data[1],
				      &data[2], &data[3], &data[4], &data[5], &data[6]);
				  for (i=0; i<7; i++)
				    printf("%8.3f",data[i]);

				  printf("\n");

				  close(pipea[1]);	// after having sent all data close also the outside
				  close(pipeb[0]);	// after having sent all data close also the outside
				}
			  	else
			  	{
				  dup2(pipeb[1],1);		// Replace stdout with out side of the pipe
			     	  close(pipeb[0]);		// Close unused side of pipe (in side)
			      	  setvbuf(stdout,(char*)NULL,_IONBF,0);	// Set non-buffered output on stdout
			      	  fclose(stderr);

				  dup2(pipea[0],0);		// Replace stdin with the in side of the pipe
				  close(pipea[1]);		// Close unused side of pipe (out side)

				  if (execl("fittm","fittm", NULL)==-1)
				  {
//				  	fprintf(stderr,"execl Error: cannot start fittm!\n");
				  	if (execlp("fittm","fittm", NULL)==-1) // try with execlp
					{
				  	  fprintf(stderr,"execlp also Error: cannot start fittm!\n");
				  	  fprintf(stderr,"no way, need to exit!\n");
				  	  exit(1); 
					}
				  }
				exit(127);
			    }

}


runGnuplot(char*name, char*swrange)
{
		FILE* gnup;
		pid_t 	pid;
		int 	rv;
		int	ptogp[2];		/// This holds the fd for the input & output of the pipe
		int	pfromgp[2];
		char	str[2000];
		char    swini[64], swend[64];
		char    cname[255];

		stringcompress(name,cname);

		if (sscanf(swrange, "%s %s", &swini, &swend)!=2)
		  {
		    strcpy(swini,"4"); 
		    strcpy(swend,"25");// ground based thermal IR obs.
		  }

		pipe(ptogp);	//write to child
		pipe(pfromgp);	//read from child
				// Attempt to fork and check for errors
		if( (pid=fork()) == -1){
					fprintf(stderr,"Fork error. Exiting.\n");  // something went wrong
					exit(1);
		}

		if (pid)
		{
		  close(ptogp[0]);		// Close unused side of pipe (in side)
		  sprintf(str,"set xlabel 'wavelength (microns)'\n");
		    write(ptogp[1], str, strlen(str));
		  sprintf(str,"set title '%s'\n", name);
		    write(ptogp[1], str, strlen(str));
		  sprintf(str,"set ylabel 'flux (Jy)'\n");
		    write(ptogp[1], str, strlen(str));
		  sprintf(str,"unset logscale y\n");
		    write(ptogp[1], str, strlen(str));
		    sprintf(str,"set xrange [%s:%s]\n", swini, swend);
		    write(ptogp[1], str, strlen(str));
		    //		  sprintf(str,"set yrange [0:2.5]\n");
		    //		    write(ptogp[1], str, strlen(str));
		  sprintf(str,"set term postscript\n");
		    write(ptogp[1], str, strlen(str));
		  sprintf(str,"set out '%s.ps'\n", cname);
		    write(ptogp[1], str, strlen(str));
		  sprintf(str,"plot '%s' u 1:2:3 w errorbar tit 'data', '%s_0' w lin tit 'NEATM', '%s_1' w lin tit 'NEATM-fix', '%s_2' w lin tit 'STM','%s_3' w lin tit 'FRM','%s_4' w lin tit 'STM-fix'\n", cname, cname, cname, cname, cname, cname);
		    write(ptogp[1], str, strlen(str));
		  sprintf(str,"set out \n");
		    write(ptogp[1], str, strlen(str));
		  sprintf(str,"quit \n");
		    write(ptogp[1], str, strlen(str));

		  close(ptogp[1]);	// close the out side

		  wait(&rv);

		  close(ptogp[1]);	// after having sent all data close also the outside
		  close(pfromgp[0]);	// after having sent all data close also the outside
		  close(pfromgp[1]);	// after having sent all data close also the outside
		}
		else
		{
		  dup2(pfromgp[1],1);		// Replace stdout with out side of the pipe
		  close(pfromgp[0]);		// Close unused side of pipe (in side)
		  setvbuf(stdout,(char*)NULL,_IONBF,0);	// Set non-buffered output on stdout

		  dup2(ptogp[0],0);		// Replace stdin with the in side of the pipe
		  close(ptogp[1]);		// Close unused side of pipe (out side)
//	          fclose(stderr);

		  if (execlp("gnuplot","gnuplot", NULL)==-1)
		  {
		      fprintf(stderr,"execl Error: gnuplot not found!");
		      exit(1);
		  }
		  exit(127);
		}
/*
	gnup = popen("gnuplot", "w");
	fprintf(gnup,"set xlabel 'wavelength (microns)'\n");
	fprintf(gnup,"set ylabel 'flux (Jy)'\n");
	fprintf(gnup,"set term postscript\n");
	fprintf(gnup,"set out '%s.ps'\n", name);
	fprintf(gnup,"plot '%s' u 1:2:3 w errorbar tit 'data', '%s_0' w lin tit 'NEATM', '%s_1' w lin tit 'NEATM-fix', '%s_2' w lin tit 'STM','%s_3' w lin tit 'FRM'\n", name, name, name, name, name);
	fprintf(gnup,"set out \n");
	fprintf(gnup,"quit \n");
*/
}

main(int argc, char* argv[])
{
	int	mode=0;
	char	filename[255];
	FILE*	fh=NULL;
	char	str[255];
	int	recini=0, recend=0;
	int	isdata=0;
	char	name[255], ename[255];
	FILE*	tmpfh=NULL;
	char	myarg[255];
	char	models[255];
	char	inidata[255];
	int	Nmod, i;
	char	buf[255];
	char    swrange[255];

	while (argc>1)
	{
		if (argv[1][0]=='-')
		{
    		  switch (argv[1][1])
    		  {
			case 'f': 	// get the filename
				mode+=MODE_FILE;
				argc--; argv++;
				strcpy(filename,argv[1]);
				break;
			case 'h':
				printf("%s\n", HELP);
				return -1;
				break;
			case 'v':
				  mode+=MODE_VERBOSE;
				break;
			default:
				printf("unknown option -%s\n",argv[1][1]);
				return 0;
				break;
		  }//switch
		}//if
	    argc--; argv++;
	 }//while

//	printf("%d\n",mode);



	if ((mode & MODE_FILE)!=MODE_FILE) //uses stdin
	  fh=stdin; //scanf("%s", filename);

	if ((MODE_VERBOSE & mode)==MODE_VERBOSE)
	  printf("using input file %s\n", filename);

	if ((mode & MODE_FILE)==MODE_FILE)
	{
		if ( (fh=fopen(filename, "rt"))==NULL)
		{
	  		fprintf(stderr,"file error!\n");
			exit(1);
		} else
		{
			if ((MODE_VERBOSE & mode)==MODE_VERBOSE)
	  		  printf("input file secussfully open\n");
		}
	}

	recini=recend=0;
	do{
		fgets(str,255,fh);
		stringcompressNoClean(str,buf);

		if ((MODE_VERBOSE & mode)==MODE_VERBOSE)
	  		printf("v>%s\n", buf);

		if (strncmp(buf, "<data>", 6)==0)
		{
			if ((MODE_VERBOSE & mode)==MODE_VERBOSE)
	  			printf("i>beginning of data deteced...\n", name);
		  isdata=1;

		  fgets(str,255,fh);	// read object name
//		  strcat(str, " ");		// add a space
//		  str[strlen(str)-1]='\0';
//		  printf("%s",str);
		  strncpy(ename,str,strlen(str));
		  stringcompress(str,name);
		  fgets(str,255,fh);	// read models to be fitted
		  stringcompress(str,models);

		  fgets(swrange,255,fh);	// read wavelength range for plotting and tmflux output

		  fgets(inidata, 255, fh);
		  printf("%s", ename);
		  printf("%10s%8s%8s%8s%8s%8s%8s%8s\n", "model", 
			 "D", "eD", "pV", "epV", "eta", "eeta", "Chisq");

		  tmpfh=fopen(name,"wt");

		  continue;
		}

		if ((strncmp(buf, "<\\data>", 7)==0) && (isdata))
		{
			if ((MODE_VERBOSE & mode)==MODE_VERBOSE)
	  			printf("i>data end detected... PROCESSING DATA\n", name);

			if (tmpfh) fprintf(tmpfh, "q\n");
		  	if (tmpfh) fclose(tmpfh);

			Nmod=strlen(models);
			if ((MODE_VERBOSE & mode)==MODE_VERBOSE)
	  			printf("i>models %s\n", models);

			for (i=0; i<Nmod; i++)
			{
			  runTMfit(models[i],  inidata, name, str);
		      	  runTMflux(models[i], inidata, name, str,swrange);
			}
			runGnuplot(ename,swrange);
		    isdata=0;
		}

		if(isdata)
		{ if (tmpfh)
			fprintf(tmpfh,"%s", str);
		  else
		  	printf("%s", str);
		}
	} while (!feof(fh));

	if ((fh) && ((mode & MODE_FILE)!=MODE_FILE)) fclose(fh);

}

