#define MACROS_H

#ifndef max
#define max( a, b ) ( ((a) > (b)) ? (a) : (b) )
#endif

#ifndef min
#define min( a, b ) ( ((a) < (b)) ? (a) : (b) )
#endif


//-----SCALAR PRODUCTS and MORE------------------------------
#define SCALAR(u, v) \
	(u.x*v.x + u.y*v.y + u.z*v.z)

//vector product x component
#define VECx(a, b) \
    (a.y*b.z - a.z*b.y)

//vector product y component
#define VECy(a, b) \
    (a.z*b.x - a.x*b.z)

//vector product z component
#define VECz(a, b) \
    (a.x*b.y - a.y*b.x)

//scalar triple

#define SCALAR_TRIPLE(u, v, w)  \
	(u.x*VECx(v,w) +			\
     u.y*VECy(v,w) +			\
	 u.z*VECz(v,w))

//Vector lenght NORMA
#define NORMA(v)				\
	(sqrt(v.x*v.x +				\
          v.y*v.y +				\
	      v.z*v.z))

//Vector lenght NORMA SQUARED
#define NORMAQ(v)				\
	(v.x*v.x +				\
     v.y*v.y +				\
	 v.z*v.z)

//-----PLANCK FUNCTION---------------------------------------
/*  NIST value (1999): 2 pi h c^2 = 3.741 7749(22)  10-16 W m2  */
#define PLANCK_C1	3.7417749e-16
/*  NIST value (1999):  h c / k  = 0.014 387 69 m K */
#define PLANCK_C2	0.01438769

	// this function returns the Power flux per
	// unit area and unit frequency.
	// W / m^2 / Hz
	// if you want W/m^2/micron you must remove the w*w/CSPEED
	// value and divide by 1.0E6 becuase the the unit wave lenght
	// is in meters
	// checked with the Alan flux on 06Dec99

#define PLANCK_M_W(w, Temp)				\
	    ((PLANCK_C1 / ((w*w*w*w*w) *	\
		(exp(PLANCK_C2/(w* Temp)) - 1.0)))/1.e6)

#define PLANCK_M_Jy(w, Temp)			\
		((PLANCK_C1 / ((w*w*w*w*w) *	\
		(exp(PLANCK_C2/(w* Temp)) - 1.0)))*w*w/CSPEED*1.e26)

#define BRIGHTNESS_TEMP_M_Jy(w, flux)	\
		(PLANCK_C2 / w /				\
			log(PLANCK_C1/w/w/w/flux/CSPEED*1.e26+1))

//-----ASTEROID PHOTOMETRIC FUNCTIONs---------------------------------------

// this function returns the diamter in km given the H value
// and the geometric albedo pv
#define H2DIAM(h, pv)					\
		(1329/sqrt(pv)*pow(10.0, -h/5.0))

// this function returns the geometric albedo given the H value
// and the diamter in km
#define H2Pv(h, D)					\
		(1766241./(D*D)*pow(10.0, -h/2.5))

// this function returns the H value given the diameter in km
// and the geometric albedo pv
#define DIAM2H(D, pv)					\
	    (-5.0*log10(sqrt(pv)/1329.0*D))

// this function return D given Pv and H
#define DIAM_H2PV(D, h)					\
	    (1766241.0/D/D*pow(10.0, -h/2.5))

// this function returns the Bond Albedo A given the G value
// and the geometric albedo pv
#define Pv2A(pv, G)						\
		(pv*(0.29 + 0.684*G))

// this function returns the Geometric visibile albedo
// given the G value
// and the bolometruc Bond Albedo A
#define A2Pv(A, G)						\
		(A/(0.29 + 0.684*G))

//-----ASTEROID THERMAL INFRARED FUNCTIONs---------------------------------------
// this function returns the subsolar point temperature given all
// this parameters:
// A is the bond albedo
// eta is the beaming parameter
// r is the distance from the sun in AU
// eps is the emissivity of the surface
#define TSS(A, eta,	r, eps)			\
		(pow((SOLARC/(r*r)*(1.0-A)/(eta*eps*SIGMA)), 0.25))

// this function returns the subsolar point temperature
// for the Fast Rotating Model
// given this parameters:
// A is the bond albedo
// r is the distance from the sun in AU
// eps is the emissivity of the surface
#define TSSFRM(A, r, eps)			\
        (pow(SOLARC/(r*r)*(1.0-A)/(eps*DPI*SIGMA), 0.25))


#define BBFlux_Jy(w, T, eps, R, delta)	\
	    (PLANCK_M_Jy(w,T)*eps*PI*R*R/	\
         (PI*delta*delta*AUm*AUm) )

// return the flux in W/m^2/um given the flux in Jy and
// the wavelength, w, in um
#define Jy2W(w,f)						\
		(f/w/w/.33357e12)

// return the flux in Jy given the flux in W/m^2/um and
// the wavelength, w, in um
#define W2Jy(w,f)						\
		(f*w*w*.33357e12)
