#define TM_H
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "macros.h"
#include "constants.h"

#define  BUFLEN 512

#define USAGE "\n\
  This is thermalp (delbo@oca.eu) [last chage: Feb 9, 2009]\n\
  enter Thermal Inertia (SI), rotation period (h), emissivity, temperature \n\
  -h this help\n\
  -s simple output: just output the thermal parameter \n"

main(int argc, char *argv[])
{
	char		buf[BUFLEN];
	double		Gamma,Trot, epsilon, Tss, Theta;
	unsigned int	output=0;

	while (argc>1)
	{
		if (argv[1][0]=='-')
		{
    			switch (argv[1][1])
    			{
				case 's': output=1;	//simple output: just output the temperature
				break;
               			case 'h': printf("%s\n",USAGE); exit(0);
                        	break;
				default:
		  			printf("unknown option -%s\n",&argv[1][1]);
                			return 0;
                      		break;
 			}
		} 
		argc--;
		argv++;
	}

        while (NULL!=fgets(buf, BUFLEN, stdin))
        {
            if ((sscanf(buf, "%lf %lf %lf %lf", &Gamma, &Trot, &epsilon, &Tss) < 4))
                break;
	    Theta = Gamma*sqrt(1.0/Trot/3600.0)/epsilon/SIGMA/Tss/Tss/Tss;
            
  	    if ((output &1)==0)
		  printf("%lf %lf %lf %lf %lf\n", Gamma, Trot, epsilon, Tss, Theta);
		else
	    	  printf("%lf\n", Theta);
        }



}
