#define TM_MODE_VERBOSE		1
#define	TM_MODE_FIXALBEDO	2
#define TM_MODE_ADDREFLCOMP     4

typedef struct tagTM
{
		double  D;		// Diameter
		double  eD;		// Diameter uncertainity
	    	double	A;		// bolometric Bond's Albedo
		double	pV;		// geometric visibile albedo
		double  epV;		// geometric visibile albedo uncertainty
		double	H, G;		// H, G system
		double	eH, eG;		// H and G uncertainties
		double	epsilon;	// infrared emissivity
		double	eta;		// beaming parameter
		double	eeta;		// eta uncertainty
		double  betaE;   	// thermal IR phase coefficient [1]
		int  	model;		// used thermal model 
		int 	flags;		// model flags verbose, fixed pv etc...
} TM;

typedef struct tagGEOM
{
		double	r;		// heliocentric distance in AU
		double  Delta;		// geocentric distance in AU
		double  pha;		// phase angle in deg.
} GEOM;



int STMflux_Jy(double  *w,      // wavelength vector in um
                double *f, 	// flux vector
                int    nw, 	// number of elements in the w vector
                double Tmax,    // Subsolar point temperature
                double epsilon, // emissivity
                double R,       // Radius of the asteroid in km
                double betaE,   // thermal IR phase coefficient [1]
                double Delta,   // distance from the earth
                double alfa,    // phase angle
                int    N);  	// number of iterations

int NEATMflux_Jy(double *w,    	// wavelength vector in um
                 double *f, 	// flux vector
                 int    nw, 	// number of elements in the w vector
                 double Tmax,   // Subsolar point temperature
                 double epsilon,// emissivity
                 double R,      // Radius of the asteroid in km
                 double Delta,  // distance from the earth
                 double alfa,   // phase angle
                 int        N); // number of iterations

int NEATMflux_W(double *w,     	// wavelength vector in um
                double *f, 	// flux vector
                int    nw, 	// number of elements in the w vector
                double Tmax,    // Subsolar point temperature
                double epsilon, // emissivity
                double R,       // Radius of the asteroid in km
                double Delta,   // distance from the earth
                double alfa,    // phase angle
                int    N);    	// number of iterations

int FRMflux_Jy(double *w,     	// wavelength vector in um
                double *f,      // flux vector
                int    nw,  	// number of elements in the w vector
                double Tmax,	// Subsolar point temperature
                double epsilon, // emissivity
                double R,       // Radius of the asteroid in km
                double Delta,   // distance from the earth
                int    N);      // number of iterations

int  FRMflux_W(double *w,       // wavelength vector in um
               double *f,       // flux vector
               int    nw,  	// number of elements in the w vector
               double Tmax,	// Subsolar point temperature
               double epsilon,  // emissivity
               double R,        // Radius of the asteroid in km
               double Delta,    // distance from the earth
               int    N);       // number of iterations

int NEATMFit(double *w,        // wavelength. vector in um
                      double *f,        // flux vector
                      double *ef,       // error on flux vector
                      int    nw,        // number of elements in w vector
                      double *R,        // Radius of the asteroid in km (1.fit param)
                      double *eR,   // Error in Diameter
                      double *Pv,       // Geometric Albedo
                      double *ePv,  // error on Pv
                      double H,         // H value
                      double *eta,      // eta value
                      double *eeta, 	// error on eta value
                      double epsilon,	// emissivity
                      double Delta,     // distance from the earth
                      double r,         // distance from the sun
                      double alfa,      // phase angle
                      double G,     	// G value
                      double *pChisq, 	// Chi squared value of the fit
                      int    N,		// number of iterations
		      int    mode);		// mode e.g Verbose

int NEATMFitFix(double *w,     		// wavelength. vector in um
                      double *f,        // flux vector
                      double *ef,       // error on flux vector
                      int    nw,        // number of elements in w vector
                      double *R,        // Radius of the asteroid in km (1.fit param)
                      double *eR,   	// Error in Diameter
                      double *Pv,       // Geometric Albedo
                      double *ePv,  	// error on Pv
                      double H,         // H value
                      double *eta,      // eta value
                      double *eeta, 	// error on eta value
                      double epsilon,	// emissivity
                      double Delta,     // distance from the earth
                      double r,         // distance from the sun
                      double alfa,      // phase angle
                      double G,         // G value
                      double *pChisq, 	// Chi squared value of the fit
                      int    N,		// number of iterations
		      int    mode);	// mode e.g Verbose


int   STMFit(double *w,        		// wavelength. vector in um
                      double *f,        // flux vector
                      double *ef,       // error on flux vector
                      int    nw,        // number of elements in w vector
                      double *R,        // Radius of the asteroid in km (1.fit param)
                      double *eR,   	// Error in Diameter
                      double *Pv,       // Geometric Albedo
                      double *ePv,  	// error on Pv
                      double H,         // H value
                      double *eta,      // eta value
                      double *eeta, 	// error on eta value
                      double epsilon,	// emissivity
                      double Delta,     // distance from the earth
                      double r,         // distance from the sun
                      double alfa,      // phase angle
                      double G,         // G value
                      double *pChisq, 	// Chi squared value of the fit
                      int    N,		// number of iterations
		      int    mode);	// mode e.g Verbose


int   FRMFit(double *w,        		// wavelength. vector in um
                      double *f,        // flux vector
                      double *ef,       // error on flux vector
                      int    nw,        // number of elements in w vector
                      double *R,        // Radius of the asteroid in km (1.fit param)
                      double *eR,   	// Error in Diameter
                      double *Pv,       // Geometric Albedo
                      double *ePv,  	// error on Pv
                      double H,         // H value
                      double *eta,      // eta value
                      double *eeta, 	// error on eta value
                      double epsilon,	// emissivity
                      double Delta,     // distance from the earth
                      double r,         // distance from the sun
                      double alfa,      // phase angle
                      double G,         // G value
                      double *pChisq, 	// Chi squared value of the fit
                      int    N,		// number of iterations
		      int    mode);	// mode e.g Verbose

//calculates the reflected light component and return it in Jy
int ReflectedLight_Jy(double *w,
		      double *rlc, 
		      int Nw, 
		      double v, 
		      double vtowratio);

//add the the reflected light component to an SED in Jy
int  AddReflComp_Jy(double *w, double *fr, int nw, double H, double G,
		    double r, double Delta, double alfa,double vtowratio); // it adds the relfected comp.

//calculates the reflected light component and return it in W/m^2/um
int ReflectedLight_W(double *w,
		     double *rlc, 
		     int Nw, 
		     double v, 
		     double vtowratio);

//add the the reflected light component to an SED in W/m^2/um
int  AddReflComp_W(double *w, double *fr, int nw, double H, double G,
		   double r, double Delta, double alfa,double vtowratio); // it adds the relfected comp.

double h2v(double H, 
	   double G, 
	   double r, 
	   double Delta, 
	   double pha);

