#define TM_H
// this is the source file containing the simple thermal models
// STM, FRM, NEATM
// and the fucntions to fit the STM, FRM, NEATM to fluxes
// fitTM is the driver program
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "macros.h"
#include "constants.h"

#define  BUFLEN 512

#define USAGE "\n\
  This is tss (delbo@oca.eu) [last chage: May 6, 2009]\n\
  enter Bond Albedo, beaming parameter, emissivity, and heliocentric distance in AU\n\
  -h this help\n\
  -s simple output: just output the temperature \n\
  -l <luminosity> Scale the sun luminosity: 1=Sun 10=ten times the sun 0.5=half the sun\n"

main(int argc, char *argv[])
{
	char		buf[BUFLEN];
	double		A, eta, r, epsilon, Tss;
	unsigned int	output=0;
	double		SolarLuminosity=1.0;

	while (argc>1)
	{
		if (argv[1][0]=='-')
		{
    			switch (argv[1][1])
    			{
				case 'l': // change sun Luminosity
                        		argc--; argv++; SolarLuminosity=atof(argv[1]);
//					printf("Warning: Luminosity of the Sun is scaled by %lf: i.e. %lf W m-2\n",
//						SolarLuminosity, SolarLuminosity*SOLARC);
				break;
				case 's': output=1;	//simple output: just output the temperature
				break;
               			case 'h': printf("%s\n",USAGE); exit(0);
                        	break;
				default:
		  			printf("unknown option -%s\n",&argv[1][1]);
                			return 0;
                      		break;
 			}
		} 
		argc--;
		argv++;
	}

        while (NULL!=fgets(buf, BUFLEN, stdin))
        {
            if ((sscanf(buf, "%lf %lf %lf %lf", &A, &eta, &epsilon, &r) < 4))
                break;
	    Tss = TSS(A, eta, r, epsilon)*pow(SolarLuminosity,0.25); // derive subsolar temperature
            
  	    if ((output &1)==0)
		  printf("%lf %lf %lf %lf %lf\n", A, eta, epsilon, r, Tss);
		else
	    	  printf("%lf\n", Tss);
        }



}
