//#include <windows.h>
//#include <process.h>
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include "tm.h"
#include "constants.h"
#include "macros.h"

#define	 NEATM		0
#define	 NEATMFIX	1
#define	 STM		2
#define	 FRM		3
#define	 NITER		500
#define  NMAX           10000


#define USAGE "TMflux D, pV, eta, r, Delta, alpha\n"
#define ADARGS "-l <lambda0> <lambda1> <lambdastep> to change the default wavelenght range\n\
 -m mode 0=NEATM 2=STM 3=FRM\n\
 -e <emissivity value>\n\
 -g <G_value>\n\
 -o <output_filename>\n\
 -r column mode\n\
 -b <beta_e> \n\
 -v verbose mode\n\
 -V <VtoBandsRatio>\n"

#define PROG     "FitTM"
#define AUTHOR   "Marco Delbo"
#define VERSION  "beta 1.0"
#define REL_DATE "January 10, 2008"

main(int argc, char* argv[])
{

	double	w0=4.0, w1=25.0, ws=0.5;
	double	beta=0.01;
	double	D=1, pV=0.2, G=0.15, epsilon=0.9, eta=1.0, 
	  A=Pv2A(pV, G), H0=-1, H=DIAM2H(D, pV);
	double  r=1, Delta=1, alpha=0;
	int		multi=0;
	int		physpar=0;
	int		model=NEATM;
	double	Tss;
	int		Nw;
	int		i;
	int		verbose=0;
	char*	filename=NULL;
	int             colmode=0;
	double  reflVtoBandRatio=-1;

	/*
	if (argc<7)
	{
		printf("%s\n",USAGE);
		return;
	}
	*/
	while (argc>1)
	{
		if (argv[1][0]=='-')
		{
    		switch (argv[1][1])
    		{
				case 'b': 	// force to change the value of betaE
				   argc--; argv++; beta=atof(argv[1]);
				break;
		                case 'e':
				   argc--; argv++; epsilon=atof(argv[1]);
		                break;
		                case 'G':
				   argc--; argv++; G=atof(argv[1]);
		                break;
		                case 'H':
				   argc--; argv++; H0=atof(argv[1]);
		                break;
				case 'l': 	// get the wavelength range
				  argc--; argv++; w0=atof(argv[1]);
				  argc--; argv++; w1=atof(argv[1]);
				  argc--; argv++; ws=atof(argv[1]);
				break;
				case 'm':
				  model=atoi(argv[1]); argc--; argv++;
				break;
				case 'o': 	// get the output filename
				  argc--; argv++; filename=argv[1];
				break;
				case 'v':
				  	verbose=1;
				break;
				case 'r':
				  	colmode=1;
				break;
				case 'V':
				  	argc--; argv++; 
					reflVtoBandRatio=atof(argv[1]);
				break;
				default:
					printf("unknown option -%s\n",argv[1][1]);
					return -2;
				break;
			}
		} 
		/*
		else
		{

			if ((argc > 6) && (physpar==0))
			{
			  if (verbose)
			  printf("importing physical parameters\n");
				model=atoi(argv[1]); argc--; argv++;
				D=atof(argv[1]); argc--; argv++;
				pV=atof(argv[1]); argc--; argv++;
				G=atof(argv[1]); argc--; argv++;
				epsilon=atof(argv[1]); argc--; argv++;
				eta=atof(argv[1]); argc--; argv++;
				A=Pv2A(pV, G);
				physpar+=5;
			}

			if(verbose)	printf("argc=%d\n",argc);

			if ((argc > 3) && (multi==0))
			{
				r=atof(argv[1]); argc--; argv++;
				Delta=atof(argv[1]); argc--; argv++;
				alpha=atof(argv[1]); argc--; argv++;
			}
		}
		*/
		argc--;
		argv++;
	}

	// get Params
	if (scanf("%lf %lf %lf %lf %lf %lf", &D, &pV, &eta, &r, &Delta, &alpha)!=6)
	  exit(0);

// get data
	double pw[NMAX];
	double pf[NMAX];
	double pfm[NMAX];
	double pef[NMAX];
	
		  
	Nw=0;
	while (scanf("%lf %lf %lf", &pw[Nw], &pf[Nw], &pef[Nw])==3)
	{
	    Nw++;
	}	

        A=Pv2A(pV, G);
        if (H0<0) H=DIAM2H(D, pV); else H=H0;
	    Tss=TSS(A,eta,r,epsilon);
	    switch(model)
	      {
	      case STM: 	STMflux_Jy(pw, pfm, Nw, Tss, epsilon, D/2, beta, Delta, alpha, NITER);
		break;
	      case NEATM: NEATMflux_Jy(pw, pfm, Nw, Tss, epsilon, D/2, Delta, alpha, NITER);
		break;
	      case FRM: 	FRMflux_Jy(pw, pfm, Nw, Tss/pow(3.14,0.25), epsilon, D/2, Delta, NITER);
		break;
	      }

	    if (reflVtoBandRatio > 0)
	      {
		AddReflComp_Jy(pw, pfm, Nw, H, G, r, Delta, alpha, reflVtoBandRatio); // it adds the relfected comp.
	      }
	    
	    for (i=0; i<Nw; i++)
	      {
//	      printf("%lf\t%le\t",pw[i], pf[i]);
		printf("%7.3lf\t%le\t%le\t%le\n",pw[i], pf[i], pef[i], pfm[i]); 
	      }
	      
}
