#include"colorcorrection.h"

// function added my MDB on July 4, 2012
int ColorCorrectionFree(ColorCorrection *pCC)
{
  int i_Filt;

  if (!pCC)
    {
      printf("ColorCorrectionFree E1, empty pointer to pCC\n");
      return -1;
    }

  if (!pCC->CCTable)
    {
      printf("ColorCorrectionFree E2, empty color correction table\n");
      return -2;
    }
   
  // free the lines of each temperature
  for (i_Filt=0; i_Filt<pCC->NFilter; i_Filt++)
    if (pCC->CCTable[i_Filt]) free(pCC->CCTable[i_Filt]);

  free(pCC->CCTable);
  // 
}

int ColorCorrectionRead(char *filename, ColorCorrection *pCC)
{
  int iNTemp, iNFilter, i_Temp, i_Filt, dummy=0;
  double **ppCCTable=NULL;
  FILE *fh=NULL;

  //  printf("Trying to open file %s\n",filename);
  fh=fopen(filename,"rt");
  if (!fh)
    {
      printf("ColorCorrectionTableRead FAILED: file not found\n");
      return -1;
    }

  //read the number of temperatures and number of filters to be read
  fscanf(fh, "%d %d", &iNTemp, &iNFilter);
  //  printf("Read iNTemps = %d and iNFilter = %d\n", iNTemps,iNFilter);

  // alloc memory
  // allocate pointers to each filter
  ppCCTable=(double**)malloc(sizeof(double*)*(iNFilter));
  if (!ppCCTable)
    {
      printf("ColorCorrectionTableRead FAILED: Malloc Error\n");
      return -2;
    }

  // allocate the lines of each temperature
  // bug corrected by MDB on July 4, 2012
  for (i_Filt=0; i_Filt<iNFilter; i_Filt++)
    {
      ppCCTable[i_Filt]=(double*)malloc(sizeof(double)*iNTemp);
        if (!ppCCTable[i_Filt])
	  {
	    printf("ColorCorrectionTableRead FAILED: Malloc Error\n");
	    ColorCorrectionFree(pCC);// try to free it// added my MDB
	    return -3;
	  }
    }

  // read the CC values
  for(i_Temp=0; i_Temp<iNTemp; i_Temp++){

    fscanf(fh,"%d",&dummy);

    for(i_Filt=0; i_Filt<iNFilter; i_Filt++){
      fscanf(fh, "%lf", &ppCCTable[i_Filt][i_Temp]);
    }
    //    printf("CCW1 = %lf\t CCW2 = %lf\n",ppCCTable[i][0], ppCCTable[i][1]);
  }

  fclose(fh);
  
  //pass back pointers
  pCC->CCTable=ppCCTable;
  pCC->NFilter=iNFilter;
  pCC->NTemp=iNTemp;
}

/*
int main()
{
  char CCTableFile[30] = "T_color_correction_table.dat";
  int ccexit,i,j;
  ColorCorrection mycc;
  

  //printf("main(): The target file name is %s\n",CCTableFile);
  ccexit = ColorCorrectionRead(CCTableFile, &mycc);
 
  for (i=0; i<mycc.NTemp; i++)
    {
    for(j=0; j<mycc.NFilter; j++)
      {
	printf("CCW%d = %e ", j+1, mycc.CCTable[j][i]);
      }
    printf("\n");
    }

}
*/
