#ifndef EPHEMS_H
  #include "ephems.h"
#endif

#ifndef CONSTANTS_H
  #include "../tms/constants.h"
#endif

#ifndef MACROS_H
  #include "../tms/macros.h"
#endif

#include <float.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int ReadEphemerides(char *fname,  EPH **lpeph, long *pNeph)
{
  FILE *file_in;
  EPH  *eph;
  char linebuf[512];
  long Neph=0, i;

// try to open the file...
  if ((file_in = fopen( fname, "r"))== NULL ) 
    {
      printf("E EPHEMS_C 00 File not found\n");
      return 0; //if does not succed, return 0
    }

  // count number of lines in the file: only ephemerides must be present
  while (1)
    {
      if (NULL==fgets(linebuf,256,file_in)) break;
      if (linebuf[0]=='#') continue;
      Neph++;
    }

  fclose(file_in);//close the file in order to rewind the pointer
	
  // allocate the memory for the Ephemerides vectors
  eph=malloc(Neph*sizeof(EPH));
  if (eph==NULL)
    {
      printf("E EPHEMS_C 01 Memory not allocated\n");
      return -1; //failed
    }

  // pass back the address of the ephemerides and of the number of ephems

  *lpeph=eph;
  *pNeph=Neph;

  // reopen the file
  if ((file_in = fopen( fname, "r"))== NULL ) 
    {
      free(eph);
      return -2;
    }
  
  i=0;
  while (1)
    {
      if (fgets(linebuf,256,file_in)==NULL) break;
      if (linebuf[0]=='#') continue;
		// fill in the vectors...
      eph[i].pobs=NULL;
      eph[i].flags=0; // put the flags to zero then tries to read from the file
      if (sscanf(linebuf, "%lf%lf%lf%lf%d", &eph[i].JD, 
		 &eph[i].vs.x,&eph[i].vs.y,&eph[i].vs.z, &eph[i].flags)<4)
	{
	  free(eph);
	  return -3;
	}
      //      vs[i].x=-vs[i].x; vs[i].y=-vs[i].y; vs[i].z=-vs[i].z; //no need to 
      i++;
    }
  
  fclose(file_in);// close the file and..
  // returns 0 if all went ok
  return 0;
}

// interpolates ephems 
// source ephems must have constant step
int interpolephem(VECTOR *v, double *JD, long N,
		  VECTOR **lvd, double *JDd, long Nd)
{
	VECTOR	*vd;
	double	a;
	long	i,j;
	double	jds=(JD[N-1]-JD[0])/(N-1), dista=-1;
	
	if (JD[0]>JDd[0])
	  {
	    printf("JD[0]>JDd[0]\n !!!!!");
	    exit(-1);
	  }

	if (JD[N-1]<JDd[Nd-1])
	  {
	    printf("JD[N-1]<JDd[Nd-1]\n !!!!!");
	    exit(-2);
	  }

	// dealloc first
	vd=*lvd; if (vd) free(vd);	
	
	// allocate mem
	if ((vd=(VECTOR*)malloc(Nd*sizeof(VECTOR))) == NULL)
	{	
		printf("E interpolephem 01 Memory not allocated\n");	
		return -1;
	}
	// pass back the addresses 
	*lvd=vd;
			
	for (i=0; i<Nd; i++)
	{

	  // find the nearest
	  for (j=0; j<N; j++)
	    if (JD[j]>JDd[i]) break; j--;
	    	  
	  a=(v[j+1].x-v[j].x)/(JD[j+1]-JD[j]);
	  vd[i].x = v[j].x + a*(JDd[i]-JD[j]);

	  a=(v[j+1].y-v[j].y)/(JD[j+1]-JD[j]);
	  vd[i].y = v[j].y + a*(JDd[i]-JD[j]);
	  
	  a=(v[j+1].z-v[j].z)/(JD[j+1]-JD[j]);
	  vd[i].z = v[j].z + a*(JDd[i]-JD[j]);
	  
	  //	  printf("%ld %ld %lf %lf %lf %lf %lf \n", i, j, JDd[i], JD[j], vd[i].x, vd[i].y, vd[i].z);
	}
	return 1;
}

int Eclip2Ast(VECTOR *ve, 
              double lambda, double beta, double P, double phi0, double t0,
	      double JD)
{
	//calc the three rotation matrices 
	// A^t(\lambda)
	double	cl = cos(lambda);
	double  sl = sin(lambda);
//	double	At[3][3] = {{cl,  -sl, 0.0},	// {{cl*cb,  -sl, -sb*cl}
//			    {sl,   cl, 0.0},	//  {sl*cb,   cl, -sb*sl}
//			    {0.0, 0.0, 1.0}};	//  {sb   ,  0.0,     cb}};

	// B^t(\beta)
	double	cb = cos(DPIBY2 - beta);
	double  sb = sin(DPIBY2 - beta);
//	double	Bt[3][3] = {{cb,  0.0, -sb},
//			    {0.0, 1.0, 0.0},
//			    {sb,  0.0, cb}};
	// this is the product of B^t x A^t
	double	BtAt[3][3] = {{cb*cl, cb*sl, -sb},
			      {-sl  ,    cl, 0.0},
			      {sb*cl, sb*sl,  cb}};
	double	xi, cxi, sxi;
	VECTOR v;

	// calculate product of B^t x A^t
//	AxB(Bt,At,BtAt);
	// calculate product of B^t x A^t x v_elc
	v.x=BtAt[0][0]*ve->x + BtAt[0][1]*ve->y + BtAt[0][2]*ve->z;
	v.y=BtAt[1][0]*ve->x + BtAt[1][1]*ve->y + BtAt[1][2]*ve->z;
	v.z=BtAt[2][0]*ve->x + BtAt[2][1]*ve->y + BtAt[2][2]*ve->z;


	xi = phi0 + D2PI/P*(JD-t0);
	cxi=cos(xi);
	sxi=sin(xi);
	ve[0].x =  cxi * v.x + sxi * v.y;
	ve[0].y =  -sxi * v.x + cxi * v.y;
	ve[0].z = v.z;	// it could be removed
	return 1;
}

int Eclip2AstVec(VECTOR *ve, VECTOR **lva, long N, 
              double lambda, double beta, double P, double phi0, double t0,
	      double *JD)
{
	VECTOR	*va=NULL;
	VECTOR	*v=NULL;
	//calc the three rotation matrices 
	// A^t(\lambda)
	double	cl = cos(lambda);
	double  sl = sin(lambda);
//	double	At[3][3] = {{cl,  -sl, 0.0},	// {{cl*cb,  -sl, -sb*cl}
//						{sl,   cl, 0.0},	//	{sl*cb,   cl, -sb*sl}
//						{0.0, 0.0, 1.0}};	//	{sb   ,  0.0,     cb}};

	// B^t(\beta)
	double	cb = cos(DPIBY2 - beta);
	double  sb = sin(DPIBY2 - beta);
//	double	Bt[3][3] = {{cb,  0.0, -sb},
//						{0.0, 1.0, 0.0},
//						{sb,  0.0, cb}};
	// this is the product of B^t x A^t
	double	BtAt[3][3] = {{cb*cl, cb*sl, -sb},
			      {-sl  ,    cl, 0.0},
			      {sb*cl, sb*sl,  cb}};

	//	double	BtAt[3][3] = {{cb*cl,  cb*sl,  sb},
	//			      {-sl   ,    cl, 0.0},
	//			      {-sb*cl,-sb*sl,  cb}};
	long	i,j;
	double	xi, cxi, sxi;

        printf("lambda,beta, P, phi0, t0: %lf %lf %lf %lf %lf\n",lambda,beta, P, phi0, t0);
	printf("matrix elments:\n");
	for (i=0; i<3; i++) 
	  { 
	    for (j=0; j<3; j++) printf("%lf\t",BtAt[i][j]);
	    printf("\n");
	  }
	printf("\n");

	// dealloc first
	va=*lva; if (va) free(va);	
	
	// allocate mem
	if ((va=(VECTOR*)malloc(N*sizeof(VECTOR))) == NULL)
	{	
		printf("E EPHEMS_C_eclip2ast 01 Memory not allocated\n");	
		return -1;
	}
	// pass back the addresses 
	*lva=va;

	if ((v=(VECTOR*)malloc(N*sizeof(VECTOR))) == NULL)
	{	
		printf("E EPHEMS_C_eclip2ast 02 Memory not allocated\n");	
		free(va);
		return -1;
	}

	// calculate product of B^t x A^t
//	AxB(Bt,At,BtAt);
	// calculate product of B^t x A^t x v_elc for each v_elc
	for (i=0; i<N; i++)
	  {
	    v[i].x=BtAt[0][0]*ve[i].x + BtAt[0][1]*ve[i].y + BtAt[0][2]*ve[i].z;
	    v[i].y=BtAt[1][0]*ve[i].x + BtAt[1][1]*ve[i].y + BtAt[1][2]*ve[i].z;
	    v[i].z=BtAt[2][0]*ve[i].x + BtAt[2][1]*ve[i].y + BtAt[2][2]*ve[i].z;
	  }                                                             

//	printf("Nephem=%ld\n",N);
	// C^t(time, \phi0) // fuck! It's fucntion of time. This means that we need to calc a C matrix at each tiem step
	for (i=0; i<N; i++)
	  {
	    xi = phi0 + D2PI/P*(JD[i]-t0);
	    cxi=cos(xi);
	    sxi=sin(xi);
	    va[i].x =  cxi * v[i].x + sxi * v[i].y;
	    va[i].y =  -sxi * v[i].x + cxi * v[i].y;
	    va[i].z = v[i].z;	// it could be removed
	  }
	
	if (v) free(v);
	return 1;
}

/*
int jdlist(double jd0, double jd1,              // start and end
	   long NPTS, double P, 	        // point per rotation, Period in days
	   double **lpjd, long *Njd, double *dt)// output jd: total number of points and dt in sec
{
	double* pjd=*lpjd;
	double  Nrot = (jd1-jd0)/(P);
	long	N = (long)(Nrot*NPTS);
	double	jds=(jd1-jd0)/N;
	long	i;

	printf("%lf %lf\n",jd0,jd1);
	dt[0]=P*3600.*24./NPTS;
	
	if (pjd) free(pjd);
	pjd=(double*)malloc(N*sizeof(double));
	if (!pjd)
	{
		printf("jdlist E01: malloc failed\n");
		return -1;
	}
	// pass back pointer
	*lpjd=pjd;
	
	for (i=0; i<N; i++)
	  pjd[i]=jd0+jds*i;
	
	Njd[0]=N;
	return 1;
}
*/

 /*
int jdlistex(double *pjde,  // pointer to the epoch of ephemerides 			
             VECTOR *pse,  // pointer to the sun position vectors		
	     long   npts,  // number of ephemerides points
             TPM    *ptpm, // pointer to the thermal model: thermal parameters are needed)
	     double **lpjd, long *Njd, double *pdt)// output jd, total number of points and average dt (sec)
{	
	long    NPTS=360;
	double* pjd=*lpjd;
	long	N = 0;
	double	jds=0;
 //	double  expo=-1.5, konst=18.2148, turnpoint=0.1; 
	double  expo=-3.0, konst=0.54, turnpoint=0.1; 
	
	double  T, Theta, Nrot, dt, avedt=0.0; 
	long	*pN, Npt, Ntot=0, i,j,k;

	if (!pjde) return -1;
	if (!pse) return -2;
	if (!ptpm) return -3;

	if ( (pN=(long*)malloc(npts*sizeof(long))) == NULL)
	{
		printf("jdlistex E01: malloc failed\n");
		return -4;
	}

        // calculate the optimal number of points per rotation 
	// from the thermal parameter at each ephemeris point
	for (i=0; i<npts; i++)
	{       // A      eta     r         emissivity
	  T=TSS(ptpm->A, 1.0,NORMA(pse[i]),ptpm->epsilon);
	  Theta=ptpm->Gamma*sqrt(D2PI/ptpm->mesh.P/86400.0)/ptpm->epsilon/SIGMA/T/T/T;
	  if (Theta<turnpoint) pN[i]=(long)(konst*pow(Theta,expo));
          else pN[i]=(long)(konst*pow(turnpoint,expo));
 //	  printf("n>\t%ld\t%lf\t%lf\t%ld\n",i, NORMA(pse[i]),Theta, pN[i]);
	}

	for (i=0; i<(npts-1); i++) // makes sure to use all max points per rotation
	  pN[i]=max(pN[i],pN[i+1]);
	
	// calculates the total number of points
	Njd[0]=0;
	for (i=0; i<(npts-1); i++)
	  {
	    Nrot = (pjde[i+1]-pjde[i])/(ptpm->mesh.P);
	    Njd[0] +=(long)(Nrot*pN[i]);
	  }

	// free the memory if it is allocated
	if (pjd) free(pjd);
	// alloc the memory for the jd vector
        if ( (pjd=(double*)malloc(Njd[0]*sizeof(double)))==NULL)
	  {
	    if (!pN) free(pN);
		printf("jdlistex E02: malloc failed\n");
		return -5;
	  }
	*lpjd=pjd;  // passes back the pointer
        
	// fill in the jd vector
	k=0;
	for (i=0; i<(npts-1); i++)
	  {
	    Nrot = (pjde[i+1]-pjde[i])/(ptpm->mesh.P);
	    Npt  =(long)(Nrot*pN[i]);
	    dt   = (pjde[i+1]-pjde[i])/Npt;
	    avedt+=dt;// add to the average dt
	    for (j=0; j<Npt; j++)
	      {
 		pjd[k]=pjde[i]+dt*j;
//		printf("%ld %lf\n", k, pjd[k]);
		k++;
		if (k > Njd[0]) 
		  {
		    printf("jdlistex E03: buffer overflow @ i=%ld \n",i);
		    exit(0);
		  }
	      }
	  }
	pdt[0]=(double)(avedt/(npts-1)*86400.0);  // return the average value of the dt in seconds
	if (pN) free(pN);

	return 0;
}
 */
