#define EPHEMS_H

#ifndef MESH_H
  #include "mesh.h"
#endif

// needs to have this to go araound with the circular dependence
// EPH.pOBS and OBS.pEPH;
typedef struct OBS OBS; 
typedef struct EPH EPH; // define the type

#define  EPH_FLAGS_SKIPMINISTEP   1 // the code just jumps to the next ephem point and does not do the ministep

// declare the structure
struct EPH
{
  double        JD;     // epoch of ephem
  VECTOR        vs;     // position vector of the sun in the object reference frame
  OBS           *pobs;  // point to the corresponding observation if present
  unsigned int  flags;  // control FLAGS (see above)
};

int ReadEphemerides(char * fname,  EPH **lpeph, long *neph);

// rotate one Vector
int Eclip2Ast(VECTOR *ve, 
              double lambda, double beta, double P, double phi0, double t0,
	      double JD);

// rotate many vectors
int Eclip2AstVec(VECTOR *ve, VECTOR **lva, long N, 
              double lambda, double beta, double P, double phi0, double t0,
	      double *JD);

int interpolephem(VECTOR *v, double *JD, long N,
		  VECTOR **lvd, double *JDdm, long Nd);
/*
int jdlist(double jd0, double jd1, // start and end
	   long NPTS, double P, 	// point per rotation, Period in days
	   double **lpjd, long *Njd, double *dt);// output jd: total number of points and dt in sec

int jdlistex(double *pjde,  // pointer to the epoch of ephemerides 			
           VECTOR *pse,  // pointer to the sun position vectors		
	   long   npts,  // number of ephemerides points
           TPM    *ptpm, // pointer to the thermal model: thermal parameters are needed)
	   double **lpjd, long *Njd, double *pdt);// output jd total number of points and dt in sec
*/
