#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef CONSTANTS_H
  #include "../tms/constants.h"
#endif

#ifndef max
	#define max( a, b ) ( ((a) > (b)) ? (a) : (b) )
#endif

#ifndef min
	#define min( a, b ) ( ((a) < (b)) ? (a) : (b) )
#endif

#define USAGE "\n\
  This is gamma2theta\n\
  Enter Temperature Rot_Period (hrs) Thermal Inertia, emissivity \n"

main(int argc, char *argv[])
{
  double Gamma, P, T, Theta, emissivity;
  int mode=0;

  while (argc>1)
  {
          if (argv[1][0]=='-')
          {
  	  switch (argv[1][1])
  	    {
                case 'v': printf("%s\n",USAGE); exit(0);
                  break;
  	        case 'n': printf("%s\n",USAGE); exit(0);
  		  argc--;
  		  argv++;
  		break;
  	        case 'h': printf("%s\n",USAGE); exit(0);
                  break;
	        case 's': mode+=1;
                  break; 
              }
          } 
          argc--;
          argv++;
  }

  scanf("%lf %lf %lf %lf",&T, &P, &Gamma, &emissivity);
  Theta=Gamma*sqrt(2*DPI/P/3600.0)/emissivity/T/T/T/SIGMA;
  if ((mode && 1)==1)
    printf("%lf\n", Theta);
  else
    printf("%lf %lf %lf %lf %lf\n", T, P, Gamma, emissivity, Theta);
}
