#include <time.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef LC_H
  #include "lc.h"
#endif

#ifndef CONSTANTS_H
  #include "../tms/constants.h"
#endif

#ifndef MACROS_H
  #include "../tms/macros.h"
#endif


int calcLcGeom(TPM* ptpm, VECTOR sun, VECTOR obsv, double* pflux)
{
  int i;
  double ps;
  
  *pflux=0;
  for (i=0; i<ptpm->mesh.fn; i++)
    {
      ps=SCALAR(ptpm->mesh.n[i].vec,sun); 
      if (ps <=0) continue;
      
      ps=SCALAR(ptpm->mesh.n[i].vec,obsv); 
      if (ps <=0) continue;      

      *pflux+=ps*ptpm->mesh.n[i].mod;
    }
  *pflux/=2;
}

int calcLcLommelSeeliger(TPM* ptpm, VECTOR sun, VECTOR obsv, double* pflux)
{
  int i;
  double psSun, psObs;
  
  *pflux=0;
  for (i=0; i<ptpm->mesh.fn; i++)
    {
      psSun=SCALAR(ptpm->mesh.n[i].vec,sun); 
      if (psSun <=0) continue;
      
      psObs=SCALAR(ptpm->mesh.n[i].vec,obsv); 
      if (psObs <=0) continue;      

      *pflux+=(psSun*psObs)/(psSun+psObs)*ptpm->mesh.n[i].mod;
    }
  *pflux/=2;
}

int calcLcLambert(TPM* ptpm, VECTOR sun, VECTOR obsv, double* pflux)
{
	int		i;
	double psSun, psObs;

	*pflux=0.0;
	for(i=0; i<ptpm->mesh.fn; i++)
	  {
	    psSun=SCALAR(ptpm->mesh.n[i].vec,sun); 
	    if (psSun <=0) continue;
	  
	    psObs=SCALAR(ptpm->mesh.n[i].vec,obsv); 
	    if (psObs <=0) continue;      
	  
	    *pflux += (psSun*psObs*ptpm->mesh.n[i].mod);
	  }
	
	return *pflux/2.0;
}

// calculate the chisquared between the model flux and the observed flux
// the observed flux is in the vector flux
// the model flux is in the vector ModelFlux
// the number of points is in Ndata.
// Because these are visible lightcurves the Ndata is usually 1
// it can also be more is lightcurves in different bands have been done.
double lcchisq(OBS* pobs, long Nobs)
{
  double alpha=0, beta=0, gamma=0, delta=0, epsilon=0, zeta=0;
  double a=0, b=0, chisq=0;
  long iobs, idata;
  
  for (iobs=0; iobs<Nobs; iobs++)
    {
      for (idata=0; idata<pobs[iobs].Ndata; idata++)
	{
	  alpha+=(pobs[iobs].ModelFlux[idata]*pobs[iobs].ModelFlux[idata]/
		  pobs[iobs].eflux[idata]/pobs[iobs].eflux[idata]);
	  beta+=(pobs[iobs].flux[idata]*pobs[iobs].flux[idata]/
                 pobs[iobs].eflux[idata]/pobs[iobs].eflux[idata]);
	}
      //      gamma+=(pflux[i]/pobs[i].eflux/pobs[i].eflux);
      //      delta+=(pobs[i].flux/pobs[i].eflux/pobs[i].eflux);
      //      zeta+=(1.0/pobs[i].eflux/pobs[i].eflux);
    }
  //  a=(beta+delta*gamma/zeta)/(alpha+gamma*gamma/zeta);
  //  b=(a*gamma-delta)/zeta;
  a=beta/alpha;
  
  for (iobs=0; iobs<Nobs; iobs++)
      for (idata=0; idata<pobs[iobs].Ndata; idata++)
	chisq+=(pobs[iobs].flux[idata]-pobs[iobs].ModelFlux[idata]*a)*
	       (pobs[iobs].flux[idata]-pobs[iobs].ModelFlux[idata]*a)/
	        pobs[iobs].eflux[idata]/pobs[iobs].eflux[idata];

  printf("o> %lf %lf\n", a, chisq);
  //  printf("o> %lf %lf %lf\n", a, b, chisq);
  return chisq;
}

int runlc(TPM* ptpm, double* pjd, VECTOR* psun, long Npts, 
	  OBS* pobs, long Nobs, double **lpfc, int model)
{
	unsigned char		*pobsindex;
	double			jds=0, jdsold=0;
	unsigned long		i, j, indf;
	double			flux, cflux;
	double			*pfc = *lpfc;
	time_t  		init, etime;
	double			*prat=NULL;
	FILE			*pfhtemp=NULL;
	FILE                    *pfhfflux=NULL;
	VECTOR                  v;
	double lambda, beta, rxy;
	/*
// initalize pointer to the observation index presence	
	if ((pobsindex=(unsigned char*)malloc(sizeof(unsigned char)*Npts))==NULL)
	{
		printf("runtpm E01: malloc failed\n");		
		return -1;
	}
	memset(pobsindex,0,Npts);	//fill the buffer with 0

// set those index to the number of observations occuring at that time.	
	printf("Setting up obs points: jds=%f(min)\n", jds*3600);
	for (i=0; i<Nobs; i++)
	{	//sets those with an observation (with variable time step need to scan)
	  jdsold=jds=10000000.0;//set jds to initial distance
	  for(j=0; j<Npts; j++)
	    {
	      jds=fabs(pobs[i].JD-pjd[j]);
	      if (jds<jdsold) jdsold=jds; else break;
	    }
//	  printf("%ld\t%ld\n",i,j);
	  pobsindex[j]++;
	}

//initalize the pointer to the model flux	
	if (pfc)
	  free(pfc);
	
	if ((pfc=malloc(Nobs*sizeof(double)))==NULL)
	{
		printf("runtpm E02: malloc failed\n");		
		free(pobsindex);
		return -1;
	}
	//pass back pointer
	*lpfc=pfc;
	

	init=time(NULL);
// START THE TPM LC calculation: 
	printf("runTPM started: VISUAL LIGHTCURVE calculation and N=%ld\n", Npts);
	j=0;
	switch (model)
	  {
	  case SCATTERING_GEOMETRIC: // geometric model
	    for (i=0; i<Npts; i++)
	      {
		while (pobsindex[i]>0)
		  {
		    calcLcGeom(ptpm, psun[i], pobs[j].vo, &flux);
		    printf("f> %0.2d %18.10f %6.1f %6.2f %11.6f %10.6f %11.6f %11.4f ", j,
			   pobs[j].JD, (pobs[j].JD-pjd[i])*1440, pobs[j].lambda, pobs[j].flux, 
			   pobs[j].eflux, flux, pobs[j].flux/flux);
		    pfc[j]=flux;
		    
		    normalize(psun[i], &v);
		    rxy=sqrt(v.x*v.x + v.y*v.y); lambda=atan2(v.y, v.x)*RADEG;
		    if (lambda<0) lambda+=360.0;
		    if (rxy!=0)
		      beta=atan(v.z/rxy)*RADEG;
		    else 
		      { 
			if (v.z>0) beta=90.0;
			else beta=-90.0;
		      }
		    printf("%6.1lf %6.1lf", lambda, beta);
		    
		    normalize(pobs[j].vo, &v);
		    rxy=sqrt(v.x*v.x + v.y*v.y); lambda=atan2(v.y, v.x)*RADEG;
		    if (lambda<0) lambda+=360.0;
		    if (rxy!=0)
		      beta=atan(v.z/rxy)*RADEG;
		    else 
		      { 
			if (v.z>0) beta=90.0;
			else beta=-90.0;
		      }
		    printf("%6.1lf %6.1lf\n", lambda, beta);
		    
		    j++; pobsindex[i]--;
		  }
		
	      } // case SCATTERING_GEOMETRIC
	  case SCATTERING_LOMMELSEELIGER: // SCATTERING_LOMMELSEELIGER model
	    for (i=0; i<Npts; i++)
	      {
		while (pobsindex[i]>0)
		  {
		    calcLcLommelSeeliger(ptpm, psun[i], pobs[j].vo, &flux);
		    printf("f> %0.2d %18.10f %6.1f %6.2f %11.6f %10.6f %11.6f %11.4f ", j,
			   pobs[j].JD, (pobs[j].JD-pjd[i])*1440, pobs[j].lambda, pobs[j].flux, 
			   pobs[j].eflux, flux, pobs[j].flux/flux);
		    pfc[j]=flux;
		    
		    normalize(psun[i], &v);
		    rxy=sqrt(v.x*v.x + v.y*v.y); lambda=atan2(v.y, v.x)*RADEG;
		    if (lambda<0) lambda+=360.0;
		    if (rxy!=0)
		      beta=atan(v.z/rxy)*RADEG;
		    else 
		      { 
			if (v.z>0) beta=90.0;
			else beta=-90.0;
		      }
		    printf("%6.1lf %6.1lf", lambda, beta);
		    
		    normalize(pobs[j].vo, &v);
		    rxy=sqrt(v.x*v.x + v.y*v.y); lambda=atan2(v.y, v.x)*RADEG;
		    if (lambda<0) lambda+=360.0;
		    if (rxy!=0)
		      beta=atan(v.z/rxy)*RADEG;
		    else 
		      { 
			if (v.z>0) beta=90.0;
			else beta=-90.0;
		      }
		    printf("%6.1lf %6.1lf\n", lambda, beta);
		    
		    j++; pobsindex[i]--;
		  }
	      } // case SCATTERING_LOMMELSEELIGER
	    break;
	  case SCATTERING_LAMBERT: // scattering model
	    for (i=0; i<Npts; i++)
	      {
		while (pobsindex[i]>0)
		  {
		    calcLcLambert(ptpm, psun[i], pobs[j].vo, &flux);
		    printf("f> %0.2d %18.10f %6.1f %6.2f %11.6f %10.6f %11.6f %11.4f ", j,
			   pobs[j].JD, (pobs[j].JD-pjd[i])*1440, pobs[j].lambda, pobs[j].flux, 
			   pobs[j].eflux, flux, pobs[j].flux/flux);
		    pfc[j]=flux;
		    
		    normalize(psun[i], &v);
		    rxy=sqrt(v.x*v.x + v.y*v.y); lambda=atan2(v.y, v.x)*RADEG;
		    if (lambda<0) lambda+=360.0;
		    if (rxy!=0)
		      beta=atan(v.z/rxy)*RADEG;
		    else 
		      { 
			if (v.z>0) beta=90.0;
			else beta=-90.0;
		      }
		    printf("%6.1lf %6.1lf", lambda, beta);
		    
		    normalize(pobs[j].vo, &v);
		    rxy=sqrt(v.x*v.x + v.y*v.y); lambda=atan2(v.y, v.x)*RADEG;
		    if (lambda<0) lambda+=360.0;
		    if (rxy!=0)
		      beta=atan(v.z/rxy)*RADEG;
		    else 
		      { 
			if (v.z>0) beta=90.0;
			else beta=-90.0;
		      }
		    printf("%6.1lf %6.1lf\n", lambda, beta);
		    
		    j++; pobsindex[i]--;
		  }
	      }
	    break; // end SCATTERING LAMBERT
	  case SCATTERING_KAASALAINEN: // SCATTERING_KAASALAINEN model
	    for (i=0; i<Npts; i++)
	      {
		while (pobsindex[i]>0)
		  {
		    calcLcLommelSeeliger(ptpm, psun[i], pobs[j].vo, &flux);
		    pfc[j]=flux;
		    calcLcLambert(ptpm, psun[i], pobs[j].vo, &flux);
		    pfc[j]=pfc[j]*0.9 + 0.1*flux;
		    printf("f> %0.2d %18.10f %6.1f %6.2f %11.6f %10.6f %11.6f %11.4f ", j,
			   pobs[j].JD, (pobs[j].JD-pjd[i])*1440, pobs[j].lambda, pobs[j].flux, 
			   pobs[j].eflux, pfc[j], pobs[j].flux/pfc[j]);
		    
		    normalize(psun[i], &v);
		    rxy=sqrt(v.x*v.x + v.y*v.y); lambda=atan2(v.y, v.x)*RADEG;
		    if (lambda<0) lambda+=360.0;
		    if (rxy!=0)
		      beta=atan(v.z/rxy)*RADEG;
		    else 
		      { 
			if (v.z>0) beta=90.0;
			else beta=-90.0;
		      }
		    printf("%6.1lf %6.1lf", lambda, beta);
		    
		    normalize(pobs[j].vo, &v);
		    rxy=sqrt(v.x*v.x + v.y*v.y); lambda=atan2(v.y, v.x)*RADEG;
		    if (lambda<0) lambda+=360.0;
		    if (rxy!=0)
		      beta=atan(v.z/rxy)*RADEG;
		    else 
		      { 
			if (v.z>0) beta=90.0;
			else beta=-90.0;
		      }
		    printf("%6.1lf %6.1lf\n", lambda, beta);
		    
		    j++; pobsindex[i]--;
		  }
	      } // case SCATTERING_KAASALAINEN
	    break;
	  default:
	    printf("wrong value of lcmodel\n");
	    break;
	  }
	
	if (pfhtemp) fclose(pfhtemp);
	free(pobsindex);
	printf("\nrunTPM completed\n");
	return 1;
	*/
}
