#define LC_H

#ifndef TPM_H
  #include "tpm.h"
#endif

#define SCATTERING_GEOMETRIC      1
#define SCATTERING_LAMBERT        2
#define SCATTERING_LOMMELSEELIGER 3
#define SCATTERING_KAASALAINEN    4

// Functions to return the normalized brightness of a polyhedron are
// described by Muinonen 98 A&A vol.332 p1087
// according to Labert LAW (SL)
// and
// Lommel Seeliger LAW (SLS)

// function prototypes
int calcLcGeom(TPM* ptpm, VECTOR sun, VECTOR obsv, double* pflux);
int calcLcLambert(TPM* ptpm, VECTOR sun, VECTOR obsv, double* pflux);
int calcLcLommelSeeliger(TPM* ptpm, VECTOR sun, VECTOR obsv, double* pflux);
double lcchisq(OBS* pobs, long Nobs);

int runlc(TPM *tpm,    // pointer to TPM
      double *pjd, // pointer 
      VECTOR *psa, // pointer to the sun vector in the asteroid reference (ephemerides) 
      long N, // number of ephemerides points 
      OBS *pobs, // pointer to the observations
      long Nobs, // number of observations
      double **lpfc, // pointer to the calculated flux OUTPUT
      int model);

