//#include <sys\stat.h>       /* S_ constant definitions */
//#include <fcntl.h>          /* O_ constant definitions */
//#include <io.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef MACROS_H
  #include "../tms/macros.h"
#endif

#ifndef MESH_H
  #include "mesh.h"
#endif

#ifndef CONSTANTS_H
  #include "../tms/constants.h"
#endif


int calc_barycenter(VECTOR * pv, int  vn, VECTOR *pbary)
{
    int i;
    
    memset(pbary,0,sizeof(*pbary));

    printf("#TEST_calcbary : nombre total de sommets : %d\n", vn);
    for(i=0;i<vn;i++)
    {
        pbary[0].x += pv[i].x;
        pbary[0].y += pv[i].y;
        pbary[0].z += pv[i].z;
    }
       pbary[0].x /= vn;
       pbary[0].y /= vn;
       pbary[0].z /= vn;
       printf("#TEST_calcbary : coordonnees barycentre : %lf %lf %lf\n\n",
	      pbary[0].x, pbary[0].y, pbary[0].z);
    return 1;
}

double normalize(VECTOR inp_vector,VECTOR * out_vector )
{
	double mod;

	
	mod=	sqrt(
				inp_vector.x*inp_vector.x +
				inp_vector.y*inp_vector.y +
				inp_vector.z*inp_vector.z 
			);

	if (mod==0.) return mod;
		// you can call the funtion without a out vec
	if (out_vector)		// this modific is proposed by Marco
	{
		out_vector->x=inp_vector.x/mod;
	    out_vector->y=inp_vector.y/mod;
	    out_vector->z=inp_vector.z/mod;
	}
	
	return mod;
}


	
int ReadWavefront(char * fname,  VECTOR ** lpp, FACET ** lpf, int * pointn, int * facetn, double * maxrange)
	{
	FILE * file_in;
	VECTOR * p;
	FACET * f;
	
	char linebuf[256];
	char a;
	int fcnt=0,vcnt=0;
	double maxsiz=-1e20;
//	char  s1[20], s2[20], s3[20];

	if ((file_in = fopen( fname, "r"))== NULL ) 
		return 0;

	// count vectors and facets
	while (1)
		{
		if (NULL==fgets(linebuf,256,file_in)) break;
		if ((linebuf[0]=='v') && (linebuf[1]!='n')) vcnt++;
		if (linebuf[0]=='f') fcnt++;
		}

	fclose(file_in);
	
	p=malloc(vcnt*sizeof(VECTOR));
	if (p==NULL)
		{
		printf("E MESH_C 01 Memory not allocated\n");
		return 0; //failed
		}
	f=malloc(fcnt*sizeof(FACET));
	if (f==NULL) 
		{
		printf("E MESH_C 01 Memory not allocated\n");
		return 0; //failed
		}

	// pass back the addresses 

	*lpp=p;
	*lpf=f;

	*pointn=vcnt;
	*facetn=fcnt;

	vcnt=fcnt=0;

	if ((file_in = fopen( fname, "r"))== NULL ) 
		return 0;

	while (1)
		{
		if (fgets(linebuf,256,file_in)==NULL) break;
		if ((linebuf[0]=='v') && (linebuf[1]!='n')) 
			{
			sscanf(linebuf,"%c%lf%lf%lf",&a,&p[vcnt].x,&p[vcnt].y,&p[vcnt].z);
			maxsiz=max(maxsiz,p[vcnt].x);
			maxsiz=max(maxsiz,p[vcnt].y);
			maxsiz=max(maxsiz,p[vcnt].z);
			maxsiz=max(maxsiz,-p[vcnt].x);
			maxsiz=max(maxsiz,-p[vcnt].y);
			maxsiz=max(maxsiz,-p[vcnt].z);
			vcnt++;
			}

		if (linebuf[0]=='f') 
			{
			sscanf(linebuf,"%c%i%i%i",&a, &f[fcnt].v1, &f[fcnt].v2, &f[fcnt].v3); 
/*			sscanf(linebuf,"%s %s %s %s",&a, &s1, &s2, &s3);
			sscanf(s1,"%i", &f[fcnt].v1);
			sscanf(s2,"%i", &f[fcnt].v2);
			sscanf(s3,"%i", &f[fcnt].v3);
*/			fcnt++;
			}
		}

	fclose(file_in);
	*maxrange=maxsiz;//*1.05;

	return 1;
	}

/* ------------------------------------------------------------
   This function writes a Wavefront file
-------------------------------------------------------------*/
int WriteWavefront(char*   	fname, 
		   VECTOR* 	v, 
		   FACET*	f, 
		   int     	vn,
		   int		fn)
{
	FILE*	fh;
	int		i;

        if (v==NULL)
	  return 0;
        if (f==NULL)
	  return 0;

	if (fname==NULL) 
		fh=stdout;
	else 
		fh = fopen(fname, "wt");
	if (!fh) return 0;

	fprintf(fh,"#created by lib3\n");
	fprintf(fh,"#number of vertex %d\n", vn);
	fprintf(fh,"#number of factes %d\n\n", fn);

	for(i=0; i<vn; i++)
		fprintf(fh,"v %lf %lf %lf\n", 
		  v[i].x, v[i].y, v[i].z);

	for(i=0; i<fn; i++)
		fprintf(fh,"f %d %d %d\n", 
		  f[i].v1, f[i].v2, f[i].v3);

	if (fname!=NULL) 
		fclose(fh);

	return 1;
}


int compact_shape_ex (VECTOR ** lpp, FACET ** lpf, int * pointn, int * facetn, double epsilon )
        {
// this routine changes the vertex vector 
// it also changes the content of the facets vector, but leaves the order of the facets unchanged 
// epsilon is the tolerance

        int i,j, k, ppointer=0;
        VECTOR * p;
        VECTOR * pp;
        FACET * pf;

        if (lpp==NULL)                return 0; // an invalid pointer has been passed
        if (lpf==NULL)                return 0; // an invalid pointer has been passed
        if (*lpp==NULL)                return 0; // an invalid pointer has been passed
        if (*lpf==NULL)                return 0; // an invalid pointer has been passed

        pp=*lpp;
        pf=*lpf;
       
        p=malloc(*pointn*sizeof(VECTOR));
        if (p==NULL)                return 0; //failed

        for (i=0; i< *pointn; i++)
                {
                for (k=0; k < ppointer; k++)
                        {
                        if ((fabs(p[k].x-pp[i].x)< epsilon) &&
                                (fabs(p[k].y-pp[i].y)< epsilon) &&
                                (fabs(p[k].z-pp[i].z)< epsilon))
                                {
                                for (j=0;j<*facetn ; j++)
                                        {
                                        if (pf[j].v1==(unsigned int)(i+1)) pf[j].v1=k+1;
                                        if (pf[j].v2==(unsigned int)(i+1)) pf[j].v2=k+1;
                                        if (pf[j].v3==(unsigned int)(i+1)) pf[j].v3=k+1;
                                        }
                                break;
                                }
                        }

                if (k==ppointer)
                        {
                        p[ppointer].x=pp[i].x;
                        p[ppointer].y=pp[i].y;
                        p[ppointer].z=pp[i].z;
                        for (j=0;j<*facetn ; j++)
                                {
                                if (pf[j].v1==(unsigned int)(i+1)) pf[j].v1=ppointer+1;
                                if (pf[j].v2==(unsigned int)(i+1)) pf[j].v2=ppointer+1;
                                if (pf[j].v3==(unsigned int)(i+1)) pf[j].v3=ppointer+1;
                                }
                        ppointer++;
                        }
                }
        
// free the old array of vectors
        free(*lpp);

// pass back the vectors to the calling routine
        *lpp=p;
	*pointn=ppointer;

        return 1;
        }

//**********************************************
// This routine computes the centers of facets
// This routine allocates 1 vector that needs to be freed by the calling program
int comp_facet_center( int facetn, VECTOR * p, FACET * f, VECTOR ** lpcenters)
	{
	VECTOR * centers;
	int indxf;
	VECTOR * p1;

	if (*lpcenters != NULL)	free(*lpcenters);

	centers=malloc(facetn*sizeof(VECTOR));
	if (centers==NULL) 
		{
//		MessageBox(NULL,"Virtual memory not allocated","Sdisp",MB_OK);
		return 0; //failed
		}

	*lpcenters=centers;

	p1=p-1;   // make base-1 vector arithmetic

	for(indxf=0;indxf<facetn;indxf++)
		{
		centers[indxf].x = (p1[f[indxf].v1].x+p1[f[indxf].v2].x+p1[f[indxf].v3].x)/3;
		centers[indxf].y = (p1[f[indxf].v1].y+p1[f[indxf].v2].y+p1[f[indxf].v3].y)/3;
		centers[indxf].z = (p1[f[indxf].v1].z+p1[f[indxf].v2].z+p1[f[indxf].v3].z)/3;
		}

	return 1;	}

// This routine allocates 1 vector that needs to be freed by the calling program

int comp_normal(int facetn, VECTOR * p, FACET * f, VECTORM ** lpnormal)
	{
	VECTORM *normal;
	int indxf;
	VECTOR *p1;
	VECTOR v1,v2;

	if (*lpnormal != NULL)	free(*lpnormal); 

	normal=malloc(facetn*sizeof(VECTORM));
	if (normal==NULL) 
		{
		printf("comp_normal Virtual memory not allocated\n");
		return 0; //failed
		}

	*lpnormal=normal;

	p1=p-1;   // make base-1 vector arithmetic

	for(indxf=0;indxf<facetn;indxf++)
		{
		v2.x=p1[f[indxf].v3].x-p1[f[indxf].v1].x;
		v1.x=p1[f[indxf].v2].x-p1[f[indxf].v1].x;

		v2.y=p1[f[indxf].v3].y-p1[f[indxf].v1].y;
		v1.y=p1[f[indxf].v2].y-p1[f[indxf].v1].y;

		v2.z=p1[f[indxf].v3].z-p1[f[indxf].v1].z;
		v1.z=p1[f[indxf].v2].z-p1[f[indxf].v1].z;

// !!!! wrong normal direction!!!		
//v1.x=p1[f[indxf].v3].x-p1[f[indxf].v1].x;
//v2.x=p1[f[indxf].v2].x-p1[f[indxf].v1].x;

//v1.y=p1[f[indxf].v3].y-p1[f[indxf].v1].y;
//v2.y=p1[f[indxf].v2].y-p1[f[indxf].v1].y;

//v1.z=p1[f[indxf].v3].z-p1[f[indxf].v1].z;
//v2.z=p1[f[indxf].v2].z-p1[f[indxf].v1].z;

		normal[indxf].vec.x = v1.y * v2.z  -  v1.z * v2.y ;
		normal[indxf].vec.y = v1.z * v2.x  -  v1.x * v2.z ;
		normal[indxf].vec.z = v1.x * v2.y  -  v1.y * v2.x ;

	// normal[].mod is the modulus of the normal vector to the facet 
	// and twice the area of the facet

		normal[indxf].mod= sqrt(normal[indxf].vec.x*normal[indxf].vec.x+normal[indxf].vec.y*normal[indxf].vec.y+
							normal[indxf].vec.z*normal[indxf].vec.z);
			
	// normalize individual components
		normal[indxf].vec.x = normal[indxf].vec.x/normal[indxf].mod;
		normal[indxf].vec.y = normal[indxf].vec.y/normal[indxf].mod;
		normal[indxf].vec.z = normal[indxf].vec.z/normal[indxf].mod;
		}

	return 1;
	}

double meshvolume(MESH* pmesh)
{
	double	vol=0.0;
	int	i;
	VECTOR*	pv;
	
	pv=pmesh->v-1;   // make base-1 vector arithmetic

// calc the scalar triple: i.e. the determinant of the matrix {{v1},{v2},{v3}} // lines vectors
	
	for(i=0;i<pmesh->fn;i++)
		{
		vol +=  pv[pmesh->f[i].v1].x*pv[pmesh->f[i].v2].y*pv[pmesh->f[i].v3].z 
		       -pv[pmesh->f[i].v1].x*pv[pmesh->f[i].v2].z*pv[pmesh->f[i].v3].y
			   +pv[pmesh->f[i].v1].y*pv[pmesh->f[i].v2].z*pv[pmesh->f[i].v3].x
			   -pv[pmesh->f[i].v1].y*pv[pmesh->f[i].v2].x*pv[pmesh->f[i].v3].z
			   +pv[pmesh->f[i].v1].z*pv[pmesh->f[i].v2].x*pv[pmesh->f[i].v3].y
			   -pv[pmesh->f[i].v1].z*pv[pmesh->f[i].v2].y*pv[pmesh->f[i].v3].x;
		}

	return vol/6;
}

double meshsurface(MESH* pmesh)
{
	double	surface=0.0;
	int	i;
// calc the scalar triple: i.e. the determinant of the matrix {{v1},{v2},{v3}} // lines vectors
	
	for(i=0;i<pmesh->fn;i++)
	  surface+=pmesh->n[i].mod;

	return surface/2;
}

double meshvolume2(VECTOR *pv, FACET *pf, int fn)
{
	double	vol=0.0;
	int	i;
	VECTOR*	ppv;
	
	ppv=pv-1;   // make base-1 vector arithmetic

// calc the scalar triple: i.e. the determinant of the matrix {{v1},{v2},{v3}} // lines vectors
	
	for(i=0;i<fn;i++)
		{
		vol +=  ppv[pf[i].v1].x*ppv[pf[i].v2].y*ppv[pf[i].v3].z 
		       -ppv[pf[i].v1].x*ppv[pf[i].v2].z*ppv[pf[i].v3].y
			   +ppv[pf[i].v1].y*ppv[pf[i].v2].z*ppv[pf[i].v3].x
			   -ppv[pf[i].v1].y*ppv[pf[i].v2].x*ppv[pf[i].v3].z
			   +ppv[pf[i].v1].z*ppv[pf[i].v2].x*ppv[pf[i].v3].y
			   -ppv[pf[i].v1].z*ppv[pf[i].v2].y*ppv[pf[i].v3].x;
		}

	return vol/6;
}

int scalemesh(MESH* pmesh, double lscale)
{
	int	i;
	VECTOR		*c=NULL;
	VECTORM		*n=NULL;
	
	for(i=0; i<pmesh->vn; i++)
	{
		pmesh->v[i].x*=lscale;
		pmesh->v[i].y*=lscale;
		pmesh->v[i].z*=lscale;
	}
	
	if (!comp_normal(pmesh->fn, pmesh->v, pmesh->f, &n))
		{
		return -1;
		}
//	printf("comp_normal ok\n");

	if (!comp_facet_center(pmesh->fn, pmesh->v, pmesh->f, &c))
		{
		return -1;
		}
	if (pmesh->c) free(pmesh->c);
	if (pmesh->n) free(pmesh->n);
	pmesh->c=c;
	pmesh->n=n;
	pmesh->maxsize*=lscale;

	return 1;
}

int GenFacetsNormals(char *fname, MESH* pm)
{
  int		i;
  double	ps=0.0;
  double	maxsiz=0.0;
  VECTOR	*v=NULL;
  VECTOR	*c=NULL;
  VECTORM	*n=NULL;
  FACET		*f=NULL;
  double	*ill=NULL, *vis=NULL;
  int		fn=0;
  int		vn=0;
  FILE          *input_fh;

   if (pm->v) free(pm->v);
   if (pm->f) free(pm->f);
   if (pm->n) free(pm->n);
   if (pm->c) free(pm->c);
   if (pm->ill) free(pm->ill);
   if (pm->vis) free(pm->vis);
	  
   if ((input_fh=fopen(fname, "rt"))==NULL)
     {
       printf("GenFacetsNormals E 01005 Normals file open failed!\n");
       return -1;
     }
   fscanf(input_fh,"%d",&fn);
   // MDB Praha 31 Oct 2011 USE ALL facets no matter WHAT!
   //fn--; // remove the latest facet which is NOT used by Joseph to calculate the flux
   // the last facet in the file is used to close the shape

   n=(VECTORM*)malloc(fn*sizeof(VECTORM));
   if (n==NULL)
     {
       printf("GenFacetsNormals E 01006 alloc of normals failed !\n");
       return -1;
     }

   for (i=0; i<fn; i++)
     {
       if (feof(input_fh)) 
	 {
	   printf("GenFacetsNormals E 01006 end of file encountered before end of normals!\n");
	   return -1;
	 }
       fscanf(input_fh, "%lf", &n[i].mod);
       n[i].mod*=2;
       fscanf(input_fh, "%lf %lf %lf", &n[i].vec.x, &n[i].vec.y, &n[i].vec.z);
       
     }
   
	
   if ((ill=malloc(fn*sizeof(double)))==NULL)
     {
       printf("GenFacetsNormals E10 malloc error illumination \n");
       return -1;
     }

   if ((vis=malloc(fn*sizeof(double)))==NULL)
     {
       printf("GenFacetsNormals E11 malloc error visibility \n");
       return -1;
     }

   // zero to illumination and visibility
   memset(vis,0,sizeof(double)*fn);
   memset(ill,0,sizeof(double)*fn);
	
   // store maxsize information
   pm->maxsize=maxsiz;
   // pass back pointers
   pm->v=v; pm->c=c; pm->n=n; pm->f=f; pm->vn=vn; pm->fn=fn;
   pm->ill=ill; pm->vis=vis; 
   
   return 1;
}

int GenMeshWF(char *fname, MESH* pm)
{
	int			i;
	double		ps=0.0;
	double		maxsiz=0.0;
	VECTOR		*v=NULL;
	VECTOR		*c=NULL;
	VECTORM		*n=NULL;
	FACET		*f=NULL;
	double		*ill=NULL, *vis=NULL;
	int			fn=0;
	int			vn=0;


   if (pm->v) free(pm->v); 
   if (pm->f) free(pm->f);
   if (pm->n) free(pm->n);
   if (pm->c) free(pm->c);
   if (pm->ill) free(pm->ill);
   if (pm->vis) free(pm->vis);
   if (pm->Longitude) {free(pm->Longitude); pm->Longitude=NULL;}
   if (pm->Latitude) {free(pm->Latitude); pm->Latitude=NULL;}
	  
   if (!ReadWavefront(fname, &v, &f, &vn, &fn, &maxsiz))
		{
		printf("E 01 ReadMesh failed!\n");
		return -1;
		}
//	printf("readwf ok\n");
/*
    if (!compact_shape(&v, &f, &vn, &fn))
		{
		printf("Compact shape failed\n");
		return -1;
		}
//	printf("compact_shape ok\n");
*/
	if (!comp_normal(fn, v, f, &n))
		{
		return -1;
		}
//	printf("comp_normal ok\n");

	if (!comp_facet_center(fn, v, f, &c))
		{
		return -1;
		}
//	printf("comp_facet_center ok\n");

	// check if normals are pointing out of the body reference frame center
	for (i=0; i<pm->fn; i++)
	{
		if ( (ps = SCALAR(c[i], n[i].vec)) < 0)
		  printf("Warining! normal %d is toward the center!\n", i);
	}
	
	if ((ill=malloc(fn*sizeof(double)))==NULL)
	{
	  printf("GenMeshWF E10 malloc error illumination \n");
	  return -1;
	}

	if ((vis=malloc(fn*sizeof(double)))==NULL)
	{
	  printf("GenMeshWF E11 malloc error visibility \n");
	  return -1;
	}
	
	// zero to illumination and visibility
	memset(vis,0,sizeof(double)*fn);
	memset(ill,0,sizeof(double)*fn);
	
	// store maxsize information
	pm->maxsize=maxsiz;
	// pass back pointers
	pm->v=v; pm->c=c; pm->n=n; pm->f=f; pm->vn=vn; pm->fn=fn;
	pm->ill=ill; pm->vis=vis; 

	// MDB 22/01/2012
	// determine Longitude and Latitude of the facets
	Mesh2LongLat(pm, &pm->Longitude, &pm->Latitude);

	return 1;
}


int meshillumination(MESH *pm, VECTOR sun)
{
	int		i, j;
	double	norma=NORMA(sun);
	VECTOR	sunN={sun.x/norma, sun.y/norma, sun.z/norma};
	
/*
	if (!pm->ill) // the illumination buffer does not exists
	  {
		  printf("meshillumination E01: illumination does not exists\n");
			  return -1;
	  }
	  //reset the buffer
*/
    memset(pm->ill, 0, sizeof(double)*pm->fn);	// clear the illumination vector
	  
	  /*
	  if (m.isconcave) 
	  for(i=0; i<m.fn; i++)
	  {
		  pillum[i]=SCALAR(SunVglo, m.n[i].vec);	// SunVglo is already normalized

		  if (pillum[i] <=0) { pillum[i]=0; continue; }

		  // for those elements having a positve Scalar products
		  // check for shadows...
		  if (plochlen[i] <=0) continue;	// skip this facet. it doesn't see any other

//		  if (pillum[i] > pmaxlhheigh[i]) continue; // the zenith angle of the Sun direction is 
													// greater than the maximun zenith angle of the Lhor		  
		  for(j=0; j<plochlen[i]; j++)
		  {

			  // calculate the solid angle formed by the Sun with the facet direction
			  sp = SCALAR(SunVglo, ploch[i][j].vec);
  			  sp = DPI*(1.-sp);
			  if (sp > ploch[i][j].SolidAngle) continue;

			  pillum[i] = 0;
			  j=plochlen[i];
		  }
	  }	// index i of the facet 
	  else */
	  for(i=0; i<pm->fn; i++)
	  {
		  pm->ill[i]=SCALAR(sunN, pm->n[i].vec);
		  if (pm->ill[i] <=0) 
		  { pm->ill[i]=0; continue; }
	  }	// index i of the facet

	  return 1;
}

int meshvisibility(MESH *pm, VECTOR obs)
{
	int		i, j;
	double	norma=NORMA(obs);
	VECTOR	obsN={obs.x/norma, obs.y/norma, obs.z/norma};
	

	if (!pm->vis) // the illumination buffer does not exists
	  {
		  printf("meshvisibility E01: meshvisibility does not exists\n");
			  return -1;
	  }
	  //reset the buffer
	  memset(pm->vis, 0, sizeof(double)*pm->fn);	// clear the illumination array
	  
	  /*
	  if (m.isconcave) 
	  for(i=0; i<m.fn; i++)
	  {
		  pillum[i]=SCALAR(SunVglo, m.n[i].vec);	// SunVglo is already normalized

		  if (pillum[i] <=0) { pillum[i]=0; continue; }

		  // for those elements having a positve Scalar products
		  // check for shadows...
		  if (plochlen[i] <=0) continue;	// skip this facet. it doesn't see any other

//		  if (pillum[i] > pmaxlhheigh[i]) continue; // the zenith angle of the Sun direction is 
													// greater than the maximun zenith angle of the Lhor		  
		  for(j=0; j<plochlen[i]; j++)
		  {

			  // calculate the solid angle formed by the Sun with the facet direction
			  sp = SCALAR(SunVglo, ploch[i][j].vec);
  			  sp = DPI*(1.-sp);
			  if (sp > ploch[i][j].SolidAngle) continue;

			  pillum[i] = 0;
			  j=plochlen[i];
		  }
	  }	// index i of the facet 
	  else */
	  for(i=0; i<pm->fn; i++)
	  {
		  pm->vis[i]=SCALAR(obsN, pm->n[i].vec);
		  if (pm->vis[i] <=0) 
		  { pm->vis[i]=0; continue; }
	  }	// index i of the facet

	  return 1;
}

	
double ScatteringLambert(MESH *pm, VECTOR sun, VECTOR obs)
{
	int		i;
	double	flux=0.0;
	
	if ((!pm->ill) || (!pm->vis))
	{
		printf("ScatteringLambert E01: Visibility of illumination vector are not defined!!");
		return -1;
	}
	
	meshillumination(pm, sun);
	meshvisibility(pm, obs);
	
	for(i=0; i<pm->fn; i++)
	{
		flux += (pm->ill[i]*pm->vis[i]*pm->n[i].mod);
	}

	return flux/2.0;
}

double ScatteringLommelSeeliger(MESH *pm, VECTOR sun, VECTOR obs)	
{
	int		i;
	double	flux=0.0, fluxf=0.0;

	if ((!pm->ill) || (!pm->vis))
	{
		printf("ScatteringLommelSeeliger E01: Visibility of illumination vector are not defined!!");
		return -1;
	}

	meshillumination(pm, sun);
	meshvisibility(pm, obs);

	for(i=0; i<pm->fn; i++)
	{
		if ((pm->ill[i] + pm->vis[i]) > 0.0 )
		  fluxf = (pm->ill[i]*pm->vis[i] / (pm->ill[i] + pm->vis[i]));
		else
		  fluxf =0.0;

		flux += fluxf*pm->n[i].mod;
	}

	return flux/2.0;
}

/*
double WINAPI IDLgetSG(int argc, void* argv[])	
{
	int		i;
	double	flux=0.0;

#ifdef UPDATEGLVIEW  
	memset(pcolor, 0, sizeof(double)*fn);
#endif

	if ((!pillum) || (!pvis))
	{
		fprintf(logfh, "\nVisibility of illumination vector are not defined!!");
		return -1;
	}

	for(i=0; i<fn; i++)
	{
		if ((pillum[i] <= 0.) || (pvis[i] <=0.)) continue;

#ifdef UPDATEGLVIEW 
		pcolor[i] = (pvis[i]*normal[i].mod);
#endif
	    flux += (pvis[i]*normal[i].mod);
	}

	return flux/2.0;
}
*/

// MDB 21/10/2011 Praha
int FreeMesh(MESH *pMesh)
{
  if (pMesh->v) free(pMesh->v);
  if (pMesh->c) free(pMesh->c);
  if (pMesh->f) free(pMesh->f);
  if (pMesh->ill) free(pMesh->ill);
  if (pMesh->vis) free(pMesh->vis);
}

// MBD 22/01/2012 Nice
int Mesh2LongLat(MESH* pMesh, double **lpLong, double **lpLat)
{
  int     i, ix;
  double  lambda, beta, rxy;  
  double  *pLong, *pLat;

  if (pMesh->c == NULL)
    return -1; // no centers

  // tries to deallocate the buffers if they are not NULL
  //  printf("Done to here \n"); exit(-1);
  //  if (pLong) free(pLong);
  //  if (pLat) free(pLat);

  if ( (pLong=(double*)malloc(sizeof(double)*pMesh->fn))==NULL)
    {
      printf("Mesh2Longlat: alloc error 1\n");
      if (pLong) free(pLong);
      if (pLat) free(pLat);
      return -2;
    }

  if ( (pLat=(double*)malloc(sizeof(double)*pMesh->fn))==NULL)
    {
      printf("Mesh2Longlat: alloc error 1\n");
      if (pLong) free(pLong);
      if (pLat) free(pLat);
      return -2;
    }

  // pass pointers back
  *lpLong = pLong;
  *lpLat  = pLat;

  for (i=0; i<pMesh->fn; i++)	// for each facet
    {
      rxy=sqrt(pMesh->c[i].x*pMesh->c[i].x + pMesh->c[i].y*pMesh->c[i].y);
      lambda=atan2(pMesh->c[i].y, pMesh->c[i].x)*RADEG;
      if (lambda<0) lambda+=360.0;
      if (rxy!=0)
	beta=atan(pMesh->c[i].z/rxy)*RADEG;
      else
	{
	  if (pMesh->c[i].z>0) beta=90.0;
	      else beta=-90.0;
	}
      pLong[i]=lambda;
      pLat[i]=beta;
    }
  
  return 0;
}
