#define MESH_H

#include <math.h>

typedef struct tagVECTOR
    {
	double x;
	double y;
	double z;
    }VECTOR  ;

typedef struct tagVECTORM
    {
	VECTOR vec;
	double mod;
    }VECTORM  ;

typedef struct tagFACET
    {
	unsigned int v1;
	unsigned int v2;
	unsigned int v3;
    }FACET  ;
	
typedef struct tagMESH
{
  VECTOR        *v;
  VECTOR	*c;
  VECTORM	*n;
  FACET		*f;
  int		fn;
  int		vn;
  int		isconcave;
  double	*ill;
  double	*vis;
  double	lambda, 
    beta,
    P,
    phi0,
    t0;
  double          maxsize;
  double          *Longitude;
  double          *Latitude;
}MESH;

double normalize(VECTOR inp_vector, VECTOR *out_vector);


int GenMeshWF(char *fname, MESH* pm);
int GenFacetsNormals(char *fname, MESH* pm);
int compact_shape_ex (VECTOR ** lpp, FACET ** lpf, int * pointn, int * facetn, double epsilon);
int comp_normal( int facetn, VECTOR * p, FACET * f, VECTORM ** lpnormal);
int ReadWavefront(char * fname,  VECTOR ** lpp, FACET ** lpf, int * pointn, int * facetn, double * maxsiz);
int WriteWavefront(char*   fname, VECTOR* v, FACET*	f, int vn, int fn);
int comp_facet_center( int facetn, VECTOR * p, FACET * f, VECTOR ** lpcenters);
int scalemesh(MESH* pmesh, double lscale);
double meshvolume(MESH* pmesh);
double meshvolume2(VECTOR *pv, FACET *pf, int fn); // emilie 2010 aug 2
double meshsurface(MESH* pmesh); // added on sept 26, 2013

int meshvisibility(MESH *pm, VECTOR obs);
int meshillumination(MESH *pm, VECTOR sun);
double ScatteringLommelSeeliger(MESH *pm, VECTOR sun, VECTOR obs);
double ScatteringLambert(MESH *pm, VECTOR sun, VECTOR obs);

// emilie's code 28/Jul/2010
int calc_barycenter(VECTOR * pv, int  vn, VECTOR *pbary);

// MDB 21/10/2011 Praha
int FreeMesh(MESH *pMesh);

// MBD 22/01/2012 Nice
int Mesh2LongLat(MESH* pMesh, double **lpLong, double **lpLat);
