#include <math.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "mesh.h"
#include "../tms/constants.h"

#define USAGE "\n\
  This is the mesh2normals  (delbo@oca.eu) [last chage: Apr 29, 2013]\n\
USAGE:\n\
  INPUT\n\
  echo meshfilename | mesh2normals [-s scale] \n\
  OUTPUT\n\
  o> volume sphere_equivalent_diameter\n\
  -h this help\n\
  -s <scale>: scaling factor of the mesh\n"


main()
{
  /* VARIABLES */
  char fname[1024];
  MESH mesh;
  int res;
  int usenormalfile=0;
  long i;

  /* ARGUMENTS SWITCHES */

  // READ SHAPE -----------------------------------------------------------------------
  scanf("%s", fname);
  //	printf("%s\n",fname);
  if (usenormalfile)
    {
      if ( (res=GenFacetsNormals(fname, &mesh)) <=0)
	{
	  printf("inputdata: GenFacetsNormals FAILED\n");
	  return -1;
	}
      //      printf("Normals %s loaded OK fn=%d; vn=%d\n",fname,mesh.fn,mesh.vn);
    }else
    {
      if ( (res=GenMeshWF(fname, &mesh)) <=0)
	{
	  printf("inputdata: GenMeshWF FAILED\n");
	  return -1;
	}
      //      printf("mesh %s loaded OK fn=%d; vn=%d\n",fname,mesh.fn,mesh.vn);
    }

  
  // MDB and Victor on Fucking April 6th in nice. 
  // Marco took a nap snoring like a devil. 
  // print facets normals to test if we get the same answer using the 
  // bunch of normal file of the obj triangles i.e. the mesh  

  for(i=0; i<mesh.fn; i++)
    {
    printf("%lf %lf %lf %lf\n",
	   mesh.n[i].vec.x,  mesh.n[i].vec.y,  mesh.n[i].vec.z,
	   mesh.n[i].mod/2);
    }  



}
