#include <math.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "mesh.h"
#include "../tms/constants.h"

#define USAGE "\n\
  This is the meshvolume  (delbo@oca.eu) [last chage: Nov 21, 2009]\n\
USAGE:\n\
  INPUT\n\
  echo meshfilename | meshvolume [-s scale] \n\
  OUTPUT\n\
  o> volume sphere_equivalent_diameter\n\
  -h this help\n\
  -s <scale>: scaling factor of the mesh\n"

int main(int argc, char* argv[])
{
  char fname[512];
  MESH mymesh;
  int res=0;
  double volume=0;
  double scale=1.0;

  memset(&mymesh, 0, sizeof(MESH));
//      SCANS the arguments
  while (argc>1)
    {
      if (argv[1][0]=='-')
	{
	  switch (argv[1][1])
	    {
	    case 'h': printf("%s\n",USAGE); exit(0);
	      break;
	    case 's': // scale the mesh
	      argc--; argv++; scale=atof(argv[1]);
	      printf("Warning: mesh scale factor changed to %lf\n", scale);
	      break;
	    default:
	      printf("unknown option -%s\n",&argv[1][1]);
	      return 0;
	      break;
	    } //switch
	}
      argc--; argv++;
    }

  // READ MESH ---------------------------------
  scanf("%s", fname);
  printf("v> mesh %s \n",fname);
  //      printf("%s\n",fname);
  if ( (res=GenMeshWF(fname, &mymesh)) <=0)
    {
      printf("inputdata: GenMeshWF FAILED\n");
      return -1;
    }
  printf("v> mesh %s loaded OK fn=%d; vn=%d\n",fname,mymesh.fn,mymesh.vn);
  volume=meshvolume(&mymesh);
  printf("o>\t%lf\t%lf\t%lf\n",volume*scale*scale*scale, 
	 2.0*pow(volume*3.0/4.0/DPI, 1.0/3.0)*scale,
	 meshsurface(&mymesh)*scale*scale);

  return 0;
}
