
#define DUMPTEMP	    2
#define PRINTTEMP	    4
#define PRINTFACETFLUX	    8 
#define DUMPFACETFLUX      16
#define PRINTDISPLACEMENT  32 
#define DUMPDISPLACEMENT   64
#define PRINTCRATTEMPSTAT 128


#define NPARAMS            5 // D^2, absorption=(1-A), eta, Gamma, Rp

#ifndef MESH_H
  #include "mesh.h"
#endif

#ifndef EPHEMS_H
  #include "ephems.h"
#endif

/* MDB: 20 oct 2011 Charles University, Praha
the observation structure can now take multiple wavelenght
This is to be consistent with J Durech's convex inversion 
  and B. Carry's Koala...

  MDB and Victor at the TNG with clouds, dust, but cute assistant astronomer 10 March 2012
  we have added the derivative of the flux with respect the parameters to be fitted.
  double dyda[Ndata][Nparams] N params is 5
  D^2, absorption=(1-A), eta, Gamma, Rp
*/
struct OBS
{
  double	JD;     // epoch of observation
  double	*lambda; // wavelength of observation: there can be many wavelenght per observation
  double	*flux;   // measured flux (color corrected if the case) multiple obs
  double	*eflux;  // error on the measured flux (multiple)
  double        *ModelFlux; // Flux Calculated by the TPM
  double        *ReflectedFlux; // Flux Reflected by the asteroid (from the Hv, V)
  double        *CraterFlux; // Crater Flux Calculated by the TPM
  int           *FilterIndex; // To be used for the color correction if any
  double        **dyda; //  dyda[Ndata][Nparams] derivative of the flux wrt the parameters
  int           Ndata;  // Number of datapoints in the observation structure
  VECTOR        vo;     // position vector of the observer in the object reference frame 
  VECTOR        vs;     // position vector of the sun in the object reference frame
  unsigned int	flags;  // =1 dumps the temperatures
  EPH           *peph;  // pointer to the linked ephemeris if any
};


// function prototypes
int ReadObs(char * fname, OBS **lpobs, long *pnobs);
int FreeObs(OBS *pobs, long nobs);
int Obs2JD(OBS *obs, long nobs, double **lpjd);
