#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <string.h>
#include "../tms/macros.h"
#include "../tms/constants.h"

//$ gcc -O3 simpsextract.c gasdev.c ran1.c -o simpsextract


#define RAD		0.017453292519943295769236907684886 	// PI/180
#define OBL		0.4090928042223289096135375d0		// J2000 obliquity in radians, IAU
#define COBL		0.91748206206918183682560225347235	// cosine of the J2000 obliquity in radians, IAU
#define SOBL		0.39777715593191367603721308989317	// sine of the J2000 obliquity in radians, IAU

extern int LIBEarthxyz(int argc, void* argv[]);
extern double gasdev(long *idum);
extern double ran1(long *idum);

int colorcorrection(double *cc)
{
  int    i,j;
  double a;
// color correction matrix 
// http://irsa.ipac.caltech.edu/IRASdocs/exp.sup/ch6/tabsupC6.html
// actual flux = flux(reported) / K
 double ccdata[43][5]=
  {
// BB temp      K@12um  K@25    K@60    K@100
    {40,        13.79,	1.08,	0.93,	0.98},
    {45,	8.09,	0.97,	0.92,	0.98},
    {50,	5.35,	0.90,	0.91,	0.99},
    {55,	3.86,	0.86,	0.92,	1.00},
    {60,	2.97,	0.83,	0.93,	1.00},
    {65,	2.40,	0.82,	0.94,	1.01},
    {70,	2.01,	0.81,	0.95,	1.01},
    {75,	1.74,	0.81,	0.96,	1.02},
    {80,	1.54,	0.81,	0.97,	1.02},
    {85,	1.39,	0.82,	0.99,	1.03},
    {90,	1.28,	0.83,	1.00,	1.03},
    {95,	1.19,	0.83,	1.01,	1.03},
    {100,	1.12,	0.84,	1.02,	1.04},
    {110,	1.01,	0.86,	1.04,	1.04},
    {120,	0.94,	0.89,	1.06,	1.04},
    {130,	0.90,	0.91,	1.08,	1.05},
    {140,	0.87,	0.93,	1.09,	1.05},
    {150,	0.85,	0.95,	1.11,	1.05},
    {160,	0.84,	0.97,	1.12,	1.06},
    {170,	0.83,	0.99,	1.13,	1.06},
    {180,	0.83,	1.01,	1.14,	1.06},
    {190,	0.83,	1.02,	1.15,	1.06},
    {200,	0.83,	1.04,	1.16,	1.06},
    {210,	0.84,	1.06,	1.16,	1.06},
    {220,	0.85,	1.07,	1.17,	1.07},
    {230,	0.85,	1.08,	1.18,	1.07},
    {240,	0.86,	1.09,	1.18,	1.07},
    {250,	0.87,	1.11,	1.19,	1.07},
    {260,	0.88,	1.12,	1.19,	1.07},
    {270,	0.89,	1.13,	1.20,	1.07},
    {280,	0.90,	1.14,	1.20,	1.07},
    {290,	0.91,	1.15,	1.21,	1.07},
    {300,	0.92,	1.15,	1.21,	1.07},
    {400,	1.01,	1.22,	1.24,	1.08},
    {500,	1.09,	1.26,	1.26,	1.08},
    {600,	1.15,	1.29,	1.27,	1.08},
    {800,	1.22,	1.32,	1.28,	1.08},
    {1000,	1.27,	1.34,	1.29,	1.08},
    {2000,	1.38,	1.38,	1.31,	1.09},
    {3000,	1.41,	1.39,	1.31,	1.09},
    {4000,	1.42,	1.40,	1.31,	1.09},
    {5000,	1.43,	1.40,	1.32,	1.09},
    {10000,	1.45,	1.41,	1.32,	1.09}, 
 };

 if (cc[0]>10000.) return -1;
 if (cc[0]<40.) return -2;
 if (cc[0]==40.0) 
   {
     printf("pippo\n");
     cc[1]=ccdata[0][1];
     cc[2]=ccdata[0][2];
     cc[3]=ccdata[0][3];
     cc[4]=ccdata[0][4];
     return 0;
   }
 
	  // find the nearest tempearture
   for (i=0; i<42; i++)
     if ((cc[0]>ccdata[i][0]) && (cc[0]<=ccdata[i+1][0])) break;
 // i has the value we want here
 
   for (j=1; j<=4; j++)
     {
     a=(ccdata[i+1][j]-ccdata[i][j])/(ccdata[i+1][0]-ccdata[i][0]);
     cc[j]=ccdata[i][j]+ a*(cc[0]-ccdata[i][0]);
     }

   return 0;
}

double cldj (int _y, int _m, int d, double ut)
{
	double	djm;
	int		m=_m, y=_y;

 	if (m<=2)
        {  y-=1;   m+=12;  }

	djm=(int)(365.25*y) + (int)(30.6001*(m+1)) + d + ut/24 + 1720981.5;

	return djm;
}

double ut2jd(char* uttime)
{
	int	year,month,day, hour, min, sec;
	double	h;

	sscanf(uttime, "%4d%*c%2d%*c%2d%*c%2d%*c%2d%*c%2d", &year,&month,&day, &hour, &min, &sec);
	h=(double)hour+(double)min/60.0+(double)sec/3600.;
	return cldj(year, month, day, h);
}

int main(int argc, char* argv[])
{
	FILE	*fh;
	char	filen[512]="sightings.tab";
	long	astid;
	long	id;
	char	buf[1000];
	long	bytered;
	char	uttime[20];
	float	corr[4];	// Flux overestimation correction factors at 12,25,60,100 um
	float	flux[4];	// Observed flux density at 12,25,60,100um / Corrections
	float	eflux[4];	// Observed flux density UNCERTAINTY at 12,25,60,100um
	float	snr[4];		// SNR at 12,25,60,100um
	float	band[4]={12.0,25.0,60.0,100.0};
	int		i;
	double	jd; // temperature used for the color correction
        double  cc[5]={250,1,1,1,1};        // color correction terms
	unsigned int	mode=0;
	long idum=(-13);
	time_t  seconds;
	void*	parg[10];
	double	x[3], x1tmp;
	double  A=0, eta=1.0, epsilon=0.9, r=1.0;


    	seconds = time (NULL);
	srand((unsigned)seconds);
	idum=(long)(-seconds);
	
	if (argc<2)
	{
		printf("Usage: simpsextract <ASTnumber>\n");
		return -1;
	}

	while (argc>2)
	  {
	    if (argv[1][0]=='-')
	      {
    		switch (argv[1][1])
		  {
		  case 'b': mode+=1;	// divide by the correction
		    break;
		  case 'r': mode+=2;	// add random 
		    break;
		  case 'v': mode+=4;
		    break;
		  case 'e': mode+=16;
		    if ((mode & 4)==4) //verbose
		      {
			printf("Output IRAS satellite position (the center of the Earth;-)\n");
		      }		    
		    break;
		  case 'c': mode+=8;
		    argc--; argv++;
		    cc[0]=atof(argv[1]);
		    colorcorrection(cc);	
		    if ((mode & 4)==4) //verbose
		      {
			printf("Color correction for %5.1lfK black body will be performed\n",cc[0]);
			printf("K@12\t\t25\t\t60\t\t100 um\n");
			printf("%lf\t%lf\t%lf\t%lf\n",cc[1],cc[2],cc[3],cc[4]);
		      }
		    break;
		  case 'a': mode+=32;// uses albedo and eta to calculate the color correction 
		    mode+=8; // force color correction bit FLAG
		    argc--; argv++; A=atof(argv[1]);
		    argc--; argv++; eta=atof(argv[1]);
		    if ((mode & 4)==4) //verbose
		      {
			printf("Color correction using the bolometric Bond albedo %lf and eta of %lf will be performed\n",A,eta);
		      }
		    break;
		  case 'f': 
		    argc--; argv++;
		    strcpy(filen, argv[1]);	
		    if ((mode & 4)==4) //verbose
		      printf("sightings file %s will is used\n",filen);						 
		    break;
		  default:
		    printf("unknown option -%c\n",argv[1][1]);
		    return 0;
		    break;
		  }
	      }
	    argc--;
	    argv++;
	  }
       

	argc--;
	argv++;
	astid=atol(argv[0]);

/*
	fh=fopen("simpsextract.ini", "rt");
	if (fh==NULL)
	{
		printf("cannot find ini file\n");
		return;
	}

	if (NULL==fgets(str,256,fh))
	{
		printf("write the sightings.tbl filename with full path in the .ini file\n");
		return;
	}

	fclose(fh);
*/

	fh=fopen(filen, "rt");
	if (fh==NULL)
	{
		printf("cannot find the sightings.tbl file\n");
		return -2;
	}

//	printf("%d %d %d\n\n", mode, (mode & 2), (mode && 2));

	while (!feof(fh))
	{
		bytered=fgets(buf,1000,fh);
		id=atol(buf);
		if (id==astid)
		{
			strncpy(uttime, &buf[7], 19);
//			printf("%20s\n",uttime);
			corr[0]=atof(&buf[310]);
			corr[1]=atof(&buf[316]);
			corr[2]=atof(&buf[322]);
			corr[3]=atof(&buf[328]);

			flux[0]=atof(&buf[366]);
			flux[1]=atof(&buf[376]);
			flux[2]=atof(&buf[384]);
			flux[3]=atof(&buf[393]);

			eflux[0]=atof(&buf[403]);
			eflux[1]=atof(&buf[412]);
			eflux[2]=atof(&buf[421]);
			eflux[3]=atof(&buf[431]);

			snr[0]=atof(&buf[438]);
			snr[1]=atof(&buf[446]);
			snr[2]=atof(&buf[454]);
			snr[3]=atof(&buf[462]);
			
			if ((mode & 32)==32)
		        {
			  r=atof(&buf[107]);// get r
			  cc[0]=TSS(A,eta,r,epsilon);
			    colorcorrection(cc);
			  if ((mode & 4)==4) //verbose
			    {
			      printf("Color correction for %5.1lfK black body will be performed: r=%lf AU\n",cc[0],r);
			      printf("K@12\t\t25\t\t60\t\t100 um\n");
			      printf("%lf\t%lf\t%lf\t%lf\n",cc[1],cc[2],cc[3],cc[4]);
			    }
			}

			for (i=0; i<4; i++)
			  if ((eflux[i] <=0) && (snr[i]>0)) eflux[i]=flux[i]/snr[i];

			if ((mode & 2)==2)	// add random 
			{
				for (i=0; i<4; i++)
				  flux[i]+=(gasdev(&idum)*eflux[i]);
			}

			jd=ut2jd(uttime);
		    for (i=0; i<4; i++)
		      {
		      if ((mode & 8)==8)  //apply the color correction to the flux values
			flux[i]/=cc[i+1];

		      if (eflux[i]>0)
			{
		        if ((mode & 1)==1)
			      printf("%20s %20.10lf %5.1f %7.3f %7.3f %9.3f %6.3f",uttime,jd,band[i], flux[i]/corr[i], eflux[i], snr[i], corr[i]);
			    else
			      printf("%20s %20.10lf %5.1f %7.3f %7.3f %9.3f %6.3f",uttime,jd,band[i], flux[i], eflux[i], snr[i], corr[i]);
			if ((mode & 16)==16) // output the position of the Earth
			  {
			    parg[0]=x; parg[1]=&jd;
			    LIBEarthxyz(2, parg);
			    x1tmp =  x[1]*COBL + x[2]*SOBL;
			    x[2]  = -x[1]*SOBL + x[2]*COBL;
			    x[1]  = x1tmp;
			    printf("\t%lf %lf %lf\n", x[0], x[1], x[2]);
			  } else
			  {
			    printf("\n");
			  }
			}
                      }
		}
	}

	fclose(fh);

}











































