
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#define	 BUFLEN	256


main(int argc, char *argv[])
{
	double	kappa, rho, c, period;
	char	buf[BUFLEN] ; 	//buffer used read data
	int		verbose=0, N=0;
	double	Gamma, sd;

    while (argc>1)
    {
    	if (argv[1][0]=='-')
        {
           switch (argv[1][1])
           {
             case 'v':
                     verbose=1;
             break;
             case 'h':
                     printf("INPUT : k (W m-1 K-1) rho (kg m-3) c (J kg-1 K-1) period (h)\n");
                     printf("OUTPUT: INPUT Gamma (J m-2 s-0.5 K-1) skindepth (m) \n");
                     return -1;
             break;
             default:
                     printf("unknown option -%s\n",argv[1][1]);
                     return 0;
             break;
           } //switch
		}
		argc--; argv++;
    }


	while (NULL!=fgets(buf, BUFLEN, stdin))
	{
	    if ((sscanf(buf, "%lf %lf %lf %lf", &kappa,  &rho, &c, &period) < 4))
	    	break;
	
	    sd=sqrt(kappa/rho/c/2/3.1415*period*3600.0);
            Gamma=sqrt(kappa*rho*c);
	    printf("%lf %lf %lf %lf %lf %lf \n", kappa, rho, c, period, Gamma, sd);
	}

}

