#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <float.h>
#include "mesh.h"
#include "tpm.h"


int main(int argc, char *argv[])
{
  TPM* ptpm=NULL;
  FILE* pfh=NULL;
  int fn=0, NTslabs=0, i, j, ix;
  float *fdum=NULL;
  float dt;
  float dx;
  double JD;

  if ((ptpm=(TPM*)malloc(sizeof(TPM)))==NULL)
    {
      printf("Can't allocate the TPM object\n");
      printf("This is a severe error and the program will terminate\n");
      return -1;
    }

  // copy arg1 in the ptpm buffer
  strcpy(ptpm->initialtempsfilename,argv[1]);

  if ( (fdum=malloc(sizeof(float)*5000))==NULL)
    {
      fprintf(stderr, "LoadTemp: cannot allocate FDUMMY buffer\n");	  
      return -2;
    }

  if ( (pfh=fopen(ptpm->initialtempsfilename, "rb"))==NULL) //open for reading in binary mode
    {
      fprintf(stderr, "LoadTemp: cannot open tmap_temps.bin file\n");	  
      if (fdum) free(fdum);
      if (ptpm) free(ptpm);
      return -2;
    }

  while (!feof(pfh))
    {
      if (fread(&ptpm->mesh.fn, sizeof(ptpm->mesh.fn),1,pfh)!=1) return -4;//read the number of facets
      if (fread(&ptpm->NTslabs, sizeof(ptpm->NTslabs),1,pfh)!=1) return -5;//read the number of slabs
      if (fread(&JD, sizeof(JD),1,pfh)!=1) return -3;//read JD (double)
      //       printf("oooo%p\n", pfh);      

      //      printf(">>> %d %d\n",ptpm->mesh.fn,ptpm->NTslabs);
      
      if (fread(&dt, sizeof(float), 1, pfh)!=1) return -6;//read dt and dx
      if (fread(&dx, sizeof(float), 1, pfh)!=1) return -7;//read dx
      
      for (i=0; i<ptpm->mesh.fn; i++)	// for each facet
	{
	  if (fread(&j, sizeof(j),1,pfh)!=1) return -8;//read facet index
	  if (fread(fdum, sizeof(float), 3, pfh)!=3) return -9;//load lambda beta and the facet area
	  
      	  printf("%lf\t%8.4f%8.4f", JD, dt, dx);
	  printf("%5d %6.1lf %6.1lf\t%d\t", j, fdum[0], fdum[1], ptpm->NTslabs);

	  // load the whole temperatures depth buffer	  
	  if (fread(fdum,sizeof(float),ptpm->NTslabs,pfh)!=ptpm->NTslabs) return -10;
	  for (ix=0; ix<ptpm->NTslabs; ix++)  printf(" %5.1f", fdum[ix]);
	  
	  //	  printf("<%f %d><%d><%d>\n",fdum[0],i,ptpm->mesh.fn,ptpm->NTslabs);
	  printf("\n");
	}	
    }

  if (pfh) fclose(pfh); // attempts to close the file.
  if (fdum) free(fdum);
  if (ptpm) free(ptpm);
}
