#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct Tfacet
{
  int      index;
  float    lambda;
  float    beta;
  float    area;
  float    *pT;
} TFACET;

typedef struct Tmesh
{
  int     fn;//number of facets
  int     NTslabs;// number of slabs
  double  JD;//julian date 
  float   dx; 
  float   dt;
  TFACET  *pTf;
}TMESH;

#ifndef max
	#define max( a, b ) ( ((a) > (b)) ? (a) : (b) )
#endif

#ifndef min
	#define min( a, b ) ( ((a) < (b)) ? (a) : (b) )
#endif

#define  RECLEN 512

#define USAGE "\n \
 enter <temp.file name> <number of observations> <multiplication factor> <outputfilename>\n \
 optional paramaters \n \ 
  -h this help \n \
  -n <ntslabs> number of depth slabs e.g. 32, 64 [default=32] \n \
  -v Set to VERBOSE output mode \n"

main(int argc, char *argv[])
{
  FILE *fn=NULL, *fno=NULL;
  char filename[256];
  char outfilename[256];
  char command[256];
  int verbose=0;
  float  ls;
  TMESH tmesh;
  int i, index, j, io, dummyi;
  float *pT;
  int Nobs;
  float ttr;
  float area=0, totarea=0;
  float volume=0;
  float tmax=0, tmin=1.e6;
  float tmul=1.0; 

  while (argc>1)
  {
          if (argv[1][0]=='-')
          {
  	  switch (argv[1][1])
  	    {
                case 'v': verbose=1;
                  break;
  	        case 'n': printf("%s\n",USAGE); exit(0);
  		  argc--;
  		  argv++;
  		break;
  	        case 'h': printf("%s\n",USAGE); exit(0);
                  break;
  	        case 'f': printf("%s\n",USAGE); exit(0);
                  break; 
              }
          } 
          argc--;
          argv++;
  }

    scanf("%s",filename);//read the filename
    scanf("%d",&Nobs);//read the number of observation per file
    scanf("%f",&tmul);//read the command
    scanf("%s",outfilename);//read the filename
    
    if (verbose)
      {
	printf("input file: %s\n",filename);
	printf("Number of obs: %d\n",Nobs);
	printf("Multiplic factor: %f\n",tmul);
	printf("output file: %s\n",outfilename);
      }

    if ( (fn=(FILE*)fopen(filename,"rb"))==NULL)
      {
	printf("tmul: cannot open inputfile!!!\n");
	exit(0);
      }

    if ( (fno=(FILE*)fopen(outfilename,"wb"))==NULL)
      {
	printf("tmul: cannot open output file for writing!!!\n");
	exit(0);
      }

    fread(&tmesh.fn,sizeof(tmesh.fn),1,fn);
    fread(&tmesh.NTslabs,sizeof(tmesh.NTslabs),1,fn);

    if (verbose) printf("mesh has %d facets and %d slabs\n", tmesh.fn, tmesh.NTslabs);

    fwrite(&tmesh.fn,sizeof(tmesh.fn),1,fno);
    fwrite(&tmesh.NTslabs,sizeof(tmesh.NTslabs),1,fno);

    if ((tmesh.pTf=(TFACET*)malloc(sizeof(TFACET)*tmesh.fn))==NULL)
      {
	printf("tmul: Alloc error\n");
	exit(0);
      }
	
    if ((pT=(float*)malloc(sizeof(float)*tmesh.NTslabs))==NULL)
      {
	printf("tmul: Alloc error N1\n");
	exit(0);
      }

    for(i=0; i<tmesh.fn; i++)
      {
	if ((tmesh.pTf[i].pT=(float*)malloc(sizeof(float)*tmesh.NTslabs))==NULL)
          {
	    printf("tmul: Alloc error N2\n");
	    exit(0);
	  }
	tmesh.pTf[i].index=i;
	tmesh.pTf[i].beta=0;
	tmesh.pTf[i].lambda=0;		
	tmesh.pTf[i].area=0;
	memset(tmesh.pTf[i].pT,0,sizeof(float)*tmesh.fn);
      }

    for (io=0; io<Nobs; io++)
      {
	if (io>0)
	  {
	    fread(&dummyi,sizeof(tmesh.fn),1,fn);
	    fwrite(&dummyi,sizeof(tmesh.fn),1,fno);
	    fread(&dummyi,sizeof(tmesh.NTslabs),1,fn);
	    fwrite(&dummyi,sizeof(tmesh.NTslabs),1,fno);
	  }
	//read JD
	fread(&tmesh.JD,sizeof(tmesh.JD),1,fn);
	fwrite(&tmesh.JD,sizeof(tmesh.JD),1,fno);

	//	printf("%lf\t",tmesh.JD);
	// read dt dx
	fread(&tmesh.dt,sizeof(tmesh.dt),1,fn);
	fread(&tmesh.dx,sizeof(tmesh.dx),1,fn);
	// write them to the output file
	fwrite(&tmesh.dt,sizeof(tmesh.dt),1,fno);
	fwrite(&tmesh.dx,sizeof(tmesh.dx),1,fno);

	// for each facet reads for each facet reads facet_index lambda, beta, area;
	for(i=0; i<tmesh.fn; i++)
	  {
	    fread(&index,sizeof(index),1,fn);
	    //	    printf("%d %d>>", i, index);
	    fread(&tmesh.pTf[index].lambda,sizeof(tmesh.pTf[index].lambda),1,fn);
	    fread(&tmesh.pTf[index].beta,sizeof(tmesh.pTf[index].beta),1,fn);
	    fread(&tmesh.pTf[index].area,sizeof(tmesh.pTf[index].area),1,fn);
	    // read temps
	    //	    printf("%f %f %f>>", tmesh.pTf[index].lambda, tmesh.pTf[index].beta, tmesh.pTf[index].area);
	    fread(pT,sizeof(pT[0]),tmesh.NTslabs,fn);
	    if (verbose)
	      {
		for (j=0; j<tmesh.NTslabs; j++)
		  printf("%5.0f ",pT[j]);
		printf("\n");
	      }

	    // and write them to the output file
	    fwrite(&index,sizeof(index),1,fno);
	    fwrite(&tmesh.pTf[index].lambda,sizeof(tmesh.pTf[index].lambda),1,fno);
	    fwrite(&tmesh.pTf[index].beta,sizeof(tmesh.pTf[index].beta),1,fno);
	    fwrite(&tmesh.pTf[index].area,sizeof(tmesh.pTf[index].area),1,fno);
	    // multiply temps
	    for (j=0; j<tmesh.NTslabs; j++)
	      pT[j]*=tmul;
	    // write temps to the outputfile
	    fwrite(pT,sizeof(pT[0]),tmesh.NTslabs,fno);
	  } // for tmesh.fn
      }// for obs

    // deallocate all
   for(i=0; i<tmesh.fn; i++) 
      free(tmesh.pTf[i].pT);
   free(tmesh.pTf);
   free(pT);
   fclose(fn);  
   fclose(fno);
}
