#define TPM_H

#define HEATDIFFUSIONCRATER  512
#define LAGERROSCRATER      1024

#ifndef CONSTANTS_H
  #include "../tms/constants.h"
#endif

#ifndef MACROS_H
  #include "../tms/macros.h"
#endif

#ifndef CRATERS_H
  #include "craters.h"
#endif

#ifndef OBS_H
  #include "obs.h"
#endif

// needs to have this to go araound with the circular dependence
// EPH.pOBS and OBS.pEPH;

#define	MODE_CRAT_HEATDIFF_LAGERROS		1
#define	MODE_CRAT_HEATDIFF_FULL			0

//Victor, 2012-02-14
#ifndef COLORCORRECTION_H
  #include "colorcorrection.h"
#endif



typedef struct tagTPM
{
  MESH	       mesh;            // the mesh of the body
  double       A;	        // bolometric Bond's Albedo
  double       pV;		// geometric visibile albedo
  double       H, G;		// H, G system
  double       epsilon;		// infrared emissivity
  double       BeamingParameter;// beaming parameter
  double       Gamma;		// Thermal Inertia [J m^-2 s^-0.5 K^-1]
  double       Tsid;		// Rotational Sidereal Period	[s]
  double       gamma;		// small gamma: crater opening angle (0-90deg)
  double       density;		// crater density (0.0-1.0)
  unsigned int mode;		// model mode flag 
  double       MeshScaleFactor; // this scales linearly the Mesh 
  double       D2;              // this is the scale parameter (prop to D^2) that is used to scale the flux in the LM fit

// Temperature Buffer		
  double       *pTemp;		// Facets temperature vector

// Thermal Inertia Stuff
  double	**pTB;		// temperature buffer
  double	*pTB_dt;	// temperature buffer at new time
  double	dx;             // depth of each slab (in heatlen units)
  double	dtMAX;          // time step P/NpointsPerRotation
  double	dt;             // actual dt (see tpm.c)
  int		NTslabs;	// Number of slabs in the temperature buffer

  // facet temperatures at previous stage for convergence test 
  double        *pTold;

// Surface Roughness model
// MDB April 10, 2004
// Spherical section craters model as of 
// Emery et al. (1998) ICARUS v.136, p104-123 
  CRATER	*crat;		// there is one crater of each mesh tile 
  double	***LUT;		// three-dimensional Look Up Table used to speed up shadow calculation
  int		Ncrat;		// number of craters (=fn. However, required for alloc and free process)

// to scale the luminosity of the Sun for early solar system/exoasteroids applications
  double	SunLuminosity;	// To scale the SolarLuminosity: default must be 1

  long          Niter;
// March 15, 2009
  double        tr;             // temperature treshold required for variable time step
// May 29, 2009, Turin, cannot sleep and dead
  double        ti;             // initial value of the temperature for all facets and depth buffers
// April 22, 2010, Nice
  char          initialtempsfilename[512];
  double        JD0, JD1;       // used to calculate the avarage insolation
//January 25, Novi Ligure // Parameters needed for the calculation of the thermal
// deformation (displacement u) via the Duhamel-Neumann equation
// see Capek and Vokrouhlicky. Thermal stresses in small meteoroids. A&A (2010) vol. 519 pp. 75
  double        rho;            // material density  [kg m-3]
  double        c;              // heat capacity [J kg-1 K-1]
  double        lambda, mu;     // lame's Parameters [GPa]
  double        alpha;          // thermal expansion coefficient [m-1]
  double        kappa;          // thermal conductivity [J m-1 K-1] (DERIVED)
  double        heatlen;        // heat penetration depth [m] (DERIVED) 
  double        **pudtm;        // displacement buffer at t-1 // need to store one for each facet!
  double	**pu;		// displacement buffer
  double	*pu_dt;	        // displacement buffer at new time
  double        dz;             // depth of each slab (in meters) = dx*heatlen

  ColorCorrection *pCCorr;      //Pointer to a color correction structure Victor, 2012-02-14
  double        Rp;             // Ratio of the pIR/pV 

  unsigned long NiterDiffHeat;  // updated by Diffuse heat with the number of iterations performed
  int           iNRingsInCraters; // this is the number of Rings by which craters are discretized

} TPM;

int putCraters(TPM* ptpm, double gamma, double density);
int runtpm(TPM* ptpm, 
	   EPH* peph, long Neph, 
           OBS* pobs, long Nobs);

