#include <time.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef CONSTANTS_H
  #include "../tms/constants.h"
#endif

#ifndef MACROS_H
  #include "../tms/macros.h"
#endif

#ifndef TPM_H
  #include "tpm.h"
#endif

#ifndef TSTRESS_H
  #include "tstress.h"
#endif

int AllocDisplacementB(TPM* ptpm) 
{
  int	i, j;
  
  if ((ptpm->pu = (double**)malloc(sizeof(double*)*ptpm->mesh.fn))==NULL)
    {
      printf("AllocDisplacementB E01 Cannot allocate Displacement Buffer\n");
      return -1;
    }
  
  for (i=0; i<ptpm->mesh.fn; i++) 
    {
      if (!(ptpm->pu[i]=(double*)malloc(sizeof(double)*ptpm->NTslabs)))
	{
	  printf("AllocDisplacementB E1021 Cannot allocate Displacement Buffer\n");
	  return -1021;
	}
      for (j=0; j<ptpm->NTslabs; j++)	// initialize Displacement buffer to zero
	ptpm->pu[i][j]=0.0;
    }
  
  if ((ptpm->pu_dt=(double*)malloc(sizeof(double)*ptpm->NTslabs))==NULL)
    {
      printf("AllocDisplacementB E1022 Cannot allocate Displacement Buffer\n");
      return -1022;
    }  
    for (j=0; j<ptpm->NTslabs; j++)   // initialize Displacement buffer to zero
      ptpm->pu_dt[j]=0.0;
    
    // NOW ALLOCATE DISPLACEMENT AT t-dt
    if ((ptpm->pudtm = (double**)malloc(sizeof(double*)*ptpm->mesh.fn))==NULL)
    {
      printf("AllocDisplacementB E03 Cannot allocate Displacement Buffer\n");
      return -3;
    }
    
    for (i=0; i<ptpm->mesh.fn; i++) 
      {
	if ((ptpm->pudtm[i]=(double*)malloc(sizeof(double)*ptpm->NTslabs))==NULL)
	{
	  printf("AllocDisplacementB E1033 Cannot allocate Displacement Buffer\n");
	  return -1033;
	}
	for (j=0; j<ptpm->NTslabs; j++)	// initialize Displacement buffer to zero
	  ptpm->pudtm[i][j]=0.0;
      }
    return 1;
}

int FreeDisplacementB(TPM* ptpm)
{
  int	i;
  
  for (i=0; i<ptpm->mesh.fn; i++)			// frees Buffers for each facet
    if (!ptpm->pu[i]) free(ptpm->pu[i]);		
 
  for (i=0; i<ptpm->mesh.fn; i++)			// frees Buffers for each facet
    if (!ptpm->pudtm[i]) free(ptpm->pudtm[i]);		
  
  if (!ptpm->pu) free(ptpm->pu);			// frees main pointer
  if (!ptpm->pudtm) free(ptpm->pudtm);
  if (!ptpm->pu_dt) free(ptpm->pu_dt);
}

int calcTempTIandDisplacement(TPM* ptpm, VECTOR sun)
{
	double	TSS;
	int		i;
	double	HelioD=NORMA(sun);
	VECTOR	sunN={sun.x/HelioD, sun.y/HelioD, sun.z/HelioD};

// calculate the illumination of the Sun
	meshillumination(&ptpm->mesh, sun);	
// reset the temperature buffer	
        memset(ptpm->pTemp, 0, sizeof(float)*ptpm->mesh.fn);  

// calculate the heatdiffusion and the Displacement
	DiffuseHeatANDDisplace(ptpm, HelioD);

// copy temperatures back to temperature buffer
    for (i=0;i<ptpm->mesh.fn;i++)
		  ptpm->pTemp[i]=ptpm->pTB[i][0];
	return 1; // success
}


int PrintDisplacement(TPM* ptpm, double JD, FILE** ppfh)
{
	int		i, ix;
	FILE*		pfh;
	double		lambda, beta, rxy;

	pfh=ppfh[0];
	printf("running PrintDisplacement\n");

	if (pfh==NULL)
	{
	  printf("Attempting to open displacemnt file...");
	  if ( (pfh=fopen("tmap_displacement.dat", "wt"))==NULL)
	  {
	    fprintf(stderr, "PrintDisplacement: cannot open tmap_displacement.dat file\n");	  
	    return -1;
	  }
	  // pass back pointer
	  *ppfh=pfh;
	  printf("done\n");
	}

	for (i=0; i<ptpm->mesh.fn; i++)	// for each facet
	{
		rxy=sqrt(ptpm->mesh.c[i].x*ptpm->mesh.c[i].x + ptpm->mesh.c[i].y*ptpm->mesh.c[i].y);
		lambda=atan2(ptpm->mesh.c[i].y, ptpm->mesh.c[i].x)*RADEG;
		if (lambda<0) lambda+=360.0;
		if (rxy!=0)
		  beta=atan(ptpm->mesh.c[i].z/rxy)*RADEG;
		else
		{
		  if (ptpm->mesh.c[i].z>0) beta=90.0;
		  else beta=-90.0;
		}
//		fprintf(pfh, "%4d  %6.1lf %6.1lf %6.1lf %6.1lf %6.1lf\t", i, ptpm->mesh.c[i].x, ptpm->mesh.c[i].y, ptpm->mesh.c[i].z,lambda, beta);
		fprintf(pfh, "%lf\t%lf\t%lf", JD, ptpm->dt, ptpm->dx);
		fprintf(pfh, "%5d %6.1lf %6.1lf\t%d\t", i, lambda, beta, ptpm->NTslabs);
	
		if (ptpm->Gamma>0)		// if there is a buffer of temps towards the core
		{
		  for (ix=0; ix<ptpm->NTslabs; ix++)
		    fprintf(pfh, " %5.1lf", ptpm->pu[i][ix]);		
		} else
		{
	  	  fprintf(pfh, " %5.1lf", -1.0);		
		}
		fprintf(pfh, "\n");		    
	}	
}

int DiffuseHeatANDDisplace(TPM* ptpm, double HelioD)
{
  int	i, ix;
  unsigned long Niter=0;
  double  omega=D2PI/(ptpm->Tsid), sqrtomega=sqrt(omega);
  double  c1=omega/ptpm->dx/ptpm->dx;
  double  c2=sqrtomega/ptpm->Gamma/ptpm->dx;
  double  cons1 = ptpm->dt* omega/ptpm->dx/ptpm->dx;
  double  cons2 = 2.*ptpm->dt* sqrtomega/ptpm->Gamma/ptpm->dx;
  double  cons3 = (1.0 - ptpm->A)*SOLARC*ptpm->SunLuminosity/HelioD/HelioD; 
  double  dt=ptpm->dt, t=0;
  // Duhamel-Neumann aux variables
  double  zeta, xi, psi=ptpm->alpha*(3.*ptpm->lambda+2.*ptpm->mu)/(2.*ptpm->mu+ptpm->lambda)*ptpm->dz;
  double  T0; // average facet temperature (with depth)


  printf("\n****\n");
  printf("dt=%lf\tdz=%lf\t", dt, ptpm->dz);   
  for (ix=0; ix<4; ix++) printf("%e ",ptpm->pu[0][ix]);
  printf("...");
  for (ix=(ptpm->NTslabs-5); ix<(ptpm->NTslabs-1); ix++) printf("%e ",ptpm->pu[0][ix]);
  printf("\n");
  for (ix=0; ix<4; ix++) printf("%7.1lf",ptpm->pTB[0][ix]);
  printf("...");
  for (ix=(ptpm->NTslabs-5); ix<(ptpm->NTslabs-1); ix++) printf("%7.1lf",ptpm->pTB[0][ix]);
  printf("\n");

	// do iterations!!!
	while (t<ptpm->dt)
	  {
	    for (i=0; i<ptpm->mesh.fn; i++)	
	      dt=min(dt, ptpm->tr/2/fabs(c1*(ptpm->pTB[i][1]-ptpm->pTB[i][0]) - 
					 c2* ( ptpm->epsilon * SIGMA * 
					       ptpm->pTB[i][0]*ptpm->pTB[i][0]*ptpm->pTB[i][0]*ptpm->pTB[i][0] - 
					       cons3 * ptpm->mesh.ill[i])));
	      //	    printf("%lf\t",ptpm->pTB[i][1]-ptpm->pTB[i][0]);
	    cons1 = dt*omega/ptpm->dx/ptpm->dx;
	    cons2 = 2.*dt*sqrtomega/ptpm->Gamma/ptpm->dx;

	    // calculate the value of the auxiliary variables for the Duhamel-Neumann equation
	    xi=1.0; //(2*ptpm->mu+ptpm->lambda)*dt*dt/ptpm->rho/ptpm->dz/ptpm->dz;
	    zeta=1.0;//ptpm->alpha*(3*ptpm->lambda+2*ptpm->mu)*dt*dt/ptpm->rho/ptpm->dz;
	    printf("xi=%lf zeta=%lf psi=%e\n",xi,zeta,psi);

	    for (i=0; i<ptpm->mesh.fn; i++)	// for each facet
	      {
		// heat diffusion equation in the depth
		for (ix=1; ix<(ptpm->NTslabs-1); ix++)
		  ptpm->pTB_dt[ix] = ptpm->pTB[i][ix] + cons1* (ptpm->pTB[i][ix+1] - 2*ptpm->pTB[i][ix] + ptpm->pTB[i][ix-1]);

		//calculate the surface temperature: boundary condition
		ptpm->pTB_dt[0] = ptpm->pTB[i][0] + 
		  2.* cons1 * ( ptpm->pTB[i][1]-ptpm->pTB[i][0] ) -
		  cons2 * ( ptpm->epsilon * SIGMA * 
			    ptpm->pTB[i][0]*ptpm->pTB[i][0]*ptpm->pTB[i][0]*ptpm->pTB[i][0] - 
			    cons3 * ptpm->mesh.ill[i]);

		// impose boundary condition at latest elements of the buffer
		ptpm->pTB_dt[ix] = ptpm->pTB_dt[ix-1] = ptpm->pTB[i][ix-2];

		// calculate average temperature of the buffer
		T0=ptpm->pTB_dt[ix]; // equal to the temperature at max depth
		//for (ix=0; ix<(ptpm->NTslabs-1); ix++) T0+=ptpm->pTB_dt[ix]; T0/=ptpm->NTslabs;

		// before copying the temperature at t+dt in the facet buffer at time t
		// we need to calculate the displacement using the Duhamel-Neumann equation
/*		// advance the solution for the Displacement using the Duhamel-Neumann equation
		for (ix=1; ix<(ptpm->NTslabs-1); ix++)
		  ptpm->pu_dt[ix] = xi*(ptpm->pu[i][ix+1]-2*ptpm->pu[i][ix]+ptpm->pu[i][ix-1]) -
		                    zeta*(ptpm->pTB[i][ix+1]-ptpm->pTB[i][ix])+
		                    2*ptpm->pu[i][ix]-ptpm->pudtm[i][ix];
 		// IMPOSE boundary conditions at max depth
		ptpm->pu_dt[ix] = ptpm->pu_dt[ix-1] = ptpm->pu[i][ix-2];
		// IMPOSE boundary condition at the surface
 */		ptpm->pu_dt[0]=ptpm->pu_dt[1]-psi*(ptpm->pTB_dt[0]-T0);

		// copy the current displacement buffer in the displacement buffer at t-1 
		memcpy(ptpm->pudtm[i], ptpm->pu[i], sizeof(double)*ptpm->NTslabs);
		// copy the displacement buffer at t+dt in the current displacement buffer
		memcpy(ptpm->pu[i], ptpm->pu_dt, sizeof(double)*ptpm->NTslabs);

		// copy the temperature at t+dt in the facet buffer
		memcpy(ptpm->pTB[i], ptpm->pTB_dt, sizeof(double)*ptpm->NTslabs);
	      } //for each facet
	    t+=dt; Niter++;
	  }						// for each iteration
	//	  printf("%lf\t%ld\t%lf\n", dt, Niter, ptpm->pu[0][0]);
}
