#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "SLALIB/slalib.h"

//extern void slaCaldj (int iy, int im, int id, double *djm, int *j);

char *Number2MPC(long number, char* pack)
{	
  long k, g;
  char isnum=(short)pack[5];

  k=number/10000;

  //  printf("%ld %ld", k, g);
  if (number<1) return NULL;	// unnumbered object
  if (k<10) 
    {
      g=number % 100000;
      sprintf(pack,"%05ld",g);
    }
  else 
    {
      k+=55;
      g=number % 10000;
      sprintf(pack,"%c%04ld",k,g);
    }
  
  return &pack[0];
}

char *Designation2MPC(char* Designation, char* pack)
{	
  char *pyear, *pletter, *pnumber;
  char syear[5], sletter[3], snumber[4];
  long int  year, number, gg, g;
  char k, kk;

  if ((pletter=strchr(Designation,'_'))==NULL) return NULL;
  pyear=Designation;
  pletter++;
  pnumber=pletter; pnumber++; pnumber++;

  strncpy(syear, pyear, 4); syear[4]=0;
  strncpy(sletter, pletter, 2); sletter[2]=0;
  strncpy(snumber, pnumber, 3); snumber[3]=0;

  //  printf("%4s %2s %3s\n", syear, sletter, snumber);

  year=atol(syear);
  number=atol(snumber);

  k=year/100;
  k+=55;
  g=year % 100;

  kk=number/10;
  
  if (kk>=10)
    {
      kk+=55;
      gg=number % 10;
      sprintf(pack,"%c%02ld%c%c%01ld%c",k,g,sletter[0],kk,gg,sletter[1]);
    }
  else
    sprintf(pack,"%c%02ld%c%02ld%c",k,g,sletter[0],number,sletter[1]);
}


int main()
{
  char buf[512];
  char pack[50]="";
  long int num;
  char Designation[50];
  char * pch;

  while (NULL!=fgets(buf, 512, stdin))
    {
      if ((pch=strchr(buf,'_'))==NULL)
	{// not found, so the string must be a number
	  num=atol(buf);
	  Number2MPC(num,pack);
	}
      else
	{
	  Designation2MPC(buf, pack);
	}
      printf("%s\n",pack);
    }  
  return(0);
}
