/*
This program converts the Julian Date
into the calendar date.
It makes use of the functions slaDjcl() and slaDd2tf
of the SLALIB

To compile it under windows simply issue the Visual Studio Comamnd Prompt
go to the directory where the program is stored and issue the command
> cl jdcnv.c ..\BAMlib\SLALIB\djcl.c ..\BAMlib\SLALIB\Dd2tf.c
In this case the file djcl.c of the SLALIB is not in the same directory
where the main program is.

Marco Delbo July 16, 2007
*/

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "SLALIB/slalib.h"
#include "SLALIB/slamac.h"

#define USAGE "Usage: CalDat <JD> \n"

void main(int argc, char *argv[])
{
double	dJD, fd, ave=0.;
int		j;
int		iy, im, id, filemode=0;
char	filename[256];
int		ndp=3;
char	sign;
int     ihmsf[4];	// hours, minutes, seconds, fraction

//	printf("%d\n",argc);

    if (argc < 2)
	{
//		printf("No arguments were entered\n");	// so read the JD from the stdio
	    scanf("%lf", &dJD);
//	    printf("%lf\n",dJD);
	} else
	{
		// try to convert to a double
		dJD=atof(argv[1]);
	    printf("%lf\n",dJD);
	}

/*
	if (argc > 2)
	{

		for (j=0; j<argc/2; j++)	// scan additional parameters
		{
		if (strncmp(argv[j*2], "-d", 2)==0)
			ndp=atoi(argv[j*2+1]);
		}
	}
*/

  dJD-=2400000.5;
  slaDjcl (dJD, &iy, &im, &id, &fd, &j);
  if (j!=0) return;
  printf("%04d-%02d-%02d ", iy, im, id);

  slaDd2tf (ndp, fd, &sign, ihmsf);
  printf("%02d:%02d:%02d.%03d\n", ihmsf[0], ihmsf[1], ihmsf[2], ihmsf[3]);
}
