/* this program computes the postion of a planet or asteroid
   given its orbital elements

USAGE
   elem2pos [options] <a> <e> <i> <Omega> <omega> <M> <epoch> <JD>

*/

#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#define  PI  3.1415926535897932384626433832795
#define  RAD 0.017453292519943295769236907684886 // PI/180
#define	 BUFLEN	256
#define  USAGE "Usage: elem2pos \n"

extern int LIBelem2xyzN(int argc, void* argv[]);
extern void slaCaldj (int, int, int, double*, int*);
long   	   MPC2number(char*);
double	   MPC2Epoch(char*);
double 	   vec2angle(double* a, double* b, int N);



// global variables... I won't use many...
int		iverbose;
int		irad=0;		// if set to 1 uses input and output in RADIANS
int		isun=0;		// set it to 1 if you want to output RA and DEC of the Sun
int		ipha=0;		// set it to 1 if you want the phase angle to be printed out
int		impcformat=0;// set it to 1 if you want to input the ref.epoch in the MPC format (string)
int		ieclip=0;	// set it to 1 if you want to output geocentric lambda, beta of asteroid and sun (-s opt)
int		ihelio=0;	// set it to 1 if you want to output heliocentric lambda, beta of asteroid
int             igeo=0;         // set it to 1 if you want to output r and Delta (for thermal models)

main(int argc, char* argv[])
{
	int		j;				//dummy int used genrally in loops
	char	buf[BUFLEN] ; 	//buffer used read data
	double	a, e, i, Omega, omega, M, epoch, jd;	// oscul. orbital elements, ref. epoch and epoch
	double	vdr[3]={1,0,2};	// heliocentric position of the planet [x,y,z]
	double  vde[3]; 		// heliocentric position [x,y,z] of the Earth
	double 	vdDelta[3]; 	// geocentric position [x,y,z] of the planet
	double  dmeanmotion=0.0;
	double	dra, dde;		// ra and dec
	double	draSun, ddeSun;	// ra and dec of the Sun
	double	vdesun[3];		// vector from earth to the Sun
	double  vdrsun[3];  	// vector from planet to the Sun
	double  vdMinusDelta[3];// vector from the planet to the Earth
	double  norma;
	void*	parg[10];
	char	mpcepoch[20];
	double	pha;
	FILE    *fi=stdin;

    if (argc < 3)
	{
		printf("%s\n", USAGE);
		return -1;
	}

	for (j=0; j<argc/2; j++)	// scan additional parameters
	{
/*		if (strncmp(argv[j*2+1], "-f", 2)==0)
		{
			strcpy(filename, argv[j*2+2]);
			filemode=1;
		}
*/		if (strncmp(argv[j*2+1], "-v", 2)==0)
			iverbose=atoi(argv[j*2+2]);
		if (strncmp(argv[j*2+1], "-r", 2)==0)
			irad=atoi(argv[j*2+2]);
		if (strncmp(argv[j*2+1], "-s", 2)==0)
			isun=atoi(argv[j*2+2]);
		if (strncmp(argv[j*2+1], "-p", 2)==0)
			ipha=atoi(argv[j*2+2]);
		if (strncmp(argv[j*2+1], "-m", 2)==0)
			impcformat=atoi(argv[j*2+2]);
		if (strncmp(argv[j*2+1], "-e", 2)==0)		// output ecliptic coordinates
			ieclip=atoi(argv[j*2+2]);
		if (strncmp(argv[j*2+1], "-h", 2)==0)		// output heliocentric ecliptic coordinates
			ihelio=atoi(argv[j*2+2]);
		if (strncmp(argv[j*2+1], "-g", 2)==0)		// output r and Delta
			igeo=atoi(argv[j*2+2]);
	}

//	while (NULL!=gets(buf,BUFLEN))
	while (NULL!=fgets(buf,BUFLEN,fi))
	{
		if (impcformat)
		{
			if ((sscanf(buf, "%s %lf %lf %lf %lf %lf %lf %lf",
			    mpcepoch, &M, &omega, &Omega, &i, &e, &a, &jd) < 8))	// uses MPC column format
			  continue;	// if error continue scaning next line
			epoch=MPC2Epoch(mpcepoch);
		} else {
			if ((sscanf(buf, "%lf %lf %lf %lf %lf %lf %lf %lf",
		       &epoch, &M, &omega, &Omega, &i, &e, &a, &jd) < 8))	// uses MPC column format
			  continue;	// if error continue scaning next line
		}

		if (iverbose)
		{
			printf("Input Orbital elements: epoch, M, omega, Omega, i, e, a, jd\n");
			printf("%lf %lf %lf %lf %lf %lf %lf %lf\n",
			  epoch, M, omega, Omega, i, e, a, jd);
		}

		if (!irad)	// convert to radians
		{
			M*=RAD;
			omega*=RAD;
			Omega*=RAD;
			i*=RAD;
		}

// prepare the argument list
        parg[0]=vdr, parg[1]=&M; parg[2]=&omega, parg[3]=&Omega;
        parg[4]=&i , parg[5]=&e; parg[6]=&a, parg[7]=&dmeanmotion;
        parg[8]=&epoch, parg[9]=&jd;

// call the library function to retrieve the heliocentric position vector of the planet
		LIBelem2xyz(10, parg);//, &M, &omega, &Omega, &i, &e, &a, &dmeanmotion, &epoch, &jd);
		if (iverbose)
			printf("Helioc.planet.vec: %lf %lf %lf (AU)\n", vdr[0], vdr[1], vdr[2]);

// call the library function to retrieve the heliocentric position vector of the Earth
		parg[0]=vde; parg[1]=&jd;
		LIBEarthxyz(2, parg);

	if (iverbose)
			printf("Helioc.Earth.vec: %lf %lf %lf (AU)\n", vde[0], vde[1], vde[2]);

		for(j=0; j<3; j++) 	// calculate additional vectors
		{
			vdesun[j]=-vde[j];
			vdDelta[j]=vdr[j]-vde[j];
			vdrsun[j]=-vdr[j];
			vdMinusDelta[j]=-vdDelta[j];
		}

// convert geocentric planet's position vector to angular coordinates
		parg[0]=vdDelta; parg[1]=&dra; parg[2]=&dde;
		if (!ieclip)
		{
		  	LIBxyz2equator(3, parg);
		} else {
			LIBxyz2ecliptic(3, parg);
		}

		if (!irad)
		{
			dra/=RAD;
			dde/=RAD;
		}

		if (iverbose)
		{
			printf("vdDelta: %lf %lf %lf (AU)\n", vdDelta[0], vdDelta[1], vdDelta[2]);
			printf("vdrsun: %lf %lf %lf (AU)\n", vdrsun[0], vdrsun[1], vdrsun[2]);
			printf("vdesun: %lf %lf %lf (AU)\n", vdesun[0], vdesun[1], vdesun[2]);
			printf("vdMinusDelta: %lf %lf %lf (AU)\n", vdMinusDelta[0], vdMinusDelta[1], vdMinusDelta[2]);
		}

		printf("%lf %lf\t", dra, dde);

		if ((ihelio) && (ieclip))
		{
			parg[0]=vdr; parg[1]=&dra; parg[2]=&dde;
			LIBxyz2ecliptic(3, parg);

			if (!irad)
			{
				dra/=RAD;
				dde/=RAD;
			}
			printf("%lf %lf\t", dra, dde);
		}

		if (isun)
		{
			parg[0]=vdesun; parg[1]=&dra; parg[2]=&dde;
			if (!ieclip)
			{
			  	LIBxyz2equator(3, parg);
			} else {
				LIBxyz2ecliptic(3, parg);
			}

			if (!irad)
			{
				dra/=RAD;
				dde/=RAD;
			}
			printf("%lf %lf\t", dra, dde);
		}

		if (igeo)
		{
		  printf("%lf %lf ", sqrt(vdr[0]*vdr[0]+vdr[1]*vdr[1]+vdr[2]*vdr[2]), 
			     sqrt(vdDelta[0]*vdDelta[0] + vdDelta[1]*vdDelta[1]+ vdDelta[2]*vdDelta[2]));
		} 
		if (ipha)
		{
			pha=vec2angle(vdrsun, vdMinusDelta, 3);
			if (irad)
			  printf("%lf\n", pha);
			else
			  printf("%lf\n", pha/RAD);
		} else
		{
			printf("\n");
		}

	}

//	LIBelem2xyzN(4, &iverbose);
}


long MPC2number(char* pack)
{
	long number;
	long k=(long)pack[0];
	char isnum=(short)pack[5];

	if (isnum>32) return -1;	// unnumbered object

	if (k>=65) k-=55; else k-=48;
	k*=10000;
	return k+atol(&pack[1]);
}

double	MPC2Epoch(char* pack)
{
	int	year = (int)pack[0];
	int dec;
	int month =(int)pack[3];
	int	day	=(int)pack[4];
	double	Epoch;
	int	status;

	year=(year-55)*100;
	if ((sscanf(&pack[1], "%2d", &dec))!=1) return 0;	// failed
	year+=dec;

	if (month >= 65) month-=55; else month-=48;
	if (day >= 65) day-=55; else day-=48;

	slaCaldj(year, month, day, &Epoch, &status);	// SLALIB fucntion
	if (status !=0) return 0;
	Epoch+=2400000.5;
	return Epoch;
}

double vec2angle(double* a, double* b, int N)
{
	double ps=0.0, normaA=0.0, normaB=0.0;
	int		j;

	for(j=0; j<N; j++)
		ps+=(a[j]*b[j]);

	for(j=0; j<N; j++)
		normaA+=(a[j]*a[j]);

	for(j=0; j<N; j++)
		normaB+=(b[j]*b[j]);

	normaA=sqrt(normaA);
	normaB=sqrt(normaB);

	ps/=normaA;
	ps/=normaB;

	return acos(ps);
}

/*
gcc -O3 -lm -o elem2pos elem2pos.c ../tests/MDBOrbit/MDBOrbit/MDBOrbit.c ../tests/MDBOrbit/MDBOrbit/kepler.c ../BAMlib/SLALIB/caldj.c ../BAMlib/SLALIB/cldj.c ../BAMlib/SLALIB/evp.c ../BAMlib/SLALIB/epj.c ../BAMlib/SLALIB/prec.c ../BAMlib/SLALIB/deuler.c
*/

