/* this program computes the postion of a planet or asteroid
   given its orbital elements

USAGE
   elem2v [options] <a> <e> <i> <Omega> <omega> <M> <epoch> <JD>

*/

#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#define  GK		0.01720209895e0                         // to calculate the mean motion in rad/days
#define  PI  3.1415926535897932384626433832795
#define  RAD 0.017453292519943295769236907684886 // PI/180
#define	 BUFLEN	256
#define USAGE "\n\
  -h this help\n\
  -n <meanmotion> in rad/days = GK/\sqrt(a^3) where a in AU GK=0.01720209895e0 \n\
  -v Set to VERBOSE output mode \n\
  -m Ste the MPC epoch format \n\
  -M set the mass of the sun in SolarMassUnit e.g. -M 0.9 is a star 90% the mass of the sun \n\
  enter epoch, M, omega, Omega, i, e, a, jd (dummy) JD0 JD1 JDstep\n"

extern int LIBelem2xyzN(int argc, void* argv[]);
extern void slaCaldj (int, int, int, double*, int*);
long   	   MPC2number(char*);
double	   MPC2Epoch(char*);
double 	   vec2angle(double* a, double* b, int N);

#define RAD		0.017453292519943295769236907684886 	// PI/180
#define OBL		0.4090928042223289096135375		// J2000 obliquity in radians, IAU
#define COBL		0.91748206206918183682560225347235	// cosine of the J2000 obliquity in radians, IAU
#define SOBL		0.39777715593191367603721308989317	// sine of the J2000 obliquity in radians, IAU


// global variables... I won't use many...
int		iverbose;
int		irad=0;		// if set to 1 uses input and output in RADIANS
int		ipha=0;		// set it to 1 if you want the phase angle to be printed out
int		impcformat=0;// set it to 1 if you want to input the ref.epoch in the MPC format (string)
int		ieclip=0;	// set it to 1 if you want to output x,y,z ecliptic otherwise x,y,z are equatorial
int		ihelio=0;	// set it to 1 if you want to output heliocentric lambda, beta of asteroid
int		iEarth=0;	// set it to 1 if you want Eearth X,Y,Z position to be printed out
int             igeo=0;         // set it to 1 if you want to output r and Delta (for thermal models)

main(int argc, char* argv[])
{
	int		j;				//dummy int used genrally in loops
	char	buf[BUFLEN] ; 	//buffer used read data
	double	a, e, i, Omega, omega, M, epoch, jd;	// oscul. orbital elements, ref. epoch and epoch
	double	vdr[3]={1,0,2};	// heliocentric position of the planet [x,y,z]
	double  vde[3]; 		// heliocentric position [x,y,z] of the Earth
	double 	vdDelta[3]; 	// geocentric position [x,y,z] of the planet
	double  dmeanmotion=0.0;
	double  dmasssun=0.0;
	double	dra, dde;		// ra and dec
	double	draSun, ddeSun;	// ra and dec of the Sun
	double	vdesun[3];		// vector from earth to the Sun
	double  vdrsun[3];  	// vector from planet to the Sun
	double  vdMinusDelta[3];// vector from the planet to the Earth
	double  norma;
	void*	parg[10];
	void*	pEarthArg[10];
	char	mpcepoch[20];
	double	pha;
	double	JD0, JD1, JDstep;
	double  vdr1tmp, vde1tmp;

        while (argc>1)
        {
                if (argv[1][0]=='-')
                {
                switch (argv[1][1])
                {
 
                case 'h': printf("%s\n",USAGE); exit(0);
                        break;
		case 'v': iverbose=1;
                        break;
		case 'r': irad=1;
                        break;
		case 'm': impcformat=1;
                        break;
		case 'e': iEarth=1;
                        break;
		case 'g': igeo=1;
                        break;
		case 'M':
                        argc--;
                        argv++;
			dmasssun=atof(argv[1]);
                        break;
		case 'n':
                        argc--;
                        argv++;
			dmeanmotion=atof(argv[1]);
                        break;
		default:
		  printf("unknown option -%s\n",argv[1][1]);
                return 0;
                      break;
                  } //switch
                }
                argc--; argv++;
         }


		if (impcformat)
		{
			if ((scanf("%s %lf %lf %lf %lf %lf %lf %lf",
			    mpcepoch, &M, &omega, &Omega, &i, &e, &a, &jd) < 8))	// uses MPC column format
			  return -1;	// if error continue scaning next line
			epoch=MPC2Epoch(mpcepoch);
		} else {
			if ((scanf("%lf %lf %lf %lf %lf %lf %lf %lf",
		       &epoch, &M, &omega, &Omega, &i, &e, &a, &jd) < 8))	// uses MPC column format
			  return -1;	// if error continue scaning next line
		}

		if (iverbose)
		{
			printf("Input Orbital elements: epoch, M, omega, Omega, i, e, a, jd\n");
			printf("%lf %lf %lf %lf %lf %lf %lf %lf\n",
			  epoch, M, omega, Omega, i, e, a, jd);
		}

		if (!irad)	// convert to radians
		{
			M*=RAD;
			omega*=RAD;
			Omega*=RAD;
			i*=RAD;
		}

		if ((dmeanmotion==0) && (dmasssun!=0)) 
		  dmeanmotion=GK*sqrt(dmasssun)/a/sqrt(a);

//set up args for the Asteroid for the library call
        parg[0]=vdr, parg[1]=&M; parg[2]=&omega, parg[3]=&Omega;
        parg[4]=&i , parg[5]=&e; parg[6]=&a, parg[7]=&dmeanmotion;
        parg[8]=&epoch, parg[9]=&jd;

//set up args for the Earth for the library call
	pEarthArg[0]=vde; pEarthArg[1]=&jd;

// read jd0 jd1 and jdstep
	if ((scanf("%lf %lf %lf", &JD0, &JD1, &JDstep) < 3))	// uses MPC column format
		return -1;
	if (iverbose)
	{
			printf("jd0, jd1, jdstep\n");
			printf("%lf %lf %lf\n", JD0, JD1, JDstep);
	}

	jd=JD0;
	while (jd<=JD1)
	{
		parg[9]=&jd;
// call the library function to retrieve the heliocentric position vector of the planet
		LIBelem2xyz(10, parg);//, &M, &omega, &Omega, &i, &e, &a, &dmeanmotion, &epoch, &jd);

		LIBEarthxyz(2, pEarthArg);

//rotate from equatorial to ecliptic
	  if (ieclip == 1)
	  {
		vdr1tmp =  vdr[1]*COBL + vdr[2]*SOBL;
		vdr[2]  = -vdr[1]*SOBL + vdr[2]*COBL;
		vdr[1]  = vdr1tmp;
	  	if (iEarth)
		{
		  vde1tmp =  vde[1]*COBL + vde[2]*SOBL;
		  vde[2]  = -vde[1]*SOBL + vde[2]*COBL;
		  vde[1]  = vde1tmp;
		}
	  }
	    printf("%lf\t", jd);
	        if (igeo)
		  {
		    for(j=0; j<3; j++) 	// calculate additional vectors
		      {
			vdesun[j]=-vde[j];
			vdDelta[j]=vdr[j]-vde[j];
			vdrsun[j]=-vdr[j];
			vdMinusDelta[j]=-vdDelta[j];
		      }
			pha=vec2angle(vdrsun, vdMinusDelta, 3);
		        printf("%lf %lf %lf\t", sqrt(vdr[0]*vdr[0]+vdr[1]*vdr[1]+vdr[2]*vdr[2]), 
			    sqrt(vdDelta[0]*vdDelta[0] + vdDelta[1]*vdDelta[1]+ vdDelta[2]*vdDelta[2]),
			    pha/RAD);
		    
		  }
	        if (iEarth)
		printf("%lf %lf %lf %lf %lf %lf \n", vdr[0], vdr[1], vdr[2], vdr[0]-vde[0], vdr[1]-vde[1], vdr[2]-vde[2]);
		else
		printf("%lf %lf %lf\n", vdr[0], vdr[1], vdr[2]);
		jd+=JDstep;
	}
}


long MPC2number(char* pack)
{
	long number;
	long k=(long)pack[0];
	char isnum=(short)pack[5];

	if (isnum>32) return -1;	// unnumbered object

	if (k>=65) k-=55; else k-=48;
	k*=10000;
	return k+atol(&pack[1]);
}

double	MPC2Epoch(char* pack)
{
	int	year = (int)pack[0];
	int dec;
	int month =(int)pack[3];
	int	day	=(int)pack[4];
	double	Epoch;
	int	status;

	year=(year-55)*100;
	if ((sscanf(&pack[1], "%2d", &dec))!=1) return 0;	// failed
	year+=dec;

	if (month >= 65) month-=55; else month-=48;
	if (day >= 65) day-=55; else day-=48;

	slaCaldj(year, month, day, &Epoch, &status);	// SLALIB fucntion
	if (status !=0) return 0;
	Epoch+=2400000.5;
	return Epoch;
}

double vec2angle(double* a, double* b, int N)
{
	double ps=0.0, normaA=0.0, normaB=0.0;
	int		j;

	for(j=0; j<N; j++)
		ps+=(a[j]*b[j]);

	for(j=0; j<N; j++)
		normaA+=(a[j]*a[j]);

	for(j=0; j<N; j++)
		normaB+=(b[j]*b[j]);

	normaA=sqrt(normaA);
	normaB=sqrt(normaB);

	ps/=normaA;
	ps/=normaB;

	return acos(ps);
}

/*
gcc -O3 -lm -o elem2v elem2v.c ../tests/MDBOrbit/MDBOrbit/MDBOrbit.c ../tests/MDBOrbit/MDBOrbit/kepler.c ../BAMlib/SLALIB/caldj.c ../BAMlib/SLALIB/cldj.c ../BAMlib/SLALIB/evp.c ../BAMlib/SLALIB/epj.c ../BAMlib/SLALIB/prec.c ../BAMlib/SLALIB/deuler.c
*/
