#include<stdio.h>
#include<math.h>
#include<float.h>
#include<stdlib.h>
#include<string.h>

#ifndef MESH_H
#include "../tpm/mesh.h"
#endif

#ifndef CONSTANTS_H
#include "../tms/constants.h"
#endif

#ifndef MACROS_H
#include "../tms/macros.h"
#endif

int comp_maxnorm(VECTOR * pv, int vn, VECTOR * bary, int *pindmaxnorm, double *pmaxnorm)
{
    double norm={0};
    int i;
    double nx, ny, nz;
    double maxnorm=0;
    int    imaxnorm;

    memset(&norm, 0, sizeof(norm));

    for(i=0;i<vn;i++)
    {
        nx = (pv[i].x-bary[0].x)*(pv[i].x-bary[0].x);
        ny = (pv[i].y-bary[0].y)*(pv[i].y-bary[0].y);
        nz = (pv[i].z-bary[0].z)*(pv[i].z-bary[0].z);
        norm = sqrt(nx+ny+nz);
        if (norm>maxnorm) 
        {
            maxnorm=norm;
            imaxnorm=i;
        }
    }
    *pindmaxnorm=imaxnorm;
    *pmaxnorm = maxnorm;
    printf("#TEST_maxnorm : indice du sommet : %i\n#norme maximale : %lf\n", imaxnorm, maxnorm);
    printf("#TEST_maxnorm : coordonnee x du point d'indice imaxnorm : %lf\n", pv[imaxnorm].x);
    printf("#TEST_maxnorm : coordonnee y du point d'indice imaxnorm : %lf\n", pv[imaxnorm].y);
    printf("#TEST_maxnorm : coordonnee z du point d'indice imaxnorm : %lf\n\n", pv[imaxnorm].z);
    return 1;
}


int major_axis(VECTOR * pv, int vn, VECTOR * bary, double maxnorm, int indmaxnorm, double inv_maxnorm, VECTOR * pinv_coornorm, VECTOR * pinv_coorbp, double * majoraxis)
{

    double mnorm={0};
    int i;
    double Cx, Cy, Cz, a, b, c;
    VECTOR inv_coornorm ={0,0,0};
    VECTOR vect;
    double scal=0;
    double scalmax=0;

    memset(&mnorm, 0, sizeof(mnorm));
    memset(&inv_coornorm, 0, sizeof(inv_coornorm));
    memset(pinv_coorbp, 0, sizeof(*pinv_coorbp));
    memset(majoraxis,0,sizeof(*majoraxis));

    Cx = pv[indmaxnorm].x/maxnorm;
    Cy = pv[indmaxnorm].y/maxnorm;
    Cz = pv[indmaxnorm].z/maxnorm;
    
    //Coordinates of BP' vector
    inv_coornorm.x = -Cx*maxnorm + bary[0].x;
    inv_coornorm.y = -Cy*maxnorm + bary[0].y;
    inv_coornorm.z = -Cz*maxnorm + bary[0].z;

    //Coordinates of vector BP' compared with barycenter (not in the orthonormal basis)
    pinv_coorbp[0].x = -Cx*maxnorm;
    pinv_coorbp[0].y = -Cy*maxnorm;
    pinv_coorbp[0].z = -Cz*maxnorm;

    printf("TEST_axemax : coordinates BP' : %lf%lf%lf\n", pinv_coorbp[0].x, pinv_coorbp[0].y, pinv_coorbp[0].z);

    //Calculation of norm of BP' compared with barycenter
    a = (pinv_coorbp[0].x)*(pinv_coorbp[0].x);
    b = (pinv_coorbp[0].y)*(pinv_coorbp[0].y);
    c = (pinv_coorbp[0].z)*(pinv_coorbp[0].z);
    inv_maxnorm = sqrt(a+b+c);
    printf("#TEST_axemax : norm of vector BP': %lf\n", inv_maxnorm);
    
    //Normaliszation of vector BP'
    pinv_coorbp[0].x /= inv_maxnorm;
    pinv_coorbp[0].y /= inv_maxnorm;
    pinv_coorbp[0].z /= inv_maxnorm;
    printf("TEST_axemax : Normalization BP' : %lf%lf%lf\n", pinv_coorbp[0].x, pinv_coorbp[0].y, pinv_coorbp[0].z);

    //Projection
    for(i=0;i<vn;i++)
    {
        vect.x = pv[i].x - bary[0].x;
        vect.y = pv[i].y - bary[0].y;
        vect.z = pv[i].z - bary[0].z;
        scal = pinv_coorbp[0].x*vect.x + pinv_coorbp[0].y*vect.y + pinv_coorbp[0].z*vect.z; 
        if(scal>scalmax)
        {
            scalmax=scal;
        }
    }
    printf("#TEST_axemax : Scalar product max : %lf\n", scalmax);
    //Calculation of the major axis 
    majoraxis[0] = maxnorm  + scalmax;
    printf("\n######## MAJOR AXIS : %lf km ########\n\n", majoraxis[0]);
}

int second_axis(VECTOR *pv, int vn, double maxnorm, int indmaxnorm, int *pimaxproj, VECTOR * bary, VECTOR * pcoorbp, VECTOR * inv_coorbp, VECTOR *pcoorprojmax, VECTOR * pinv_coorprojmax, double *secondaxis)
{
    int i;
    double Cx, Cy, Cz;
    double Dy, Dz, d, e;
    double alpha, beta;
    double pvx, pvy, pvz;
    double normproj, normprojmax, invnormprojmax;
    double scalproj=0;
    double scalprojmax=0;
    double test;
    VECTOR coorbp = {0,0,0};
    VECTOR rot_zalpha;
    VECTOR Mrot;
    VECTOR BPr2;
    
    memset(&coorbp, 0, sizeof(coorbp));
    memset(pinv_coorprojmax, 0, sizeof(*pinv_coorprojmax));
    memset(pcoorprojmax, 0, sizeof(*pcoorprojmax));
    memset(pimaxproj, 0, sizeof(*pimaxproj));
    memset(secondaxis,0,sizeof(*secondaxis));
    
    printf("#TEST : secondaxis : ANCIENNES Coordonnees : %lf %lf %lf\n", pv[385].x, pv[385].y, pv[385].z);
    //Change of the Origin
    for(i=0;i<vn;i++)
    {
        pv[i].x -= bary[0].x;
        pv[i].y -= bary[0].y;
        pv[i].z -= bary[0].z;
    }
    printf("#TEST : secondaxis : NOUVELLES Coordonnees : %lf %lf %lf\n", pv[indmaxnorm].x, pv[indmaxnorm].y, pv[indmaxnorm].z); 
    
    Cx = pv[indmaxnorm].x/maxnorm;
    Cy = pv[indmaxnorm].y/maxnorm;
    Cz = pv[indmaxnorm].z/maxnorm;
    coorbp.x = Cx*maxnorm;
    coorbp.y = Cy*maxnorm;
    coorbp.z = Cz*maxnorm;

    printf("#TEST : secondaxis : Coordinates vector BP : %lf\t%lf\t%lf\n", coorbp.x, coorbp.y, coorbp.z);

    //Calculation of rotation angles
    beta = atan2(coorbp.z, sqrt(coorbp.y*coorbp.y+coorbp.x*coorbp.x));
    alpha = atan2(coorbp.y, coorbp.x);
   
    //1st ROTATION MATRIX (Rz(alpha))
    rot_zalpha.x = coorbp.x*cos(-alpha)-coorbp.y*sin(-alpha);
    rot_zalpha.y = coorbp.x*sin(-alpha)+coorbp.y*cos(-alpha);
    rot_zalpha.z = coorbp.z;
    
    //2nd ROTATION MATRIX (Ry(beta))
    Mrot.x = cos(beta)*rot_zalpha.x + sin(beta)*rot_zalpha.z;
    Mrot.y = rot_zalpha.y;
    Mrot.z = -sin(beta)*rot_zalpha.x + cos(beta)*rot_zalpha.z;

    //SAME BIG MATRIX 1st+2nd matrix
    BPr2.x = cos(beta)*(cos(-alpha)*inv_coorbp[0].x-sin(-alpha)*inv_coorbp[0].y)+sin(beta)*inv_coorbp[0].z;
    BPr2.y = sin(-alpha)*inv_coorbp[0].x+cos(-alpha)*inv_coorbp[0].y;
    BPr2.z = -sin(beta)*(cos(-alpha)*inv_coorbp[0].x-sin(-alpha)*inv_coorbp[0].y)+cos(beta)*inv_coorbp[0].z;
    
    printf("#TEST : secondaxis : INV COOR BP : %lf\t%lf\t%lf\n", inv_coorbp[0].x, inv_coorbp[0].y, inv_coorbp[0].z);
    
    for(i=0;i<vn;i++)
    {     
    pvx = pv[i].x*cos(-alpha)-pv[i].y*sin(-alpha);
    pvy = pv[i].x*sin(-alpha)+pv[i].y*cos(-alpha);
    pvz = pv[i].z;
    pv[i].x = cos(beta)*pvx + sin(beta)*pvz;
    pv[i].y = pvy;
    pv[i].z = -sin(beta)*pvx + cos(beta)*pvz;
    }

    for(i=0;i<vn;i++)
    {
        normproj = sqrt(pv[i].y*pv[i].y + pv[i].z*pv[i].z);
        if (normproj>normprojmax)
        {
            normprojmax = normproj;
            pimaxproj[0]=i;
        }
    }
    //test = sqrt(pv[369].y*pv[369].y+pv[369].z*pv[369].z);   
    printf("#TEST : secondaxis : norm_projmax & coor: %lf %d\t%lf %lf\n", normprojmax, pimaxproj[0], pv[pimaxproj[0]].y, pv[pimaxproj[0]].z);

    //Orientation
    Dy = pv[pimaxproj[0]].y/normprojmax;
    Dz = pv[pimaxproj[0]].z/normprojmax;
    //Norm inverse
    pinv_coorprojmax[0].y = -Dy*normprojmax;    
    pinv_coorprojmax[0].z = -Dz*normprojmax;    
    
    d = pinv_coorprojmax[0].y*pinv_coorprojmax[0].y;    
    e = pinv_coorprojmax[0].z*pinv_coorprojmax[0].z;    
    invnormprojmax = sqrt(d+e); 
    printf("#TEST : secondaxis : INV norm_projmax & INV COOR: %lf %lf\t%lf\n", invnormprojmax, pinv_coorprojmax[0].y, pinv_coorprojmax[0].z);
    
    //Normalization
    pcoorprojmax[0].y = Dy*normprojmax;    
    pcoorprojmax[0].z = Dz*normprojmax;    
    pcoorprojmax[0].y /= normprojmax;
    pcoorprojmax[0].z /= normprojmax;
    pinv_coorprojmax[0].y /= invnormprojmax;
    pinv_coorprojmax[0].z /= invnormprojmax;
    printf("#TEST : secondaxis : Normalization /n: %lf %lf\t%lf %lf\n", pcoorprojmax[0].y, pcoorprojmax[0].z, pinv_coorprojmax[0].y, pinv_coorprojmax[0].z);
    
    //Projection
    for(i=0;i<vn;i++)
    {
        scalproj = pinv_coorprojmax[0].y*pv[i].y + pinv_coorprojmax[0].z*pv[i].z;
        if(scalproj>scalprojmax)
        {
            scalprojmax = scalproj;
        }
    }
    printf("#TEST : secondaxis : SCALPROJMAX : %lf\n", scalprojmax);
    secondaxis[0] = scalprojmax + normprojmax;
    printf("\n######## SECOND AXIS :  %lf km ########\n\n", secondaxis[0]);
    return 1;
}

int third_axis(VECTOR *pv, int vn, int imaxproj, VECTOR *coorprojmax, VECTOR * pcoororthproj, double *thirdaxis)
{
    int i, A, B;
    double Ey, Ez, f, g;
    double scal3 = 0;
    double scalmax3 =0; 
    double invscal3 = 0; 
    double invscalmax3 = 0;
    VECTOR coororthproj = {0,0,0};
    VECTOR inv_coorproj;
    double norm3, inv_norm3;
    FILE* cooryz = NULL;

    memset(&coororthproj,0,sizeof(coororthproj));
    memset(thirdaxis,0,sizeof(*thirdaxis));
   
    //Coordinates of Vertex y, z in the new basis
    cooryz = fopen("list_yz.txt", "w");
    for(i=0;i<vn;i++)
    {
        fprintf(cooryz,"Vertex %d\ty : %lf\tz : %lf\n",i,pv[i].y, pv[i].z);
    }
    fclose(cooryz);

    coororthproj.y = -coorprojmax[0].z;
    coororthproj.z = coorprojmax[0].y;
    inv_coorproj.y = -coororthproj.y;
    inv_coorproj.z = -coororthproj.z;
    printf("#TEST : thirdaxis : coor+ : %lf\t%lf\n", coororthproj.y, coororthproj.z);
    printf("#TEST : thirdaxis : inv coor+: %lf\t%lf\n", inv_coorproj.y, inv_coorproj.z); 
    norm3 = sqrt(coororthproj.y*coororthproj.y + coororthproj.z*coororthproj.z);
    inv_norm3 = sqrt(inv_coorproj.y*inv_coorproj.y + inv_coorproj.z*inv_coorproj.z);
    printf("#TEST : thirdaxis : norm3 & inv_norm3 : %lf\t%lf\n", norm3, inv_norm3);
    //Projection
    for(i=0;i<vn;i++)
    {
        scal3 = coororthproj.y*pv[i].y + coororthproj.z*pv[i].z;
        invscal3 = inv_coorproj.y*pv[i].y + inv_coorproj.z*pv[i].z;
        if(scal3>scalmax3)
        {
            scalmax3 = scal3;
            A = i;
        }
        if(invscal3>invscalmax3)
        {
            invscalmax3 = invscal3;
            B = i;
        }
    }
    printf("#TEST : thirdaxis : indice scalmax %d\n", A);
    printf("#TEST : thirdaxis : coor vertex indice scalmax %lf %lf\n", pv[A].y, pv[A].z);
    printf("#TEST : thirdaxis : indice inv_scalmax %d\n", B);
    printf("#TEST : thirdaxis : coor vertex indice scalmax %lf %lf\n", pv[B].y, pv[B].z);
    printf("#TEST : thirdaxis : SCALPROJMAX : %lf\n", scalmax3);

    printf("#TEST : thirdaxis : INV SCALPROJMAX : %lf\n", invscalmax3);
    thirdaxis[0] = scalmax3+invscalmax3;
    printf("#TEST : THIRD AXIS : %lf\n", thirdaxis[0]);
}

double elipsoidvolume(double majoraxis, double secondaxis, double thirdaxis)
{
    double demima=0;
    double demisa=0;
    double demita=0;
    double vol;

    printf("#TEST : Volume : axis : %lf\t%lf\t%lf\n ", majoraxis, secondaxis, thirdaxis);
    demima=majoraxis/2;
    demisa=secondaxis/2;
    demita=thirdaxis/2;
    printf("#TEST : Volume : semi axis : %lf\t%lf\t%lf\n ", demima, demisa, demita);

    vol = PI*demima*demisa*demita*4.0/3.0;
    printf("#TEST : Volume : %lf\n", vol);
    return vol;
}
