/*
This program calculates the Julian Date
given the calendar date.
It makes use of the function slaCldj() of the
SLALIB

To compile it under windows simply issue the Visual Studio Comamnd Prompt
go to the directory where the program is stored and issue the command
> cl jdcnv.c ..\BAMlib\SLALIB\cldj.c
In this case the file cldj.c of the SLALIB is not in the same directory
where the main program is.

Marco Delbo June 11, 2007
*/

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "SLALIB/slalib.h"

#define USAGE "Usage: JDcnv <year> <month> <day> <hours>\n"

int convertfile(char*, double*);

main(int argc, char *argv[])
{
  double  JD, hours=-1, ave=0., min=-1, sec=-1, JDave=0.0;
  double  dayFloat, dayFraction;
  int	  j, N=0;
  int  	  year=0, month=0, day=0, filemode=0;
  char	  filename[256];
  char    lineBuf[256];

	while (argc>1)
	{
		if (argv[1][0]=='-')
		{
		  switch (argv[1][1])
		    {
		    case 'f': 	// force to change the value of betaE
		      argc--; argv++; 
		      strcpy(filename, argv[1]);
		      filemode=1;
		      break;
		    case 'a':
		      ave=1.;
		      break;
		    default:
		      printf("unknown option -%s\n",argv[1][1]);
		      return 0;
		      break;
		    }
		} 
		argc--; argv++; 
	}

  if (filemode)
    return convertfile(filename, &ave);
  

  while (NULL!=fgets(lineBuf,256,stdin))
  {
    if (lineBuf[0]=='#') continue;      
    if (sscanf(lineBuf, "%d %d %lf %lf %lf %lf", &year, &month, &dayFloat, &hours, &min, &sec)<3) continue;
    day = (int) dayFloat;
    dayFraction=(dayFloat-day);

    slaCldj(year, month, day, &JD, &j);
    JD+=2400000.5;
    
    if (hours>0)
      JD+=(hours/24.0);
    if (min>0)
      JD+=(min/1440.0);
    if (sec>0)
      JD+=(sec/86400.0);
    
    if (dayFraction>0) JD+=dayFraction;
    dayFraction=0;
    
    if (!ave) printf("%18.10f\n", JD);
    JDave+=JD;
    N++;
  }

  if (ave)
    {
      printf("%18.10f\n", JDave/N);
    }
  
}

int convertfile(char* filename, double *average)
{
	FILE	*fh;
	char	buf[256];
	double	JD, hours, JDave=0.0;
	int		year, month, day, j, ave=0, N=0, errn=0;

//    printf("converting file %s\n", filename);

	if ((fh=fopen(filename, "rt"))==NULL)
	{
		printf("error -501: Cannot open file\n");
		return -501;
	}

	if (average[0] == 1.0)
		ave=1;

    while (!feof(fh))
    {
    	if (NULL==fgets(buf,256,fh))
    	{
//			printf("error -502: Input past end of file\n");
			errn=-502;
			break;
		}

 //   	printf(">%s\n", buf);

		if ((sscanf(buf, "%d %d %d %lf", &year, &month, &day, &hours))<4)
		{
//			printf("error -503: Input error while scanning line\n");
			errn= -503;
			break;
		}

  		slaCldj (year, month, day, &JD, &j );
  		JD+=2400000.5;
  		JD+=hours/24.0;
  		JDave+=JD;
  		N++;
  		if (!ave) printf("%18.10f\n", JD);
	}

    if (ave)
    {
		average[0]=JDave/N;
		printf("%18.10f\n", average[0]);
	}

	fclose(fh);
	return errn;
}
