#include <stdio.h>
#include <math.h>

#ifndef MESH_H
#include "../tpm/mesh.h"
#endif
#ifndef ELLIPS_H
#include "ellips.h"
#endif


int main()
{
    char fname[256];
    VECTOR *pv=NULL;
    VECTOR bary;
    FACET *pf=NULL;
    int  vn;
    int  fn;
    double maxsize;
    int i, j;
    double maxnorm, minnorm, majoraxis, secondaxis, thirdaxis;
    int indmaxnorm, indminnorm, imaxproj;
    double inv_maxnorm;
    VECTOR coorbp;
    VECTOR inv_coornorm;
    VECTOR inv_coorbp;
    scanf("%s", fname );
    VECTOR vect;
    VECTOR inv_coorprojmax;
    VECTOR coorprojmax;
    VECTOR coororthproj;
    double mesh_vol;

    if(pv) free(pv);
    if(pf) free(pf);
    ReadWavefront(fname, &pv, &pf, &vn, &fn, &maxsize);
    calc_barycenter(pv, vn, &bary);
    comp_maxnorm(pv, vn, &bary, &indmaxnorm, &maxnorm);
    major_axis(pv, vn, &bary, maxnorm, indmaxnorm, inv_maxnorm, &inv_coornorm, &inv_coorbp, &majoraxis);
    second_axis(pv, vn, maxnorm, indmaxnorm, &imaxproj, &bary, &coorbp, &inv_coorbp, &coorprojmax, &inv_coorprojmax, &secondaxis); 
    third_axis(pv, vn, imaxproj, &coorprojmax, &coororthproj, &thirdaxis);
    elipsoidvolume(majoraxis, secondaxis, thirdaxis);
    mesh_vol = meshvolume2(pv, pf, fn); // emilie 2010 aug 2
    printf("Mesh Volume : %lf\n", mesh_vol);
    //    printf("\no> %lf %lf %lf\n", majoraxis/2, secondaxis/2, thirdaxis/2);
    return 42;
}
