#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "SLALIB/slalib.h"

// MDB 2014 feb 26. modified to run multiline requests. 

//extern void slaCaldj (int iy, int im, int id, double *djm, int *j);

long MPC2number(char* pack)
{	
  long number;
  long k=(long)pack[0];
  char isnum=(short)pack[5];
  
  if (isnum>32) return -1;	// unnumbered object
  if (k>=65) k-=55; else k-=48;
  k*=10000;
  return k+atol(&pack[1]);
}

double	MPC2Epoch(char* pack)
{
  int    year = (int)pack[0];
  int    dec;
  int    month =(int)pack[3];
  int	 day   =(int)pack[4];
  double Epoch;
  int	 status;
  
  year=(year-55)*100;
  if ((sscanf(&pack[1], "%2d", &dec))!=1) return 0;	// failed
  
  year+=dec;
  
  if (month >= 65) month-=55; else month-=48;
  if (day >= 65) day-=55; else day-=48;
  
  slaCaldj(year, month, day, &Epoch, &status );	// SLALIB fucntion
  
  if (status !=0) return 0;
  Epoch+=2400000.5;	 
  return Epoch;
}

long MPC2Designation(char* pack, char* Designation)
{	
  long number;
  int k=(int)pack[0];
  int m=(int)pack[4];
  char CycleCountString[3];
  int CycleCount;

  strncpy(CycleCountString, &pack[4], 2); CycleCountString[3]=0;
  CycleCount=atoi(CycleCountString);  

  if (k>=65) k-=55; else k-=48;
  if (m>=65) m-=55; else m-=48;
  //  printf("%s %d\n",CycleCountString,CycleCount);

  if (pack[4]<58) // the first cycle count digit is a number: so cycle count <=99
    {
      if (CycleCount==0)
	sprintf(Designation,"%2d%c%c_%c%c",k,pack[1],pack[2],pack[3],pack[6]);
      else
	sprintf(Designation,"%2d%c%c_%c%c%d",k,pack[1],pack[2],pack[3],pack[6],CycleCount);
      return 0;
    }
  else { // the first cycle count digit is a LETTER: so decodes it
    CycleCount=((int)pack[4]-65)*10+100+((int)pack[5]-48); 
    if (CycleCount>359) // it uses small letters
      CycleCount=((int)pack[4]-97)*10+360+((int)pack[5]-48); 
    sprintf(Designation,"%2d%c%c_%c%c%d",k,pack[1],pack[2],pack[3],pack[6],CycleCount);
  }

  return 0;
}


int main()
{
  char buf[512];
  char pack[50];
  long num;
  char Designation[50];
  
  while (NULL!=fgets(buf, 512, stdin))
    {
      sscanf(buf, "%s", pack);
      num=atol(pack);
      if (num>0) 
	{
	  printf("%ld %s %s\n", num, "NotApp", pack);
	  continue;
	}
      num= MPC2number(pack);
      MPC2Designation(pack, Designation);
      if (num<1) printf("%ld %s %s\n", num, Designation, pack);
      else
	printf("%ld %s %s\n", num, "NotApp", pack);      
    }
  
  return(0);
}
