#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "SLALIB/slalib.h"

#define NCHAR 256
#define CALDAT 2
#define JDDAT  1
#define USAGE "\n\
  This is the MPC OBS 2 mag (delbo@oca.eu)\n\
  extract reduced magnitude at 1 AU from Earth and Sun from the MPC OBS file\n\
  the OBS file can be downloaded from:\n\
http://www.minorplanetcenter.org/iau/ECS/MPCOBS/MPCOBS.html \n\
  -h this help\n\
  +d output calendar date\n\
  +j output JD epoch (default) \n"

void ioerr(char* st, int code)
{
  fprintf(stderr,"%s\n",st);
  exit(code);
}

main(int argc, char* argv[])
{
  FILE* file_in=NULL;
  char  linebuf[NCHAR];
  char  auxlinebuf[NCHAR];
  char  date[11];
  char  fileinname[512];
  int   year, month, day, j;
  float dayfr, mag;
  double JD, oldjd;
  unsigned int mode=0;
  char  flag;
  char  band;
  char  obs[4];

  mode=mode+JDDAT+CALDAT;

//	SCANS the arguments
  while (argc>2)
    {
      if (argv[1][0]=='-')
	{
	  switch (argv[1][1])
	    {
	    case 'h': printf("%s\n",USAGE); exit(0);
	      break;
	    case 'd': // remove output of the calendar date
	      mode ^= CALDAT;
	      break;
	    case 'j': // remove output of the calendar date
	      mode ^= JDDAT;
	      break;
	    case 'f': // uses input file
	      argc--; argv++;
	      file_in=fopen(argv[1],"rt");
	      if (file_in==NULL) ioerr("file not found", -1);
	      stdin=file_in;
	      break;
	    default:
	      printf("unknown option -%s\n",&argv[1][1]);
	      return 0;
	    }
	}
      if (argv[1][0]=='+')
	{
	  switch (argv[1][1])
	    {
	    case 'h': printf("%s\n",USAGE); exit(0);
	      break;
	    case 'd': // remove output of the calendar date
	      mode |= (CALDAT);
	      break;
	    case 'j': // remove output of the calendar date
	      mode |= (JDDAT);
	      break;
	    case 'f': // uses input file
	      argc--; argv++;
	      file_in=fopen(argv[1],"rt");
	      if (file_in==NULL) ioerr("file not found", -1);
	      stdin=file_in;
	      break;
	    default:
	      printf("unknown option -%s\n",&argv[1][1]);
	      return 0;
	    }
	}
      argv++; argc--;
    }
  
  //  file_in=fopen(argv[1],"rt");
  //  if (file_in==NULL) ioerr("file not found", -1);
  
  while (1)
    {
      mag=dayfr=0;
      year=month=day=0;
      flag=band='-';
      if (NULL==fgets(linebuf,NCHAR,stdin)) break;
      if (linebuf[71]=='L') // read extra line
	{
	  if (NULL==fgets(auxlinebuf,NCHAR,stdin)) break;
	}
      if (linebuf[0]=='#') continue;
      strncpy(date, &linebuf[65], 5); date[5]=0;
      sscanf(date,"%f",&mag);
      if (mag<=0) continue;
      strncpy(date, &linebuf[15], 11); date[10]=0; // copy and terminate date string
      sscanf(date,"%d %d %d", &year, &month, &day);
      strncpy(date, &linebuf[25], 7); date[7]=0; // copy and terminate date string
      sscanf(date,"%f",&dayfr);
      slaCldj(year, month, day, &JD, &j);
      JD+=2400000.5; JD+=dayfr;
      
      dayfr+=day;
	if ((mode & CALDAT)==CALDAT)
	printf("%d %2.2d %08.5f ", year, month, dayfr);
      if ((mode & JDDAT)==JDDAT)
	printf("%lf ", JD);
      if (linebuf[14]>64) flag=linebuf[14];
      if (linebuf[70]>64) band=linebuf[70];
      strncpy(obs, &linebuf[77],3); obs[4]=0;
      printf("%5.2f %c %c %3s\n", mag, flag, band, obs);
    }


}
