#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "SLALIB/slalib.h"

#define NCHAR 256
#define CALDAT 2
#define JDDAT  1
#define USAGE "\n\
  This is the rwo2mag (delbo@oca.eu)\n\
  extract magnitudes from Milani's rwo files e.g.\n\
  http://hamilton.dm.unipi.it/~astdys/mpcobs/numbered/0/142.rwo \n\
  -h this help\n\
  +d output calendar date\n\
  -d remove output calendar date\n\
  +j output JD epoch (default) \n\
  -j remove output JD epoch (default) \n"

void ioerr(char* st, int code)
{
  fprintf(stderr,"%s\n",st);
  exit(code);
}

main(int argc, char* argv[])
{
  FILE* file_in=NULL;
  char  linebuf[NCHAR];
  char  auxlinebuf[NCHAR];
  char  date[11];
  char  fileinname[512];
  int   year, month, day, j;
  float dayfr, mag, magerr, magbias;
  double JD, oldjd;
  unsigned int mode=0;
  char  flag, header=1;
  char  band;
  char  obs[4];

  mode=mode+JDDAT+CALDAT;

//	SCANS the arguments
  while (argc>2)
    {
      if (argv[1][0]=='-')
	{
	  switch (argv[1][1])
	    {
	    case 'h': printf("%s\n",USAGE); exit(0);
	      break;
	    case 'd': // remove output of the calendar date
	      mode ^= CALDAT;
	      break;
	    case 'j': // remove output of the calendar date
	      mode ^= JDDAT;
	      break;
	    case 'f': // uses input file
	      argc--; argv++;
	      file_in=fopen(argv[1],"rt");
	      if (file_in==NULL) ioerr("file not found", -1);
	      stdin=file_in;
	      break;
	    default:
	      printf("unknown option -%s\n",&argv[1][1]);
	      return 0;
	    }
	}
      if (argv[1][0]=='+')
	{
	  switch (argv[1][1])
	    {
	    case 'h': printf("%s\n",USAGE); exit(0);
	      break;
	    case 'd': // remove output of the calendar date
	      mode |= (CALDAT);
	      break;
	    case 'j': // remove output of the calendar date
	      mode |= (JDDAT);
	      break;
	    case 'f': // uses input file
	      argc--; argv++;
	      file_in=fopen(argv[1],"rt");
	      if (file_in==NULL) ioerr("file not found", -1);
	      stdin=file_in;
	      break;
	    default:
	      printf("unknown option -%s\n",&argv[1][1]);
	      return 0;
	    }
	}
      argv++; argc--;
    }
  
  //  file_in=fopen(argv[1],"rt");
  //  if (file_in==NULL) ioerr("file not found", -1);
  
  while (1)
    {
      magbias=magerr=mag=dayfr=0;
      year=month=day=0;
      flag=band='-';
      if (NULL==fgets(linebuf,NCHAR,stdin)) break;
      if (strncmp(linebuf, "END_OF_HEADER",13)==0) // detected end of header
	{
	  header=0; // tell the header has ended
	  if (NULL==fgets(linebuf,NCHAR,stdin)) break;// skip 2 lines
	  if (NULL==fgets(linebuf,NCHAR,stdin)) break;
	  printf("end of header\n");
	  continue;
	} 
      if (header) continue;
      if (linebuf[34]=='1') continue; // skip line
      if (linebuf[0]=='#') continue;

      strncpy(date, &linebuf[156], 5); date[5]=0;
      sscanf(date,"%f",&mag);
      strncpy(date, &linebuf[164], 4); date[4]=0;
      sscanf(date,"%f",&magerr);
      strncpy(date, &linebuf[170], 5); date[5]=0;
      sscanf(date,"%f",&magbias);
      if (mag<=0) continue;
      strncpy(date, &linebuf[17], 10); date[10]=0; // copy and terminate date string
      sscanf(date,"%d %d %d", &year, &month, &day);
      strncpy(date, &linebuf[27], 11); date[11]=0; // copy and terminate date string
      sscanf(date,"%f",&dayfr);
      slaCldj(year, month, day, &JD, &j);
      JD+=2400000.5; JD+=dayfr;
      
      dayfr+=day;
	if ((mode & CALDAT)==CALDAT)
	printf("%d %2.2d %08.5f ", year, month, dayfr);
      if ((mode & JDDAT)==JDDAT)
	printf("%lf ", JD);
      if (linebuf[13]>64) flag=linebuf[13];
      if (linebuf[161]>64) band=linebuf[161];
      strncpy(obs, &linebuf[176],3); obs[3]=0;
      printf("%5.2f %4.2f %5.2f %c %c %3s\n", mag, magerr, magbias, flag, band, obs);
    }


}
