
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
//#include "nr.h"

#define	 BUFLEN	256
#define  HELP "&theta,  &baseline, &lambda\n\
	-r w0 w1 wstep"

extern double bessj1(double x);

main(int argc, char *argv[])
{
  double theta, lambda, baseline, vis, arg;
  long	 i;
  char	 buf[BUFLEN] ; 	//buffer used read data
  int	 range=0;
  double w0,w1,ws;
  int	 verbose=0, N=0;
  int    colmode=0;

  while (argc>1)
    {
      if (argv[1][0]=='-')
        {
	  switch (argv[1][1])
	    {
	    case 'l':
	      range=1;
	      argc--; argv++; w0=atof(&argv[1][0]);
	      argc--; argv++; w1=atof(&argv[1][0]);
	      argc--; argv++; ws=atof(&argv[1][0]);
	      break;
	    case 'v':
	      verbose=1;
	      break;
	    case 'r':
	      colmode=1;
	      break;
	    case 'h':
	      printf("%s\n", HELP);
	      return -1;
	      break;
	    default:
	      printf("unknown option -%s\n",argv[1][1]);
	      return 0;
	      break;
	    } //switch
	}
      argc--; argv++;
    }

  if ((verbose) && (range))
    printf("wavelenght range low=%lf up=%lf step=%lf\n", w0,w1,ws);
  
  while (NULL!=fgets(buf, BUFLEN, stdin))
    {
      if ((sscanf(buf, "%lf %lf %lf", &theta,  &baseline, &lambda) < 3))
	break;
      
      if (!(range))
	{
	  arg=3.14*baseline*theta/206.265/lambda;
	  vis=fabs(2.0*bessj1(arg)/(arg));
	  printf("%lf %lf %lf\n",theta, lambda, vis);
	} else
	{
	  if (!colmode) printf("%6.1lf ", theta);
	  N=(int)((w1-w0)/ws)+1;
	  for(i=0; i<N; i++)
	    {
	      w1=w0+ws*i;
	      arg=3.14*baseline*theta/206.265/w1;
	      vis=fabs(2.0*bessj1(arg)/(arg));
	      if (colmode) printf("%6.1lf ", theta);
	      printf("%4.1lf %8.6lf  ", w1, vis);
	      if (colmode) printf("\n");
	    }
	  printf("\n");
	}
    }
}

