
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
//#include "nr.h"

#define	 BUFLEN	256
#define  HELP  "this is vis2d"
#define  NMAX	10000

extern double bessj1(double x);
extern double ran1(long *idum);
extern double gasdev(long *idum);

double mean(double *x, long N)
{
	long	i;
	double	xm=0.0;

	for (i=0; i<N; i++)
		xm+=x[i];

	xm/=(double)N;

	return	xm;
}

double stddev(double *x, double xm, long N)
{
	long	i;
	double	variance=0.0;

	for (i=0; i<N; i++)
		variance+=(x[i]-xm)*(x[i]-xm);

	variance/=(double)(N-1);

	return sqrt(variance);
}

double d2vis(double theta, double baseline, double lambda)
{
	double	arg;

	arg=3.14*baseline*theta/lambda;
	return fabs(2.0*bessj1(arg)/(arg));
}

double csqvis(double *pw, double *pv, double *pve, int N, double baseline, double theta)
{
	int		i;
	double	cs=0.0;
	double	v;

	for (i=0; i<N; i++)
	{
		v=d2vis(theta/206265000.0, baseline, pw[i]);
		cs+=((v-pv[i])*(v-pv[i])/pve[i]/pve[i]);
//		printf("-- %lf %lf %lf %d\n",pw[i]*1.e6, v, pv[i], i);
	}

//    printf("\n");

    return cs;
}

int mcfitvis(double *pw, double *pv, double *pve, int Nv, double baseline, double theta0, double theta1, long NMC)
{
	long	i;
	double	theta;
	long	idum=(long)-time( NULL );
	double	interv=(theta1-theta0);
	double	cs;

    printf("%lf\n",interv);

	for(i=0; i<NMC; i++)
	{
		theta=theta0+ran1(&idum)*interv;
		cs=csqvis(pw, pv, pve, Nv, baseline, theta);
		printf("o> %lf %lf\n",theta, cs);
	}
}

int fitvis(double *pw, double *pv, double *pve, int Nv, 
	   double baseline, double theta0, double theta1, long Npts, 
	   double *thetabest, double *csbest)
{
	double	thetastep=(theta1-theta0)/Npts;
	int	i;
	double	cs[3];
	double	theta[3], bftheta, a, b;

	theta[0]=theta0;
	cs[0]=csqvis(pw, pv, pve, Nv, baseline, theta[0]);
	theta[1]=theta[0]+thetastep;
	cs[1]=csqvis(pw, pv, pve, Nv, baseline, theta[1]);
	theta[2]=theta[1];
	
	while(theta[2]<=theta1)	//loop until theta>thetamax
	{
		theta[2]=theta[1]+thetastep;
		cs[2]=csqvis(pw, pv, pve, Nv, baseline, theta[2]);
//		printf("%lf %lf %lf %lf %lf\n",theta[2], cs[0], cs[1], cs[2], thetastep);
		if ((cs[1]<cs[0]) && (cs[1]<cs[2]))
		{
//			printf("***\n");
			break;
		}
		cs[0]=cs[1]; theta[0]=theta[1];
		cs[1]=cs[2]; theta[1]=theta[2];
	}
	if (theta[2]>=theta1)
	{
	  fprintf(stderr, "fitvis: unable to find a CS min. FitVis did not converged\n");
	  return -1;
	}
	theta[1]-=theta[0]; theta[2]-=theta[0];
	cs[1]-=cs[0]; cs[2]-=cs[0];
	b=(cs[1]*theta[2]*theta[2] - theta[1]*theta[1]*cs[2])/(theta[1]*theta[2]*theta[2] - theta[2]*theta[1]*theta[1]);
	a=(cs[1] - b*theta[1])/theta[1]/theta[1];
	bftheta=-b/2/a + theta[0];
//  printf("o> %lf %lf\n",bftheta, a*(-b/2/a)*(-b/2/a)+ b*(-b/2/a) + cs[0]);
	*thetabest=bftheta;
	*csbest= a*(-b/2/a)*(-b/2/a)+ b*(-b/2/a) + cs[0];
}

int mcvis(double *pw, double *pv, double *pve, int Nv, 
	  double baseline, double theta0, double theta1, long NMC, 
	  double *petheta, int mode)
{
	double	*pvm;
	long	i,j;
	long	idum=(long)-time( NULL );
	double	*ptheta;
	double	cs;
	double	thetam;
	double	etheta;
	
	if ( (ptheta=malloc(NMC*sizeof(double)))==NULL)
	{
		fprintf(stderr, "mcvis: unable to allocate ptheta: return\n");
		return -1;
	}	

	if ( (pvm=malloc(Nv*sizeof(double)))==NULL)
	{
		free(ptheta);
		fprintf(stderr, "mcvis: unable to allocate pvm: return\n");
		return -1;
	}	
	

	for (i=0; i<NMC; i++)
	{
		for (j=0; j<Nv; j++)
		{
			if ((mode & 1)==1) 
				pvm[j]=pv[j]+pve[j]*ran1(&idum);	// uniform deviates
			else
				pvm[j]=pv[j]+pve[j]*gasdev(&idum);	// random deviates
			if (pvm[j]<0.0) pvm[j]=0.0;
			if (pvm[j]>1.0) pvm[j]=1.0;
		}
    		fitvis(pw, pvm, pve, Nv, baseline, theta0, theta1, 100, &ptheta[i], &cs);
//		printf("%lf %lf\n", ptheta[i], cs);
	}

	thetam=mean(ptheta, NMC);		// calc mean diameter
	etheta=stddev(ptheta, thetam, NMC);	// calc standard deviation of the diameter
	*petheta=etheta;
	
	free(pvm);
	free(ptheta);
}

main(int argc, char *argv[])
{
	double	theta0, theta1, lambda, baseline, D, vis, arg;
	long	i;
	char	buf[BUFLEN] ; 	//buffer used read data
	int	verbose=0;
	double	*pv, *pve, *pw;	// visib, sigma_visib, wavelenght BUFFER
	int	Nv=0;		// number of visibility points
	double	cs;
	long	Nmc=100;
	double	theta, etheta;
	int	uniform=0;	// gaussian vs uniform deviates
	int	mcmode=0;

        while (argc>1)
        {
                if (argv[1][0]=='-')
                {
                switch (argv[1][1])
                {
                                case 'm':
					mcmode=1;
                                break;
                                case 'n':
					argc--; argv++;
					Nmc=atol(&argv[1][0]);
                                break;
                                case 'v':
                                        verbose=1;
                                break;
                                case 'h':
                                        printf("%s\n", HELP);
                                        return -1;
                                break;
                                case 'u':
					uniform=1;
                                break;
                                default:
                                        printf("unknown option -%s\n",argv[1][1]);
                                        return 0;
                                break;
                  } //switch
		}
		argc--; argv++;
         }

	if (verbose)
		printf("verbose=%d\n", verbose);

//must enter the baseline length and angular diam fit inteval in mas [theta0,theta1]
	if (verbose)
	  printf("please, enter herebelow baseline length, thetamin, thetamax\n");
	if ((scanf("%lf %lf %lf", &baseline, &theta0, &theta1) < 3))
	{
	  printf("must enter the baseline length and angular diam fit inteval in mas [theta0,theta1]\n");
	  return -1;
	}

	if (verbose)
          printf("baseline_len=%lf; theta0=%lf; theta1=%lf;\n", baseline, theta0, theta1);

	pv=malloc(NMAX*sizeof(double));
	pve=malloc(NMAX*sizeof(double));
	pw=malloc(NMAX*sizeof(double));

	if ((pv==NULL) || (pve==NULL) || (pw==NULL))
	{
		printf("malloc Error\n");
		if (pv) free(pv);
		if (pve) free(pve);
		if (pw) free(pw);
		return -2;
	}

// get data
	if (verbose)
	  {
	    printf("please, enter herebelow wavelength (um) measured visibility and its error\n");
	    printf("enter 'e' to end\n");
	  }
    Nv=0;
	while (scanf("%lf %lf %lf", &pw[Nv], &pv[Nv], &pve[Nv])==3)
	{
	    pw[Nv]/=1.e6;	// converts lambda to meters
	    Nv++;
	}

	if (verbose)
          printf("#of data=%d\n", Nv);

	if (mcmode){
	  mcfitvis(pw, pv, pve, Nv, baseline, theta0, theta1, Nmc);                  
	} else {
    	  fitvis(pw, pv, pve, Nv, baseline, theta0, theta1, 100, &theta, &cs);
	  mcvis(pw, pv, pve, Nv, baseline, theta0, theta1, Nmc, &etheta, uniform);
	}

    printf("o> %lf %lf\n", theta, etheta);
}

