#Converts IRAS files to WISE-like observation files.
#Luca Lionni 25/06/2012

import argparse	
import subprocess


#Definition des arguments et assignation des variables

parser = argparse.ArgumentParser(description ="Converts IRAS files to WISE like observation files.", epilog="N.B. : Needs 'miriveclt' to work.")

parser.add_argument("IRAS", help="iras file (from simpsextract).")
parser.add_argument("num_ast", help="Number of concerned asteroid.")
parser.add_argument("--code_obs", dest="code_obs",  help="Code of observatory.", default=500)

args = parser.parse_args()

iras=args.IRAS
num_ast=args.num_ast
code_obs=args.code_obs

#Lecture des jours, et du nombre de mesure par jour

obj1=open(iras, 'r')
obj1rl=obj1.readlines()
len1=len(obj1rl)
ls_jours=[]
nbr_jours=[]
jour_davant=-1
nbr_en_cours=-1
for i in range(len1) :
	obj1rl[i]=obj1rl[i].split()
	jour_0_i=obj1rl[i][1]
	if jour_0_i<>jour_davant :
		ls_jours.append(jour_0_i)
		nbr_jours.append(1)
		jour_davant=jour_0_i
		nbr_en_cours=nbr_en_cours + 1
	else :
		nbr_jours[nbr_en_cours] += 1


#Fonction permettant de "renverser" les coordonnees

def f(x) : return str(-float(x))

color_corr=[4,5,6,7]

#Boucle calculant les coordonnees via miriveclt, et lisant les flux.

g=0

print nbr_en_cours + 1
for j in range(nbr_en_cours + 1) :
	
	
	jour_j=ls_jours[j]
	nbr_j=nbr_jours[j]
	
	
	print "  " + str(jour_j) + "	" + str(nbr_j)

	(a, b, c, d, e)=(num_ast, jour_j, 1, 1, code_obs)
	command_string = "miriveclt {0} {1} {2} {3} {4}".format(a,b,c,d,e)
	pipe = subprocess.Popen(command_string, shell=True, 
	stdout=subprocess.PIPE).stdout	
	
	mir0=pipe.readline()
	mir=mir0.split()
	mir2=mir[1 : 7]
	mir3=map(f, mir2)
	print str(mir3[0]) + " " + str(mir3[1]) + " " + str(mir3[2]) 
	print str(mir3[3]) + " " + str(mir3[4]) + " " + str(mir3[5])
	
	for k in range(nbr_j) :
		print " " + str(obj1rl[g+k][2]) + " " + str(obj1rl[g+k][3]) + " " + str(obj1rl[g+k][4]) + " "+ str(color_corr[k])
 	
	print ""
	print ""
	g=g+nbr_j
	
