# ! Needs internet connection and mirivec.
#Luca Lionni 20/06/2012

import argparse	
import subprocess
import numpy as np
import math

	#Definition des arguments et assignation des variables

parser = argparse.ArgumentParser(description = 'Builds the ephemerides for a given asteroid with a (mutable) step. This ephemerides cover 30 tours before each epoch and at least 1 day after.', 
epilog = 'N.B. : This program needs internet connection and mirivec to work.')

parser.add_argument("num_ast", help="num_ast stands for the number of the asteroid.")
parser.add_argument("SPIN", help="Spin DAMIT file.")
parser.add_argument("OBS", help="Observation file (.txt file). (!! Be sure that the only lines of this files that have exactly two elements are does with the Jlian date in first position)")
parser.add_argument("-s", "--step", dest='step', help="step : time between two separate Julian days. Default = 1.0", type=float, default=1.0 )
parser.add_argument("--code_obs", dest='codeobs', help="code of observatory. Default = 500", type=int, default=500 )
parser.add_argument("--dist_add", dest='distadd', help="Numbers of days you can add to the 30 tours before each bloc/epoch."
'If the distance between two observation dates is less than dist_add + 30 tours, the program will fill the gap with days, if not it will buil a new bloc, default = 5.0', type=float, default=5.0 )
args = parser.parse_args()

num_ast=args.num_ast
SPIN=args.SPIN
OBS=args.OBS
pas=args.step
code_obs=args.codeobs
dist_add=args.distadd


	#Lecture du fichier d'observations, et des jours de mesures. 
	

obs=open(OBS, 'r')
obs2=obs.readlines()
obs.close()
n_obs=len(obs2)
JOURS=[]
for i in range(n_obs) :
	elt_i=obs2[i].split()
	if len(elt_i)==2 :
		JOURS=JOURS + [float(elt_i[0])]
n_jours=len(JOURS)


#pass "Number of days for wich we have mesures :" + str(n_jours)



	#importation du fichier spin a partir du dossier spin. ATTENTION : pour que le programme fonctionne, il est necessaire de verifier que les fichiers de spin sont au bon emplacement, et sont bien nommes.

dir = "spin_" + str(num_ast) + ".txt"
objet=open(SPIN, 'r')

	
	#Extraction de la periode de l'asteroide.
	
spin=objet.readlines()
objet.close()
vec=spin[0].split()
Tast=float(vec[2])

#print "period of this asteroid="+str(Tast) + " h"

	#Calcul du nombres de jours devant preceder chaque bloc de jours. Un bloc contient tous les jours qui sont "assez proches" (voir condition au paragraphe d'apres).
	
Navant0=Tast *30 / 24 + 1.0
#print "Navant0=" + str(Navant0)
Navant=int(Navant0 /pas) + 1
#print "Nombre de jours avant chaque bloc d'ephemeride="+ str(Navant)

	#Determintation des blocs de jours.On choisit ici que les jours d'un blocs sont distants de moins que Navant+5 jours. On peut modifier le chiffre 5 en argument optionnel --dist_add

nbrjours= len(JOURS)
N=Navant+dist_add
LISTE=[]


def boucle(lst_blocs, bloc, vect_des_jours) :

	#Separons la liste de jours en liste d'epoques/blocs.
	
	longueur=len(vect_des_jours)
	if longueur>1   :
		jour_j=vect_des_jours[0]
		jour_jplusun=vect_des_jours[1]
		vect_des_jours_suivant=vect_des_jours[1:nbrjours]
		if abs(jour_jplusun - jour_j)<=N : 
			boucle(lst_blocs, bloc+[jour_jplusun], vect_des_jours_suivant)
		else : 
			boucle(lst_blocs+[bloc], [jour_jplusun], vect_des_jours_suivant)
	else :  
		L=lst_blocs + [bloc]
		
		nbr_blocs=len(L)
		
		#Parcourons les blocs :
		
		for i in range(nbr_blocs) :
		
			#print "bloc number "+str(i + 1)
		
			bloc_i=L[i]
			
		#Calcul du jour ou commencent les tables pour le bloc i
		
			jour1_bloc_i=bloc_i[0]
			
			JDavant_i=math.floor(jour1_bloc_i) + 0.5 - Navant*pas
			
		#Calcul du nombre de pas a effectuer pour couvrir (et depasser) la longueur de chaque bloc
		 	
			longueur_bloc_i=len(bloc_i)
			
			nbr_jours_i=bloc_i[longueur_bloc_i - 1] - jour1_bloc_i
			
			Napres_i = int (nbr_jours_i/pas) + 2
			
			N_i = Navant + Napres_i
			
		#Appliquons mirivec pour le bloc i :
		
			(a, b, c, d, e)=(num_ast, JDavant_i, N_i, pas, code_obs)
			command_string = "mirivec {0} {1} {2} {3} {4}".format(a,b,c,d,e)
			pipe = subprocess.Popen(command_string, shell=True, 
			stdout=subprocess.PIPE).stdout	
		
		#affichage du resultat sur la console.
	
			result = pipe.readlines()
			n_miri=len(result)
			def f(x) : return str(-float(x))
			for l in range (n_miri-1) :
				ligne_l=result[l].split()
				ligne_l_corr=ligne_l[0:4]
				ligne_l_corr[1:4]=map(f, ligne_l_corr[1:4])
				ligne_l_str='       '.join(ligne_l_corr)
				print ligne_l_str
			ligne=result[n_miri - 1].split()
			ligne_corr=ligne[0:4]
			ligne_corr[1:4]=map(f, ligne_corr[1:4])
			ligne_str='       '.join(ligne_corr) + '       ' + str(1)
			print ligne_str
		
# Appel a la fonction boucle


boucle([], [JOURS[0]], JOURS)










