#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "../tms/tm.h"
#include "../tms/constants.h"
#include "../tms/macros.h"
#include "filter.h"

int LoadFilter(FILTER *filter, char *filename, int mode)
{
  FILE *file_in;
  int   linen=0, i;
  char linebuf[512];
  double w, r;

  filter->responseint=0;

  if ((file_in = fopen(filename, "r"))== NULL ) 
    return -1;
  
  // count validlines
  while (1)
    {
      if (NULL==fgets(linebuf,256,file_in)) break;
      if (linebuf[0]=='#') continue;
      linen++;
    }
  fclose(file_in);
  filter->nlambda=linen;
 
  filter->lambda=(double*)malloc(sizeof(double)*filter->nlambda);//alloc memory
  if (filter->lambda == NULL)
    {
      return -2;
    }

  filter->dlambda=(double*)malloc(sizeof(double)*filter->nlambda);//alloc memory
  if (filter->dlambda == NULL)
    {
      return -3;
    }

  filter->response=(double*)malloc(sizeof(double)*filter->nlambda);//alloc memory
  if (filter->response == NULL)
    {
      return -4;
    }

  // ----------- load the filter profile

   if ((file_in = fopen(filename, "r"))== NULL ) 
    return -1;
 
   linen=0;
   while (1)
     {
       if (NULL==fgets(linebuf,256,file_in)) break;
       if (linebuf[0]=='#') continue;
       sscanf(linebuf, "%lf %lf",&filter->lambda[linen], &filter->response[linen]);
       linen++;  
     }
   
   memset(filter->dlambda, 0, filter->nlambda*sizeof(double));
   for(i=0; i<(filter->nlambda-1); i++)//compute dlambda
     filter->dlambda[i]=filter->lambda[i+1]-filter->lambda[i];
   filter->dlambda[i]=filter->dlambda[i-1];
  
  for(i=0; i<filter->nlambda; i++)//compute dlambda
    filter->responseint+=(filter->lambda[i]*filter->response[i]*filter->dlambda[i]);

  if (mode & TM_MODE_VERBOSE)
    {
      printf("filter %s loaded ok with %d points and response=%lf \n", 
	     filename, filter->nlambda, filter->responseint);
    }

   return 0;
}

double ComputeMag(double *flux, // SED the flux at filter.lambda (REQUIRED) in W/m-2/um !!!
		  FILTER *filter, double zeropoint, double *colorcorrection)
{
  double aveflux=0;
  int i;
  
  for(i=0; i<filter->nlambda; i++)//compute dlambda
    aveflux+=(flux[i]*filter->lambda[i]*filter->response[i]*filter->dlambda[i]);
  
  aveflux/=filter->responseint; // eq 5 of Tokunaga and Vacca 2005

  return -2.5*log10(aveflux/1e4) - zeropoint;
}

double ComputeIsoFlux(double *flux, // SED the flux at filter.lambda (REQUIRED) in W/m-2/um !!!
		  FILTER *filter, double zeropoint, double *colorcorrection)
{
  double aveflux=0;
  int i;
  
  for(i=0; i<filter->nlambda; i++)//compute dlambda
    aveflux+=(flux[i]*filter->lambda[i]*filter->response[i]*filter->dlambda[i]);
  
  aveflux/=filter->responseint; // eq 5 of Tokunaga and Vacca 2005

  return aveflux; // W/m2/um
}
