
// in the case of WISE the response is e-/photons
typedef struct tagFILTER // response curve of the filter
{
  double *lambda; // 
  double *response;   // 
  double *dlambda;    // lambda step
  double efflambda; //
  double responseint; // integral of R(\lambda) \lambda * dlambda
  int    nlambda; // number of points
} FILTER;

int LoadFilter(FILTER *filter, char *filename, int mode);
double ComputeMag(double *flux, // SED the flux at filter.lambda (REQUIRED) in W/m-2/um !!!
		  FILTER *filter, double zeropoint, double *colorcorrection);
// this fuunction returns the isophotal flux = integral(flux response lambda dlambda)  / integral(response lambda dlambda)
double ComputeIsoFlux(double *flux, // SED the flux at filter.lambda (REQUIRED) in W/m-2/um !!!
		  FILTER *filter, double zeropoint, double *colorcorrection);
