#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "../tms/tm.h"
#include "../tms/constants.h"
#include "../tms/macros.h"
#include "filter.h"

#define	 NEATM		0
#define	 NEATMFIX	1
#define	 STM		2
#define	 FRM		3
#define	 NITER		250



#define USAGE "TMflux D, pV, eta, r, Delta, alpha\n"
#define ADARGS "-l <lambda0> <lambda1> <lambdastep> to change the default wavelenght range\n\
 -m mode 0=NEATM 2=STM 3=FRM\n\
 -e <emissivity value>\n\
 -g <G_value>\n\
 -o <output_filename>\n\
 -r column mode\n\
 -b <beta_e> \n\
 -v verbose mode\n\
 -V <VtoBandsRatio>\n"

#define PROG     "FitTM"
#define AUTHOR   "Marco Delbo"
#define VERSION  "beta 1.0"
#define REL_DATE "January 10, 2008"

main(int argc, char* argv[])
{
  
  double	beta=0.01;
  double	D=1, pV=0.2, G=0.15, epsilon=0.9, eta=1.0, 
                A=Pv2A(pV, G), H=DIAM2H(D, pV);
  double        r=1, Delta=1, alpha=0;
  int		multi=0;
  int		physpar=0;
  int		model=NEATM;
  double	*pw=NULL, *pf=NULL;
  double	Tss;
  int		Nw;
  int		i;
  int		mode=0;
  char*	        filename=NULL;
  int           colmode=0;
  double        vtobandratio=-1;

  while (argc>1)
    {
      if (argv[1][0]=='-')
	{
	  switch (argv[1][1])
	    {
	    case 'e':
	      argc--; argv++; epsilon=atof(argv[1]);
	      break;
	    case 'G':
	      argc--; argv++; G=atof(argv[1]);
	      break;
	    case 'h':
	      printf("%s\n",USAGE);
	      printf("%s\n",ADARGS);
	      return 0;
	      break;
	    case 'm':
	      model=atoi(argv[1]); argc--; argv++;
	      break;
	    case 'o': 	// get the output filename
	      argc--; argv++; filename=argv[1];
	      break;
	    case 'v':
	      mode+=TM_MODE_VERBOSE;
	      break;
	    case 'V':
	      argc--; argv++; 
	      vtobandratio=atof(argv[1]);
	      break;
	    default:
	      printf("unknown option -%c\n",argv[1][1]);
	      return 0;
	      break;
	    }
	} 
		/*
		else
		{

			if ((argc > 6) && (physpar==0))
			{
			  if (verbose)
			  printf("importing physical parameters\n");
				model=atoi(argv[1]); argc--; argv++;
				D=atof(argv[1]); argc--; argv++;
				pV=atof(argv[1]); argc--; argv++;
				G=atof(argv[1]); argc--; argv++;
				epsilon=atof(argv[1]); argc--; argv++;
				eta=atof(argv[1]); argc--; argv++;
				A=Pv2A(pV, G);
				physpar+=5;
			}

			if(verbose)	printf("argc=%d\n",argc);

			if ((argc > 3) && (multi==0))
			{
				r=atof(argv[1]); argc--; argv++;
				Delta=atof(argv[1]); argc--; argv++;
				alpha=atof(argv[1]); argc--; argv++;
			}
		}
		*/
      argc--;
      argv++;
    }

   FILTER filter[4];
  double averageflux[4], 
    zeropoint[4]={35.218, 36.543, 40.465, 43.233}; // TBD : apply the mag offsets for VEGA! 
  double colorcorrection[4],
    mag[4];
  char   filtname[4][20]={"w1.interpolated.txt","w2.interpolated.txt","w3.interpolated.txt","w4.interpolated.txt"};
  int ifilt;
  double flux[5000];  
  
  H=DIAM2H(D, pV); printf("Computed H value is %lf and G is %lf\n",H,G);
  for(ifilt=0; ifilt<4; ifilt++)
    LoadFilter(&filter[ifilt], filtname[ifilt],mode); 
  

  // DEBUG print a filter
  //  for (i=0; i<w[1].nlambda; i++) printf("%lf %lf %lf\n",w[1].lambda[i],w[1].response[i],w[1].dlambda[i]);


  while ( (scanf("%lf %lf %lf %lf %lf %lf", &D, &pV, &eta, &r, &Delta, &alpha)==6))
    {
      A=Pv2A(pV, G);
      H=DIAM2H(D, pV);
      Tss=TSS(A,eta,r,epsilon);
      for(ifilt=0; ifilt<4; ifilt++)
	{
	  memset(&flux,0,5000*sizeof(double));
	  NEATMflux_W(filter[ifilt].lambda, flux, filter[ifilt].nlambda, Tss, epsilon, D/2, Delta, alpha, NITER);

	  // TBD: vto 3.6 um ratio is used here and not 3.35 that should be used for WISE
	  if (vtobandratio>0) // it adds the relfected comp.
	    AddReflComp_W(filter[ifilt].lambda, flux, filter[ifilt].nlambda, H, G, r, Delta, alpha, vtobandratio);

	  //	  for (i=0; i<filter[ifilt].nlambda; i++) printf("%lf %lf %e\n",filter[ifilt].lambda[i],filter[ifilt].response[i],flux[i]);
	  mag[ifilt]=ComputeMag(flux,&filter[ifilt],zeropoint[ifilt],&colorcorrection[ifilt]);
	  printf("%lf\n", mag[ifilt]);
	}
    }

}
