# Read IRSA/IPAC-WISE tables and plot (with an arbitrary
# offset!!) mag vs mjd for each object in the four 
# bands W1, W2, W3, W4 (lightcurve)
#
# We use miridista (M. Delbo) to retrieve r, Delta and alpha
# We use hdes (M. Delbo) to retrieve Hmag
#
# - Victor M. Ali-Lagoa, IAC, 2011-07-08
#

import matplotlib.pyplot as plt
import sys
import subprocess
import datetime
import math
import numpy as np
from StringIO import StringIO

######################################################################
# CONSTANTS
# filter_wl   = 3.3526,  4.6028,  11.5608, 22.0883
# Wavelength adjustments:
filter_wl   = 3.3526,  4.6028,  11.0984, 22.6405
flux_iso_Jy = 306.681, 170.663, 29.0448, 8.2839
# TDB: introduce isophotal fluxes in W/cm2/um
flux_iso_W  = 8.18e-15, 2.415e-15, 6.515e-17, 5.090e-18
# Magnitude zeropoint offsets (Mainzer et al. 2011) 
offs        = 1.0000, 1.0000, 0.9200, 1.04000 

#wise_flux = np.zeros(4)
lines_2_write = ['0','0','0','0']
ln10 = math.log(10.0)

col_2use = (3,4,5,6,7,8,9,10,12,13,16,17,20,21,24,25,31,33)
col_index = dict([("desig",0),("mjd_u",1),("ra_u",2),("dec_u",3),("ra",4),("dec",5),("sigra",6),("sigdec",7),("w1mpro",8),("w1sigmpro",9),("w2mpro",10),("w2sigmpro",11),("w3mpro",12),("w3sigmpro",13),("w4mpro",14),("w4sigmpro",15),("ph_qual",16),("mjd",17)])


######################################################################
# s2i = string to float
s2f = lambda x: (float(x))  
# s2i = string to integer
s2i = lambda x: int((float(x)))  

mags = np.zeros(4)
emags = np.zeros(4)

######################################################################
# FUNCTIONS

def get_n_header():
    # grep the file to know how many lines we need to consider as "header"
    cmd = """grep '\\\\' {0} | wc -l""".format(ipac_file)
    pipe = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE).stdout
    n = int(pipe.read().split()[0])
    return n

def error_log():
    print "\n{0} header lines have been skipped".format(n_header)
    print "{0} lines read".format(num_rows)
    print """{0} errors in w1sigmpro;
{1} errors in w2sigmpro;
{2} errors in w3sigmpro;
{3} errors in w4sigmpro;\n""".format(cont_m1s,cont_m2s,cont_m3s,cont_m4s)       
    print """{0} errors in w1mpro;
{1} errors in w2mpro;
{2} errors in w3mpro;
{3} errors in w4mpro;\n""".format(cont_m1,cont_m2,cont_m3,cont_m4)
    print "{0} + {1} + 4 = {2} total number of lines".format(n_header,num_rows,n_header+num_rows+4)
    for i in xrange(num_rows):
        if err_flag[i]:
#            print """line {0}, desig = {1}, ph_qual = {2}
#""".format(i,desig[i],ph_qual[i])
            pass
        if not(err_flag[i]):
#            print "{0} {1} {2}".format(i,desig[i],ph_qual[i])
            pass
# uncomment prints to see lines with no errors (X's or U's)

def get_separating_indexes():
    dsg_old = -1
    count_obj = 0
    for dsg in desig:
        if dsg != dsg_old:
            count_obj = count_obj + 1
        dsg_old = dsg

    desig_limits = np.zeros(count_obj, dtype = np.int)
    dsg_old = -1
    count_obj = 0
    for dsg in desig:
        if dsg != dsg_old:
            desig_limits[count_obj] = desig.index(dsg)
            count_obj = count_obj + 1
        dsg_old = dsg
        
    return desig_limits


def get_plots(X):
    offst = 1.0
    c_Xorplus=0
    for i in desig_lim:
        # array with the indexes corresponding to a particular 
        # designation: iad
        iad = [ind for ind in xrange(num_rows) if desig[ind] == desig[i]]
        iad_mask = err_flag[iad] == False
        # only take those rows without errors: X or U
        x = mjd[iad][iad_mask] % 55000.0
        try:
            if len(x) <= X:
                y1 = w1mpro[iad][iad_mask]
                y2 = w2mpro[iad][iad_mask]
                y3 = w3mpro[iad][iad_mask]
                y4 = w4mpro[iad][iad_mask]            
                ys1 = y1 - y1.mean()
                ys2 = y2 - y2.mean() + 1.0*offst 
                ys3 = y3 - y3.mean() + 2.0*offst 
                ys4 = y4 - y4.mean() + 3.0*offst 
                er1 = w1sigmpro[iad][iad_mask]
                er2 = w2sigmpro[iad][iad_mask]
                er3 = w3sigmpro[iad][iad_mask]
                er4 = w4sigmpro[iad][iad_mask]
                
                plt.errorbar(x,ys1,yerr=er1,fmt='ro',marker='.',color='r',ecolor='r') #,label='W1,scal'
                plt.errorbar(x,ys2,yerr=er2,fmt='ro',marker='.',color='b',ecolor='b')
                plt.errorbar(x,ys3,yerr=er3,fmt='ro',marker='.',color='g',ecolor='g')
                plt.errorbar(x,ys4,yerr=er4,fmt='ro',marker='.',color='y',ecolor='y')
            # plt.legend(loc = 'best')
                plt.axhline(y = 0, color='r',linestyle='--')
                plt.axhline(y =     offst, color='b',linestyle='--')
                plt.axhline(y = 2.0*offst, color='g',linestyle='--')
                plt.axhline(y = 3.0*offst, color='y',linestyle='--')
                
                plot_label = 'Magnitude'.format(desig[i])
                plt.ylabel(plot_label)
                plt.xlabel('MJD % 55000')
                plot_title = 'Asteroid {0}'.format(desig[i])
                fname = './mag_vs_mjd_{0}.ps'.format(desig[i])
                plt.title(plot_title)
                
            #             print "{0} {1}".format(desig[i], ph_qual[i] )
                plt.savefig(fname)
                plt.show()
                plt.close()
# watch out!
                
                c_Xorplus += 1
        except ValueError:
                pass
    return c_Xorplus

def conv(s):
    # inherited from con(s) by M. Kelley.
    ss = s.split()
    return "{0} {1} {2}".format(ss[1][:], ss[2][:], ss[3][:])

def get_geometry(ast_i,mjd_i):
    # Use miridista (M. Delbo) to retrieve r, Delta and alpha
    # Use hdes (M. Delbo) to retrieve Hmag
    # need to prepare ast_i to be:
    # i) number
    # ii) unnumb. designation with underscore
    jd_i = mjd_i + 2400000.5
    cmd = "miridista {0} {1} 1 1 500".format(ast_i, jd_i)
    pipe = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE).stdout
    try:
        g_dat1="\n".join(map(conv, pipe.readlines()[::2]))
    except IndexError:
        "Something went wrong with miridista\n"
        pass
    pipe.close()
    # pad with zeros before grepping hdes
    pad_ast_i = "{0:05d}".format(int(ast_i))
    cmd = "grep {0} hdes".format(pad_ast_i)
    pipe = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE).stdout
    try:
         g_dat2="\n".join(map(conv, pipe.readlines()[::2]))
    except IndexError:
        "Something went wrong with hdes\n"
        pass
    pipe.close()
    try:
        helioc  = "{0:04f}".format(float(g_dat1.split()[0]))
        deltss  = "{0:04f}".format(float(g_dat1.split()[1]))
        p_angle = "{0:04f}".format(float(g_dat1.split()[2]))
        geom_data = pad_ast_i+' '+g_dat2.split()[0][0:]+' '+helioc+' '+deltss+' '+p_angle
    except IndexError:
        geom_data = "nan nan nan nan nan"
        pass
    return geom_data
    
def get_averages_and_files_(EX):
    for i in desig_lim:  
    # array with the indexes corresponding to a particular 
    # designation: iad
        iad = [ind for ind in xrange(num_rows) if desig[ind] == desig[i]] 
        iad_mask = err_flag[iad] == False
    # only take those rows without errors
        x = mjd[iad][iad_mask]
       
        if len(x) <= EX:
       # print "desig = {0}\n{1} \n{2} \n\n".format(desig[i],err_flag[iad],err_flag[iad][iad_mask])
            y1 = w1mpro[iad][iad_mask]
            y2 = w2mpro[iad][iad_mask]
            y3 = w3mpro[iad][iad_mask]
            y4 = w4mpro[iad][iad_mask]
            er1 = w1sigmpro[iad][iad_mask]
            er2 = w2sigmpro[iad][iad_mask]
            er3 = w3sigmpro[iad][iad_mask]
            er4 = w4sigmpro[iad][iad_mask]
            mags[0] = y1.mean()
            emags[0] = er1.mean()
            mags[1] = y2.mean()
            emags[1] = er2.mean()
            mags[2] = y3.mean()
            emags[2] = er3.mean()
            mags[3] = y4.mean()
            emags[3] = er4.mean()
            nam_in = 'a'+str(desig[i])+'offset.in'
            
        # Take average of observation epoch!
            mjd_aver = x.mean()
            geom = get_geometry(desig[i],mjd_aver)
        #first_line_in = str(desig[i])+' '+geom
            try:
                pippo = float(geom[0])
                archivo_in = open(nam_in, 'w')
#        archivo_in.writelines(first_line_in)
                archivo_in.writelines(geom)
                for li in xrange(len(lines_2_write)):
            # instrumental magnitude zeropoint offsets to W3 and W4
      #      wise_flux = flux_iso_Jy[li]*math.pow(10,-mags[li]*0.400*offs[li])
      #      wise_ferr = wise_flux*ln10*emags[li]
      #      lines_2_write[li] = "{0} {1} {2}\n".format(filter_wl[li],wise_flux,wise_ferr)
                    lines_2_write[li] = " {0} {1} {2}".format(li+1,mags[li],emags[li])
                    archivo_in.writelines(lines_2_write)
                    ret_car = "\n"
                    archivo_in.writelines(ret_car)
                    archivo_in.close()
            except :
                pass


def get_fluxes_and_files_(EX):
    for i in desig_lim:  
    # array with the indexes corresponding to a particular 
    # designation: iad
        iad = [ind for ind in xrange(num_rows) if desig[ind] == desig[i]] 
        iad_mask = err_flag[iad] == False
    # only take those rows without errors
        x = mjd[iad][iad_mask]
       
        if len(x) <= EX:
       # print "desig = {0}\n{1} \n{2} \n\n".format(desig[i],err_flag[iad],err_flag[iad][iad_mask])
            y1 = w1mpro[iad][iad_mask]
            y2 = w2mpro[iad][iad_mask]
            y3 = w3mpro[iad][iad_mask]
            y4 = w4mpro[iad][iad_mask]
            er1 = w1sigmpro[iad][iad_mask]
            er2 = w2sigmpro[iad][iad_mask]
            er3 = w3sigmpro[iad][iad_mask]
            er4 = w4sigmpro[iad][iad_mask]
            mags[0] = y1.mean()
            emags[0] = er1.mean()
            mags[1] = y2.mean()
            emags[1] = er2.mean()
            mags[2] = y3.mean()
            emags[2] = er3.mean()
            mags[3] = y4.mean()
            emags[3] = er4.mean()
            nam_in = 'a'+str(desig[i])+'offset.in'
            
        # Take average of observation epoch!
            mjd_aver = x.mean()
            geom = get_geometry(desig[i],mjd_aver)
        #first_line_in = str(desig[i])+' '+geom
            try:
                pippo = float(geom[0])
                archivo_in = open(nam_in, 'w')
#        archivo_in.writelines(first_line_in)
                archivo_in.writelines(geom)
                for li in xrange(len(lines_2_write)):
            # instrumental magnitude zeropoint offsets to W3 and W4
      #      wise_flux = flux_iso_Jy[li]*math.pow(10,-mags[li]*0.400*offs[li])
      #      wise_ferr = wise_flux*ln10*emags[li]
      #      lines_2_write[li] = "{0} {1} {2}\n".format(filter_wl[li],wise_flux,wise_ferr)
                    lines_2_write[li] = " {0} {1} {2}".format(li+1,mags[li],emags[li])
                    archivo_in.writelines(lines_2_write)
                    ret_car = "\n"
                    archivo_in.writelines(ret_car)
                    archivo_in.close()
            except :
                pass

######################################################################
# START THE PROGRAM
if len(sys.argv) < 2:
    print """
Read IRSA/IPAC tables and plot mag vs mjd for each filter,
for each observation of each object. Also, create a file
with three columns: filter number, mag and sigmamag

Usage:

  i) {0} ipac_table.tbl [output file] 

The name of the output file will be 'ipac2mags.out'
if not specified in the command line.  

We still have to sort out the way to work with epochs of 
observation separated more than three days, since in this 
case averaging magnitudes is no good! There is a non-definitive
solution: setting X = 10 or 15 will exclude objects with more
than X observations, which usually have different sets of 
observations. But we need to improve on this!
""".format(sys.argv[0])
    sys.exit(1)

    
ipac_file = sys.argv[1]
if len(sys.argv) > 2:
    print_error_log = True
    object_name = sys.argv[2]
else:
    print_error_log = False
    object_name = 'ipac2mags.out'
    
n_header = get_n_header()

try:
    open_ipac_file = open(ipac_file, 'r')
except IOError, e:
    print "Didn't find file '{0}'\n".format(ipac_file)
    sys.exit(1)
finally:
    pass

mega_struct = np.genfromtxt(open_ipac_file, skip_header = n_header, dtype = None, usecols = col_2use, comments = "|")

num_rows = len(mega_struct)

# We need to know how many rows the input table has 
# before we allocate memory. Maybe it would be worthwhile
# to improve on this in the future. TBD
mjd_u = np.zeros(num_rows)
mjd   = np.zeros(num_rows)
ra_u  = np.zeros(num_rows)
dec_u = np.zeros(num_rows)
ra    = np.zeros(num_rows)
dec   = np.zeros(num_rows)
w1mpro = np.zeros(num_rows)
w2mpro = np.zeros(num_rows)
w3mpro = np.zeros(num_rows)
w4mpro = np.zeros(num_rows)
w1sigmpro = np.zeros(num_rows)
w2sigmpro = np.zeros(num_rows)
w3sigmpro = np.zeros(num_rows)
w4sigmpro = np.zeros(num_rows)
p_q = ' let '*num_rows  
ph_qual = p_q.split()
desig = p_q.split()
err_flag  = mjd < 0
err_flag1 = mjd < 0
err_flag2 = mjd < 0
err_flag3 = mjd < 0
err_flag4 = mjd < 0

cont = 0
cont_m1 = 0
cont_m2 = 0
cont_m3 = 0
cont_m4 = 0
cont_m1s = 0
cont_m2s = 0
cont_m3s = 0
cont_m4s = 0

# We need to keep track of the indexes for which there are 
# errors in the table: X or U in the quality flag
for ind in xrange(num_rows):
    try:
        ph_qual[ind] = mega_struct[ind][col_index["ph_qual"]]
        desig[ind]   = mega_struct[ind][col_index["desig"]]
        mjd[ind]     = mega_struct[ind][col_index["mjd"]]
        mjd_u[ind]   = mega_struct[ind][col_index["mjd_u"]]
        ra[ind]      = mega_struct[ind][col_index["ra"]]
        ra_u[ind]    = mega_struct[ind][col_index["ra_u"]]
        dec[ind]     = mega_struct[ind][col_index["dec"]]
        dec_u[ind]   = mega_struct[ind][col_index["dec_u"]]
    except ValueError, e:
        print "Row {0}: {1} ".format(ind, e)
        print "Something is wrong with desig, mjd, ra, dec or ph_qual in this line"
        err_flag[ind] = True
        cont = cont + 1

    try:
        w1sigmpro[ind]  = mega_struct[ind][col_index["w1sigmpro"]]
    except ValueError, e:
        w1sigmpro[ind]  = -100.
        cont_m1s = cont_m1s + 1
        err_flag1[ind] = True
                                                     
    try:
        w2sigmpro[ind]  = mega_struct[ind][col_index["w2sigmpro"]]
    except ValueError, e:
        w2sigmpro[ind]  = -100.
        cont_m2s = cont_m2s + 1    
        err_flag2[ind] = True

    try:
        w3sigmpro[ind]  = mega_struct[ind][col_index["w3sigmpro"]]
    except ValueError, e:
        w3sigmpro[ind]  = -100.
        cont_m3s = cont_m3s + 1
        err_flag3[ind] = True

    try:
        w4sigmpro[ind]  = mega_struct[ind][col_index["w4sigmpro"]]
    except ValueError, e:
        w4sigmpro[ind]  = -100.
        cont_m4s = cont_m4s + 1
        err_flag4[ind] = True

    try:
        w1mpro[ind]  = mega_struct[ind][col_index["w1mpro"]]
    except ValueError, e:
        w1mpro[ind] = -100
        cont_m1 = cont_m1 + 1
        err_flag1[ind] = True
        
    try:
        w2mpro[ind]  = mega_struct[ind][col_index["w2mpro"]]
    except ValueError, e: 
        w2mpro[ind] = -100
        cont_m2 = cont_m2 + 1
        err_flag2[ind] = True    
        
    try:
        w3mpro[ind]  = mega_struct[ind][col_index["w3mpro"]]
    except ValueError, e:
        w3mpro[ind] = -100
        cont_m3 = cont_m3 + 1
        err_flag3[ind] = True
        
    try:
        w4mpro[ind]  = mega_struct[ind][col_index["w4mpro"]]
    except ValueError, e:
        w4mpro[ind] = -100
        cont_m4 = cont_m4 + 1
        err_flag4[ind] = True


if print_error_log:
    error_log()

desig_lim = get_separating_indexes()
num_objs = len(desig_lim)

# Dummy number you can use to avoid multiepoc
# observations of a single object until we 
# incorporate it into the automation procedure
# TDB 
X = 100

# uncomment get_plots!!

#num_Xorplus = get_plots(X)
#print """{0} out of {1} have 'number < {2}' of valid observations ({3} %)
#Ignore this line if you don't have "multi-epoch" observations separated by
#more than three days: otherwise, the averaging of the magnitudes is no good!
#Still working on that! Always check the lightcurves! 
#""".format(num_Xorplus,num_objs,X,num_Xorplus/float(num_objs)*100)

#get_averages_and_files(X)

for i in desig_lim:  
    # array with the indexes corresponding to a particular asteroid
    # designation: iad
    iad = [ind for ind in xrange(num_rows) if desig[ind] == desig[i]] 
    # and corresponding mjdates and magnitudes and sigmas
    iad_mask1 = err_flag1[iad] == False
    iad_mask2 = err_flag2[iad] == False
    iad_mask3 = err_flag3[iad] == False
    iad_mask4 = err_flag4[iad] == False
   
    # minimum requirement mask: if there is at least acceptable W3 or W4 
    mrmask = [ind2 for ind2 in xrange(len(iad)) if iad_mask3[ind2] == True or iad_mask4[ind2] == True] 

    if len(mrmask) > 0:
        # If the mrcondition is met, then we prepare the .in file.
        # Open file first:
        nam_in = 'a'+str(desig[i])+'offset.in'
        archivo_in = open(nam_in, 'w')
        for j in xrange(len(mrmask)):
            condit1 = False 
            condit2 = False
            condit3 = False
            condit4 = False
            mjd_j = mjd[iad][mrmask][j]
            geom = get_geometry(desig[i],mjd_j)
            m1  = w1mpro[iad][mrmask][j]
            em1 = w1sigmpro[iad][mrmask][j]
            m2  = w2mpro[iad][mrmask][j]
            em2 = w2sigmpro[iad][mrmask][j]
            m3  = w3mpro[iad][mrmask][j]
            em3 = w3sigmpro[iad][mrmask][j]
            m4  = w4mpro[iad][mrmask][j]
            em4 = w4sigmpro[iad][mrmask][j]
            if m1 > -99.0 and em1 > -99.0:          
                temp_f   = flux_iso_W[0]*math.pow(10,-m1*0.400*offs[0])
                W_flux_1 = temp_f
                W_erfl_1 = temp_f*ln10*0.400*em1
                condit1 = True

            if m2 > -99.0 and em2 > -99.0:          
                temp_f   = flux_iso_W[1]*math.pow(10,-m2*0.400*offs[1])
                W_flux_2 = temp_f
                W_erfl_2 = temp_f*ln10*0.400*em2
                condit2 = True

            if m3 > -10.0 and em3 > -99.0:          
                temp_f   = flux_iso_W[2]*math.pow(10,-m3*0.400*offs[2])
                W_flux_3 = temp_f
                W_erfl_3 = temp_f*ln10*0.400*em3
                condit3 = True

            if m4 > -99.0 and em4 > -99.0:          
                temp_f   = flux_iso_W[3]*math.pow(10,-m4*0.400*offs[3])
                W_flux_4 = temp_f
                W_erfl_4 = temp_f*ln10*0.400*em4
                condit4 = True
                
            try:
                pippo = float(geom[0])
                archivo_in.writelines(geom)
                if condit1:
                    #filt_data = " {0} {1} {2}".format(1,W_flux_1,W_erfl_1)
                    filt_data = " {0} {1} {2}".format(1,m1,em1)
                    archivo_in.writelines(filt_data)
                if condit2:
#                    filt_data = " {0} {1} {2}".format(2,W_flux_2,W_erfl_2)
                    filt_data = " {0} {1} {2}".format(2,m2,em2)
                    archivo_in.writelines(filt_data)
                if condit3:
#                    filt_data = " {0} {1} {2}".format(3,W_flux_3,W_erfl_3)
                    filt_data = " {0} {1} {2}".format(3,m3,em3)
                    archivo_in.writelines(filt_data)
                if condit4:
#                    filt_data = " {0} {1} {2}".format(4,W_flux_4,W_erfl_4)
                    filt_data = " {0} {1} {2}".format(4,m4,em4)
                    archivo_in.writelines(filt_data)   
                ret_car = "\n"
                archivo_in.writelines(ret_car)
            except ValueError:
                 pass
        archivo_in.close()
