# Read IRSA/IPAC tables and plot mag vs jd for each filter,
# for each observation of each object.
#
# - Victor M. Ali-Lagoa, IAC, 2011-07-08
#

import sys
import subprocess
import datetime
import math
import numpy as np
from StringIO import StringIO

######################################################################
# s2i = string to float
s2f = lambda x: (float(x))  
# s2i = string to integer
s2i = lambda x: int((float(x)))  


if len(sys.argv) < 2:
    print """
Usage:
  {0} ipac_table.tbl

""".format(sys.argv[0])
    sys.exit(1)

    
ipac_file = sys.argv[1]
if len(sys.argv) > 2:
    object_name = sys.argv[2]
else:
    object_name = 'mag2flux.out'

filter_wl   = 3.3526,  4.6028,  11.5608, 22.0883
flux_iso_Jy = 306.681, 170.663, 29.0448, 8.2839
ln10 = math.log(10.0)

# grep the file to know how many lines we need to consider as "header"
cmd = """grep '\\\\' {0} | wc -l""".format(ipac_file)
pipe = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE).stdout
n_header = int(pipe.read().split()[0])
print "\n{0} header lines will be skipped".format(n_header)

try:
    open_ipac_file = open(ipac_file, 'r')
except IOError, e:
    print "Didn't find file '{0}'\n".format(ipac_file)
    sys.exit(1)
finally:
    pass

col_2use = (3,4,5,6,7,8,9,10,12,13,16,17,20,21,24,25,31,33)
col_index = dict([("desig",0),("mjd_u",1),("ra_u",2),("dec_u",3),("ra",4),("dec",5),("sigra",6),("sigdec",7),("w1mpro",8),("w1sigmpro",9),("w2mpro",10),("w2sigmpro",11),("w3mpro",12),("w3sigmpro",13),("w4mpro",14),("w4sigmpro",15),("ph_qual",16),("mjd",17)])
col_error = np.zeros

mega_struct = np.genfromtxt(open_ipac_file, skip_header = n_header, dtype = None, usecols = col_2use, comments = "|")

cont = 0
cont_m1 = 0
cont_m2 = 0
cont_m3 = 0
cont_m4 = 0

num_rows = len(mega_struct)
print "{0} lines read".format(num_rows)

mjd_u = np.zeros(num_rows)
mjd   = np.zeros(num_rows)
ra_u  = np.zeros(num_rows)
dec_u = np.zeros(num_rows)
ra    = np.zeros(num_rows)
dec   = np.zeros(num_rows)
w1mpro = np.zeros(num_rows)
w2mpro = np.zeros(num_rows)
w3mpro = np.zeros(num_rows)
w4mpro = np.zeros(num_rows)
w1sigmpro = np.zeros(num_rows)
w2sigmpro = np.zeros(num_rows)
w3sigmpro = np.zeros(num_rows)
w4sigmpro = np.zeros(num_rows)
p_q = ' let '*num_rows  
ph_qual = p_q.split()
desig = p_q.split()
err_flag = mjd < 0

for ind in xrange(num_rows):
    try:
        ph_qual[ind] = mega_struct[ind][col_index["ph_qual"]]
        desig[ind]   = mega_struct[ind][col_index["desig"]]
        mjd[ind]     = mega_struct[ind][col_index["mjd"]]
        mjd_u[ind]   = mega_struct[ind][col_index["mjd_u"]]
        ra[ind]      = mega_struct[ind][col_index["ra"]]
        ra_u[ind]    = mega_struct[ind][col_index["ra_u"]]
        dec[ind]     = mega_struct[ind][col_index["dec"]]
        dec_u[ind]   = mega_struct[ind][col_index["dec_u"]]
    except ValueError, e:
        print "Row {0}: {1} ".format(ind, e)
        print "Something is wrong with desig, mjd, ra, dec or ph_qual in this line"
        err_flag[ind] = True
        cont = cont + 1

    try:
        w1sigmpro[ind]  = mega_struct[ind][col_index["w1sigmpro"]]
    except ValueError, e:
        cont_m1 = cont_m1 + 1
        err_flag[ind] = True
                                                     
    try:
        w2sigmpro[ind]  = mega_struct[ind][col_index["w2sigmpro"]]
    except ValueError, e:
        cont_m2 = cont_m2 + 1    
        err_flag[ind] = True

    try:
        w3sigmpro[ind]  = mega_struct[ind][col_index["w3sigmpro"]]
    except ValueError, e:
        cont_m3 = cont_m3 + 1
        err_flag[ind] = True

    try:
        w4sigmpro[ind]  = mega_struct[ind][col_index["w4sigmpro"]]
    except ValueError, e:
        cont_m4 = cont_m4 + 1
        err_flag[ind] = True

print """{0} errors in w1sigmpro;
{1} errors in w2sigmpro;
{2} errors in w3sigmpro;
{3} errors in w4sigmpro;\n""".format(cont_m1,cont_m2,cont_m3,cont_m4)

cont_m1 = 0
cont_m2 = 0
cont_m3 = 0
cont_m4 = 0

for ind in xrange(num_rows):
    try:
        w1mpro[ind]  = mega_struct[ind][col_index["w1mpro"]]
    except ValueError, e:
        cont_m1 = cont_m1 + 1
        err_flag[ind] = True
                                                     
    try:
        w2mpro[ind]  = mega_struct[ind][col_index["w2mpro"]]
    except ValueError, e:
        cont_m2 = cont_m2 + 1
        err_flag[ind] = True    

    try:
        w3mpro[ind]  = mega_struct[ind][col_index["w3mpro"]]
    except ValueError, e:
        cont_m3 = cont_m3 + 1
        err_flag[ind] = True

    try:
        w4mpro[ind]  = mega_struct[ind][col_index["w4mpro"]]
    except ValueError, e:
        cont_m4 = cont_m4 + 1
        err_flag[ind] = True

print """{0} errors in w1mpro;
{1} errors in w2mpro;
{2} errors in w3mpro;
{3} errors in w4mpro;\n""".format(cont_m1,cont_m2,cont_m3,cont_m4)
    
print "{0} + {1} + 4 = {2} total number of lines".format(n_header,num_rows,n_header+num_rows+4)

for i in xrange(num_rows):
    if err_flag[i]:
        pass
        print "line {0}, desig = {1}, ph_qual = {2}".format(i,desig[i],ph_qual[i])

for i in xrange(num_rows):
    if not(err_flag[i]):
        pass
#        print "{0} {1} {2}".format(i,desig[i],ph_qual[i])
# uncomment print to see lines with no errors (X's or U's)








