import matplotlib.pyplot as plt
import sys
import subprocess
import datetime
import math
import numpy as np
from StringIO import StringIO

######################################################################
if len(sys.argv) < 2:
    print """
Find observations of a single numbered asteroid or a list of numbered 
asteroids from an MPCOBS file and print out an IPAC style table of the 
designation, MJD, Ra, Dec.

i)  Usage with asteroid number:
    {0} asteroid_number [mpcobs_file]

ii) Usage with a file containing a single column of asteroid numbers:
    {0} file_name [mpcobs_file] 

NB: option ii) requires a platform that supports signed zeros for the math.copysign() function
""".format(sys.argv[0])
    sys.exit(1)

if len(sys.argv) > 2:
     print "Ignoring everything behind the name of the file.in\n" 

sys_argv1 = sys.argv[1]

file_with_data = open(sys_argv1)

read_cont = file_with_data.readlines()
n_obs = len(read_cont)
file_with_data.close()

conditions = [[[1, 1, 1, 1], ""],
              [[1, 1, 1, 0], ""],
              [[0, 1, 1, 1], ""],
              [[1, 0, 1, 0], "-b 1.1"],       
              [[0, 1, 1, 0], "-b 1.1 -V 1.3"],
              [[0, 0, 1, 0], "-b 1.1 -V 1.3"],
              [[0, 0, 1, 1], "-V 1.3"],       
              [[0, 0, 0, 1], "-b 1.1 -V 1.3"],
              [[0, 1, 0, 1], "-b 1.1 -V 1.3"],
              [[1, 0, 0, 1], "-b 1.1"],       
              [[1, 1, 0, 1], ""]]           
    
for i in xrange(n_obs):
    fltvec=[0,0,0,0]
    line_struct = read_cont[i].split()
    geom = line_struct[0:5]
    filt_data = line_struct[5:]    
    n_filt_data = len(filt_data)
    groupsof3 = n_filt_data/3
    Filter = np.zeros(groupsof3)
    Mag    = np.zeros(groupsof3)
    Emag   = np.zeros(groupsof3)

    for ind in xrange(groupsof3):
        Filter[ind] = filt_data[(ind%3)*3]
        Mag[ind]    = filt_data[(ind%3)*3+1]
        Emag[ind]   = filt_data[(ind%3)*3+2]
        fltvec[int(Filter[ind])-1] = 1

    for i in xrange(len(conditions)):
        if fltvec == conditions[i][0]:
            lsi = ''
            for iii in xrange(len(line_struct)): 
                lsi = lsi+' '+line_struct[iii]

            label2spawn = "echo {0} | ./wisemag2neatm2v -v {1}".format(lsi, conditions[i][1])
            #print label2spawn
            # pipe = subprocess.Popen(label2spawn, shell=True, stdout=subprocess.PIPE).stdout
            ret = subprocess.Popen(label2spawn, shell=True).wait()
    





 

