# Convert IRSA/IPAC magnitudes to flux densities
# 
# - Victor Ali-Lagoa, IAC 2011
#

import sys
import subprocess
import datetime
import math

######################################################################
# s2i = string to float
s2f = lambda x: (float(x))  
# s2i = string to integer
s2i = lambda x: int((float(x)))  


if len(sys.argv) < 2:
    print """
Usage:
  {0} aster_IRSA_IPAC.out Nameofoutputfile

If not specified, default is mag2flux.out
""".format(sys.argv[0])
    sys.exit(1)

    
mag_file = sys.argv[1]
if len(sys.argv) > 2:
    object_name = sys.argv[2]
else:
    object_name = 'mag2flux.out'

wavelength = 3.3526, 4.6028, 11.0984, 22.6405
flux_iso = 306.681, 170.663, 29.0448, 8.2839
ln10 = math.log(10.0)

try:
    arch_ab = open(mag_file, 'r')
except IOError, e:
    print "Didn't find file '{0}'".format(mag_file)
    print "Exited\n"
    sys.exit(1)
finally:
    pass

mag_file_lines = arch_ab.readlines()
arch_ab.close()

num_lines = len(mag_file_lines)
num_cols  = len(mag_file_lines[0].split())

# if there aren't four lines read then something is wrong
if num_lines != len(wavelength):
    print "The number of points read doesn't match the number of filters"
    sys.exit(1)

data_arr_flux = [[0.0,0.0],[0.0,0.0],[0.0,0.0],[0.0,0.0]]

for I in xrange(num_lines):
    temp0 = float(mag_file_lines[I].split()[0])
    temp1 = float(mag_file_lines[I].split()[1])
    temp  = float(flux_iso[I])*(10**(-temp0*0.4000))
    for J in xrange(num_cols):
        if J == 1:            
            data_arr_flux[I][J] = temp*0.4000*temp1*ln10
        else:
            data_arr_flux[I][J] = temp
    print "{0} {1}".format(data_arr_flux[I][0],data_arr_flux[I][1])
 

# cmd = "grep '^{0}' {1}".format(packed_aster, obsfile)
 #pipe = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE).stdout

 #def conv(s):
    # convert MPC obs line to object, date, ra, dec
  #   ss = s.split()
    # return "{0:10} {1} {2}".format(aster, ss[1][1:], ' '.join(ss[2:10]))

# try:
 #    print "\n".join(map(conv, pipe.readlines()[::2]))
# except IndexError:
   #  pass

 # pipe.close()

