# Find observations of a single numbered asteroid from the MPCOBS
# database and print out the Ra, Dec line.
#
# - Michael S. Kelley, UMD, 2011-05-18
#
# 2011-05-19 - Now prints the unpacked designation, rather than the
#              packed designation.  MSK.
#
# - Victor M. Ali-Lagoa, IAC, 2011-06-XX
#
# 2011-07-13 - Added an extra space to the grep to avoid problems
#              with asterisk-marked data and non-wise observations (?)
#              (some rows in the mpcobs_file do not correspond to WISE
#              data and also they break the '% 2' periodicity with which 
#              'find-numbered.py' reads the data. VMAL.
#
# 2011-09-08 - Added the possibility of giving as input an already 
#              packed number


import sys
import subprocess
import datetime

if len(sys.argv) < 2:
    print """
Find observations of a single numbered asteroid from an MPCOBS file
and print out the Ra, Dec line.

The MPCOBS file name is assumed to be total_wise_mpc_list.txt.

Usage:
  {0} asteroid_number [mpcobs_file]
""".format(sys.argv[0])
    sys.exit(1)

aster = sys.argv[1]
if len(sys.argv) > 2:
    obsfile = sys.argv[2]
else:
    obsfile = 'total_wise_mpc_list.txt'

try:
    if int(aster) > 99999:
        # get the packed designation
        letter = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
        # integer division to get the first 2 digits
        pre = int(aster) / 10000 - 10
        packed_aster = letter[pre] + aster[2:]
    else:
        # pad with zeros
        packed_aster = "{0:05d}".format(int(aster))
except ValueError:
    packed_aster = aster

cmd = "grep '^{0} ' {1}".format(packed_aster, obsfile)
pipe = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE).stdout

def conv(s):
    # convert MPC obs line to object, date, ra, dec
    ss = s.split()
    return "{0:10} {1} {2}".format(aster, ss[1][1:], ' '.join(ss[2:10]))

try:
    print "\n".join(map(conv, pipe.readlines()[::2]))
except IndexError:
    pass

pipe.close()
