# Find observations of a single numbered asteroid from the MPCOBS
# database and print out the Ra, Dec line.
#
# - Michael S. Kelley, UMD, 2011-05-18
#
# 2011-05-19 - Now prints the unpacked designation, rather than the
#              packed designation.  MSK.
#
# - Victor M. Ali-Lagoa, IAC, 2011-07
#
# 2011-07-08 - Modified "find-numbered.py" to take as input an aste-
#              roid unnumbered designation in the mpc compact format

import sys
import subprocess
import datetime

if len(sys.argv) < 2:
    print """
Find observations of a single unnumbered asteroid from an MPCOBS file
and print out the Ra, Dec line. The input should be in the MPC packed
format, i.e., 'J98SC7V' instead of '1998 SV127'. For details, check 
the webpage:

http://www.minorplanetcenter.net/iau/info/PackedDes.html

The MPCOBS file name is assumed to be WISEUnnObs.txt (this should have 
no line indentations)

Usage:
  {0} 'asteroid_mpc_designation' [mpcobs_file]
""".format(sys.argv[0])
    sys.exit(1)


packed_aster = sys.argv[1]
if len(sys.argv) > 2:
    obsfile = sys.argv[2]
else:
    obsfile = 'WISEUnnObs.txt'

cmd = "grep '^{0}' {1}".format(packed_aster, obsfile)
pipe = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE).stdout

def conv(s):
    # convert MPC obs line to object, date, ra, dec
    ss = s.split()
    return "{0:10} {1} {2}".format(packed_aster, ss[1][1:], ' '.join(ss[2:10]))

try:
    print "\n".join(map(conv, pipe.readlines()[::2]))
except IndexError:
    pass

pipe.close()
