#
# - Victor M. Ali-Lagoa, IAC, 2011-07-12

import sys

# MPC packed format: 
# http://www.minorplanetcenter.net/iau/info/PackedDes.html

######################################################################
if len(sys.argv) < 2:
    print """
#########################################

Transform MPC-packed minor planet designations into "human" designations. 
For example:
K05X00D ---> 2005 XD

Usage:
i)  Single-asteroid input:
    {0} MPC-packed_desig    

ii) With a file containing a column of asteroid MPC-packed designations
    {0} file_name

#########################################
""".format(sys.argv[0])
    sys.exit(1)

sys_argv1 = sys.argv[1]

if len(sys.argv) > 2:
    print """
Incorrect input. Type either an asteroid MPC-packed 
designation or the name of a file with a single column
"""
    sys.exit(1)

if sys_argv1.isdigit():
    print "You didn't input an MPC-packed designation"
else:
    dicc = dict([('I','18'), ('J','19' ), ( 'K','20')])
    packed_dicc = dict([('A', '10'), ('B', '11'), ('C', '12'), ('D', '13'), ('E', '14'), ('F', '15'), ('G', '16'), ('H', '17'), ('I', '18'), ('J', '19'), ('K', '20'), ('L', '21'), ('M', '22'), ('N', '23'), ('O', '24'), ('P', '25'), ('Q', '26'), ('R', '27'), ('S', '28'), ('T', '29'), ('U', '30'), ('V', '31'), ('W', '32'), ('X', '33'), ('Y', '34'), ('Z', '35'), ('a', '36'), ('b', '37'), ('c', '38'), ('d', '39'), ('e', '40'), ('f', '41'), ('g', '42'), ('h', '43'), ('i', '44'), ('j', '45'), ('k', '46'), ('l', '47'), ('m', '48'), ('n', '49'), ('o', '50'), ('p', '51'), ('q', '52'), ('r', '53'), ('s', '54'), ('t', '55'), ('u', '56'), ('v', '57'), ('w', '58'), ('x', '59'), ('y', '60'), ('z', '61')])
    try:
        file_with_aster = open(sys_argv1)
        for i, aster_line in enumerate(file_with_aster):
#            print "{0}".format(i)
            aster = aster_line.split()
            if len(aster) > 1:
                print "{0} isn't an MPC-packed designation".format(aster)
            else:
                if aster[0].isdigit():
                    print "'{0}' isn't an MPC-packed designation".format(aster[0])
                elif len(aster[0]) == 7:
                    uno = aster[0][0]
                    dos_tres = aster[0][1:3]
                    cuatro = aster[0][3]
                    cinco_seis = aster[0][4:6]
                    siete = aster[0][-1]                        
                    if cinco_seis.isdigit():
                        medio = int(cinco_seis)                            
                    else:
                        medio = int(packed_dicc[cinco_seis[0]])*10 + int(cinco_seis[-1])
                    if medio == 0:
                        unn_desig = packed_dicc[uno]+dos_tres+' '+cuatro+siete
                    else:
                        unn_desig = packed_dicc[uno]+dos_tres+' '+cuatro+siete+str(medio)

                    print "{0} -> {1}".format(aster[0],unn_desig)
                else:
                    print "{0} isn't an MPC-packed designation".format(aster[0])
        file_with_aster.close()
    except IOError:
        ########################
        aster = sys_argv1.split()
        if len(aster) > 1:
            print "{0} isn't an MPC-packed designation".format(aster)
        else:
            if aster[0].isdigit():
                print "'{0}' isn't an MPC-packed designation".format(aster[0])
            elif len(aster[0]) == 7:
                uno = aster[0][0]
                dos_tres = aster[0][1:3]
                cuatro = aster[0][3]
                cinco_seis = aster[0][4:6]
                siete = aster[0][-1]
                if cinco_seis.isdigit():
                    medio = int(cinco_seis)                            
                else:
                    medio = int(packed_dicc[cinco_seis[0]])*10 + int(cinco_seis[-1])
                if medio == 0:
                    unn_desig = packed_dicc[uno]+dos_tres+' '+cuatro+siete
                else:
                    unn_desig = packed_dicc[uno]+dos_tres+' '+cuatro+siete+str(medio)
                print "{0} -> {1}".format(aster[0],unn_desig)
            else:
                print "'{0}' isn't an MPC-packed designation".format(aster[0])                
